/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rEou
 */

// forked from Aquioux's GingerBreadMan Map
// forked from Aquioux's Clifford Attractor (A)
package {
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.events.Event;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
    /**
     * ジンジャーブレッドマン写像（Gingerbreadman Map）
     * @see http://aquioux.net/blog/?p=1384
     * @author YOSHIDA, Akio(Aquioux)
     */
    public class Main extends Sprite {
        
        private var viewer:Viewer;        // ビューア
        private var buttons:Buttons;    // ボタン
        private var sliders:Sliders;    // スライダー
        
        public function Main():void {
            setup();
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        // セットアップ
        private function setup():void {
            // ステージサイズ
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            
            // 写像エンジン初期化
            Engine.setup();
            //Engine.paramRandom();
            
            // ビューアの作成
            viewer = new Viewer();
            viewer.setup(w, h);
            addChild(viewer);
            
            // ボタンの作成
            buttons = new Buttons();
            buttons.setup();
            buttons.action = drawByButton;
            buttons.y = h - 20;
            addChild(buttons);
            
            // スライダーの作成
            sliders = new Sliders();
            sliders.setup();
            sliders.action = drawBySlider;
            sliders.reset();
            addChild(sliders);
        }
        
        // アップデート
        private function update(e:Event):void {
            viewer.update(Engine.update());
        }
        
        // ボタンに起因する描画の実行
        // 写像の変数の値をトゥイーン
        private function drawByButton(values:Vector.<Number>):void {
            Tweener.addTween(Engine, {
                "a":values[0],
                time:.25,
                transition:"easeOutQuadratic",
                onStart:viewer.reset,
                onUpdate:sliders.reset
            });
        }

        // スライダーに起因する描画の実行
        private function drawBySlider():void {
            buttons.reset();
        }
    }
}


//package {
    /**
     * 写像エンジン
     * @author YOSHIDA, Akio(Aquioux)
     */
    /*public*/ class Engine {
        /**
         * 写像計算に使用するパラメータ a
         */
        static public function get a():Number { return _a; }
        static public function set a(value:Number):void {　_a = value;　}
        static private var _a:Number;
        
        /**
         * 写像計算に使用する各パラメータの最小値、最大値、既定値
         */
        static public function get A_MIN():Number     { return PARAMS[0]; }
        static public function get A_MAX():Number     { return PARAMS[1]; }
        static public function get A_DEFAULT():Number { return PARAMS[2]; }
        static private const PARAMS:Vector.<Number> = Vector.<Number>([
            0.000, 6.000, 1.000    // a
        ]);
        
        /**
         * パーティクル数
         */
        static public function get numOfParticle():int { return numOfParticle_; }
        static private var numOfParticle_:int = 10000;
        

        // update() の返り値となる Vector
        static private var data_:Vector.<Number>;
        
        // 漸化式用変数
        static private var x_:Number;        // X座標値
        static private var y_:Number;        // Y座標値
        
        
        /**
         * セットアップ
         */
        static public function setup():void {
            // update() の返り値となる Vector
            data_ = new Vector.<Number>(numOfParticle_ * 2, true);
            // 各パラメータの値を初期化
            paramDefault();
        }
        
        /**
         * パラメータを既定値に戻す
         */
        static public function paramDefault():void {
            _a = A_DEFAULT;
        }
        
        /**
         * パラメータをランダムな値にする
         */
        static public function paramRandom():void {
            _a = Math.random() * (A_MAX - A_MIN) + A_MIN;
        }
        
        /**
         * 写像計算
         * @return    結果の座標を一次元配列で格納した Vector
         */
        static public function update():Vector.<Number> {
            x_ = -0.1;
            y_ = 0.0;
            var len:int = numOfParticle_ * 2;
            for (var i:int = 0; i < len; i += 2) {
                var absx:Number = (x_ < 0) ? -x_ : x_;
                var xn:Number = 1 - y_ + absx * _a;
                var yn:Number = x_;
                data_[i]     = xn;
                data_[i + 1] = yn;
                x_ = xn;
                y_ = yn;
            }
            return data_;
        }
    }
//}



//package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
     * ビューア
     * @author Aquioux(YOSHIDA, Akio)
     */
    /*public*/ class Viewer extends Bitmap {
        /**
         * ColorTransform によるフェードアウトのための定義
         */
        public function set fade(value:ColorTransform):void { _fade = value; }
        private var _fade:ColorTransform = new ColorTransform(0.95, 0.95, 0.95);

        /**
         * Blur filter によるフェードアウトのための定義
         */
        public function set blur(value:BlurFilter):void { _blur = value; }
        private var _blur:BlurFilter = new BlurFilter(8, 8, 3);
        
        // 描画色用の変数
        private var start_:Number = 0.0;        // 開始位置
        private var add_:Number   = 0.5;        // start_ への増分
        private var renge_:Number = 150 / 360;    // 循環色相の範囲（角度）
        private var dir_:int      = 1;            // グラデーションの方向
        
        // BitmapData 関連
        private var bufferBmd_:BitmapData;        // バッファ
        private var rect_:Rectangle;            // ColorTransform, Blur　共用
        private const ZERO_POINT:Point = new Point(0, 0);
        
        // 表示オフセット
        private var offsetX_:Number;            // X座標オフセット
        private var offsetY_:Number;            // Y座標オフセット
        private const OFFSET_SCALE:int = 10;    // スケールオフセット
        
        /**
         * コンストラクタ
         */ 
        public function Viewer() {
        }
        
        /**
         * セットアップ
         * @param    sw    ステージ幅
         * @param    sh    ステージ高
         */
        public function setup(sw:Number, sh:Number):void {
            // BitmapData 関連
            bufferBmd_ = new BitmapData(sw, sh, true, 0xFF000000);
            bitmapData = bufferBmd_.clone();
            rect_ = new Rectangle(0, 0, sw, sh);
            // 各オフセット
            offsetX_ = sw / 2;
            offsetY_ = sh / 2;
            // 描画色関連
            reset();
            // 描画色のアルファ値を設定
            CycleRGB.alpha = 0xCC;
        }
        
        /**
         * アップデート
         * @param    data    描画座標データ
         */
        public function update(data:Vector.<Number>):void {
            // bufferBmd_ の更新
            bufferBmd_.lock();
            bufferBmd_.fillRect(bufferBmd_.rect, 0x00000000);
            var len:uint = data.length;
            start_ += add_;
            for (var i:int = 0; i < len; i += 2) {
                var px:Number = (data[i]     * OFFSET_SCALE + offsetX_) >> 0;
                var py:Number = (data[i + 1] * OFFSET_SCALE + offsetY_) >> 0;
                var offsetColor:Number = (px + py * dir_) * renge_;
                bufferBmd_.setPixel32(px - 20, py - 20, CycleRGB.getColor32(offsetColor + start_));
            }
            bufferBmd_.unlock();
            
            // bitmapData の更新
            bitmapData.lock();
            bitmapData.colorTransform(rect_, _fade);
            bitmapData.applyFilter(bitmapData, rect_, ZERO_POINT, _blur);
            bitmapData.draw(bufferBmd_);
            bitmapData.unlock();
        }
        
        /**
         * 描画色用変数の再設定
         */
        public function reset():void {
            start_ = (Math.random() * 360) >> 0;
            add_   = ((Math.random() * 100 + 10) >> 0) / 100;
            renge_ = ((Math.random() * 180 + 30) >> 00) / 360;
            dir_   = (Math.random() < 0.5) ? -1 : 1;
            dir_   = (Math.random() < 0.3) ? dir_ : 0;
        }
    }
//}


//package {
    import com.bit101.components.HUISlider;
    import com.bit101.components.Slider;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Dictionary;
    /**
     * コントロール用スライダー
     * @author YOSHIDA, Akio(Aquioux)
     */
    /*public*/ class Sliders extends Sprite {
        /**
         * スライダーアクション（外部で定義した処理）
         */
        public function set action(value:Function):void { _action = value; }
        private var _action:Function;
        
        // スライダーの値を小数第何位まで有効にするか
        private const PRECISION:int = 6;
        private const TICK:Number = 1 / Math.pow(10, PRECISION);
        
        // スライダーに対応させるエンジン・プロパティ
        private const PROPS:Array = ["a"];
        private const DELIMITER:String = ":";
        
        // スライダー格納配列
        private var sliders:Dictionary;
        

        /**
         * コンストラクタ
         */
        public function Sliders() {
        }
        
        /**
         * セットアップ
         */
        public function setup():void {
            var params:Vector.<Number> = Vector.<Number>([
                Engine.A_MIN, Engine.A_MAX, Engine.a
            ]);
            
            sliders = new Dictionary();
            for (var i:int = 0; i < PROPS.length; i++) {
                var prop:String = PROPS[i];
                var slider:HUISlider = new HUISlider(this, 25, i * 15, prop + DELIMITER, handler);
                slider.width = 430;
                slider.labelPrecision = PRECISION;
                slider.tick = TICK;
                slider.setSliderParams(params[i * 3], params[i * 3 + 1], params[i * 3 + 2]);
                sliders[prop] = slider;
            }
        }
        
        /**
         * リセット（Engine 内の数値に伴ったスライダー値にリセット）
         */
        public function reset():void {
            for each (var prop:String in PROPS) sliders[prop].value = Engine[prop];
        }
        
        // ハンドラ
        private function handler(e:Event):void {
            var target:HUISlider = HUISlider(e.target);
            var prop:String = target.label.split(DELIMITER)[0];
            
            Engine[prop] = target.value;
            _action();
        }
    }
//}


//package {
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Dictionary;
    /**
     * コントロール用ボタン
     * @author YOSHIDA, Akio(Aquioux)
     */
    /*public*/ class Buttons extends Sprite {
        /**
         * ボタンアクション（外部で定義した処理）
         */
        public function set action(value:Function):void { _action = value; }
        private var _action:Function;
        
        // エンジンのラベルとプロパティ値のペア
        private const PAIR:Array = [
            ["Default",    Vector.<Number>([1.0])    ],
            ["No.1",    Vector.<Number>([0.875])    ],
            ["No.2",    Vector.<Number>([0.913])    ],
            ["No.3",    Vector.<Number>([0.941])    ],
            ["No.4",    Vector.<Number>([1.039])    ],
            ["No.5",    Vector.<Number>([1.054])    ],
            ["No.6",    Vector.<Number>([1.076])    ],
            ["No.7",    Vector.<Number>([1.104])    ],
            ["No.8",    Vector.<Number>([1.343])    ]
        ];
        private var values:Dictionary;

        // 前回押したボタン
        private var prevButton_:PushButton;
        
        /**
         * インストラクタ
         */
        public function Buttons() {
        }
        
        /**
         * セットアップ
         */
        public function setup():void {
            // ボタンの作成
            var buttonWidth:int =  52;
            var buttonHeight:int = 20;
            var idx:int = 0;

            values = new Dictionary();
            for (var x:int = 0; x < PAIR.length; x++) {
                var b:PushButton = new PushButton(this, buttonWidth * x, buttonHeight * y, PAIR[idx][0], handler);
                b.width  = buttonWidth;
                b.height = buttonHeight;
                values[b] = PAIR[idx][1];
                idx++;
            }
        }
        
        /**
         * リセット（前回押したため無効になっているボタンを有効にする）
         */
        public function reset():void {
            if (prevButton_) prevButton_.enabled = true;
        }

        // ハンドラ
        private function handler(e:Event):void {
            var target:PushButton = PushButton(e.target);
            handlerAction(target);
            _action(values[target]);
        }

        /**
         * ボタンアクション（内部で完了する処理）
         * 押されたボタンを押せなくし、前回押したボタンを押せるようにする
         * @param    target    押されたボタン
         * @private
         */
        private function handlerAction(target:PushButton):void {
            reset();
            target.enabled = false;
            prevButton_ = target;
        }
    }
//}


//package aquioux.display.colorUtil {
    /**
     * コサインカーブで色相環的な RGB を計算
     * @author Aquioux(YOSHIDA, Akio)
     */
    /*public*/ class CycleRGB {
        /**
         * 32bit カラーのためのアルファ値（0～255）
         */
        static public function get alpha():uint { return _alpha; }
        static public function set alpha(value:uint):void {
            _alpha = (value > 0xFF) ? 0xFF : value;
        }
        private static var _alpha:uint = 0xFF;
    
        private static const PI:Number = Math.PI;        // 円周率
        private static const DEGREE120:Number  = PI * 2 / 3;    // 120度（弧度法形式）
        
        /**
         * 角度に応じた RGB を得る
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNN）
         */
        public static function getColor(angle:Number):uint {
            var radian:Number = angle * PI / 180;
            var r:uint = (Math.cos(radian)             + 1) * 0xFF >> 1;
            var g:uint = (Math.cos(radian + DEGREE120) + 1) * 0xFF >> 1;
            var b:uint = (Math.cos(radian - DEGREE120) + 1) * 0xFF >> 1;
            return r << 16 | g << 8 | b;
        }
        
        /**
         * 角度に応じた RGB を得る（32bit カラー）
         * @param    angle    HSV のように角度（度数法）を指定
         * @return    色（0xNNNNNNNN）
         */
        public static function getColor32(angle:Number):uint {
            return _alpha << 24 | getColor(angle);
        }
    }
//}
