/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rEeQ
 */

// forked from nutsu's BitmapDataSample10

package 
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.Matrix;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;	
	
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
	/**
	 * ...
	 * @author rettuce
	 */
	public class DocumentClass extends Sprite 
	{
		private var bmpData:BitmapData;
		private var mapImage:BitmapData;
		private var sprite:Sprite;
		private var matrix:Matrix;
		private var ballColor:ColorTransform = new ColorTransform();
		private var filterColor:ColorTransform = new ColorTransform( 0.99999, 0.99999, 0.99999);
		private var blurFilter:BlurFilter;
		private var mapFilter:DisplacementMapFilter;
		private var rad:Number = 0;
		private var txt:TextField;
		private var tf:TextFormat;
		
        private var componentX:uint = BitmapDataChannel.RED;
        private var componentY:uint = BitmapDataChannel.GREEN;
        private var _scaleX:Number  = 0;
        private var _scaleY:Number  = 20;
        private var mapImagePoint:Point;
	    private var mode:String = DisplacementMapFilterMode.IGNORE;
		
		public function DocumentClass()
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);		
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			bmpData = new BitmapData(465, 465, false, 0);
			sprite = newFig(0, 0, 40);
			matrix = new Matrix();
			addChild(new Bitmap(bmpData));
			
			// 初期 text Field セット
			txt = new TextField();
			tf = new TextFormat();
			txt.autoSize = TextFieldAutoSize.CENTER;
			txt.type = TextFieldType.INPUT;
			txt.border = true;
			txt.borderColor = 0xFF666666;
			txt.background = true;
			txt.backgroundColor = 0xFF333333;
			txt.text = "wonderfl";
			tf.size = 100;
			tf.color = 0xFF666666;
			txt.setTextFormat(tf);
			txt.x = (465 - txt.width) / 2;  txt.y = 465 / 2 - txt.height / 2;
			addChild(txt);
			
			txt.addEventListener(KeyboardEvent.KEY_DOWN, start);
		}
		
		private function start(e:KeyboardEvent = null):void 
		{
			if (e.keyCode == 13) // ENTER
			{
				txt.removeEventListener(KeyboardEvent.KEY_DOWN, start);
				removeChild(txt);
				
				// text Field bitmap用 リセット
				txt.border = txt.background = false;
				tf.color = 0xFFFFFFFF;
				txt.setTextFormat(tf);
				matrix.translate( 465 / 2 - 30,  465 / 2 - txt.height / 2);
				mapImage = new BitmapData(465,465);
				mapImage.perlinNoise( 465,465,4,0, false, true );
				mapImage.draw(txt, matrix);
				mapImagePoint = mapImage.rect.topLeft;
				blurFilter = new BlurFilter(4,4);
				mapFilter = new DisplacementMapFilter( mapImage, mapImagePoint, componentX, componentY, _scaleX, _scaleY, mode );
				
				//イベント
				addEventListener(Event.ENTER_FRAME, enterframe);
				stage.addEventListener(MouseEvent.CLICK, clickHandler);
			}
		}
		
		private function enterframe(e:Event):void
		{	
            // 基本描画
			matrix.identity();
			var s:Number = Math.random() * 2;
			matrix.scale(s, s);
			matrix.translate(mouseX + Math.cos(Math.random() * Math.PI) * 50 ,
			                              mouseY+ Math.sin((Math.random()-0.5)*Math.PI) * 50);
			ballColor.greenMultiplier = Math.random();
			ballColor.blueMultiplier = Math.random();
			
            // filter 適用			
			bmpData.applyFilter(bmpData, bmpData.rect, bmpData.rect.topLeft, blurFilter);
			bmpData.applyFilter(bmpData, bmpData.rect, bmpData.rect.topLeft, mapFilter);
			bmpData.colorTransform(bmpData.rect, filterColor);
			bmpData.draw(sprite, matrix, ballColor);
		}
		
		private function clickHandler(e:MouseEvent):void {
			bmpData.fillRect(bmpData.rect, 0xFF000000);
		}
		
		private function newFig(cx:Number, cy:Number, size:Number):Sprite {
			var shape:Sprite = new Sprite();
			shape.graphics.lineStyle(0, 0x000000, .3);
			shape.graphics.beginFill(0xFFFFFFFD);
			shape.graphics.drawCircle(cx, cy, size * .5);
			shape.graphics.endFill();
			return shape;
		}
		
	}
}