/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rE0m
 */

//2010-11-29 18:48:31
package
{
    import flash.display.*;
    import flash.events.*;
    
    import idv.cjcat.stardust.common.actions.Age;
    import idv.cjcat.stardust.common.actions.DeathLife;
    import idv.cjcat.stardust.common.actions.ScaleCurve;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.initializers.Life;
    import idv.cjcat.stardust.common.initializers.Scale;
    import idv.cjcat.stardust.common.math.UniformRandom;
    import idv.cjcat.stardust.twoD.actions.DeathZone;
    import idv.cjcat.stardust.twoD.actions.Move;
    import idv.cjcat.stardust.twoD.actions.Spin;
    import idv.cjcat.stardust.twoD.emitters.Emitter2D;
    import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
    import idv.cjcat.stardust.twoD.initializers.Omega;
    import idv.cjcat.stardust.twoD.initializers.Position;
    import idv.cjcat.stardust.twoD.initializers.Velocity;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
    import idv.cjcat.stardust.twoD.zones.RectZone;
    import idv.cjcat.stardust.twoD.zones.SinglePoint;
    
    
    [SWF(backgroundColor="#ffffff", frameRate="30")] 
    
    public class StardustTest extends Sprite
    {
        private var emitter:Emitter2D;        
        
        public function StardustTest()
        {
            var WIDTH:int = stage.stageWidth;
            var HEIGHT:int = stage.stageHeight;
            
            //1. Clock
            var clock:SteadyClock = new SteadyClock(1);
            
            //2. Emitter
            emitter = new Emitter2D(clock);
            
            //3. Renderer
            var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
            renderer.addEmitter(emitter);
            
            //5. Initializer
            emitter.addInitializer(new DisplayObjectClass(Star));
            emitter.addInitializer(new Position(new SinglePoint(WIDTH/2, HEIGHT/2)));
            emitter.addInitializer(new Velocity(new SpiralZone(0, 0, 4, 15))); 
            emitter.addInitializer(new Life(new UniformRandom(60, 0)));
            
            emitter.addInitializer(new Omega(new UniformRandom(6, 0)));
            emitter.addInitializer(new Scale(new UniformRandom(1, 0)));
            
            //6. Action
            emitter.addAction(new Move());
            emitter.addAction(new Age());
            //emitter.addAction(new DeathLife());
            emitter.addAction(new DeathZone(new RectZone(0, 0, WIDTH, HEIGHT), true));
            
            emitter.addAction(new Spin());
            emitter.addAction(new ScaleCurve(15, 0));
                                    
            //7. Loop
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            emitter.step();
        }
    }
}

//------------------------------------------------------------------------------------------------

import idv.cjcat.stardust.twoD.geom.MotionData2D;
import idv.cjcat.stardust.twoD.zones.Zone;

class SpiralZone extends Zone
{
    public var x:Number;
    public var y:Number;
    public var radius:Number;
    private var theta:Number;
    //public var rotation:Number;
    private var offset:Number;
    
    public function SpiralZone(x:int = 0, y:int = 0, radius:Number = 0, rotation:Number = 1, offset:Number = 0)
    {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.rotation = rotation;
        this.theta =  Math.PI/180 * offset;        
    }
    
    override public function calculateMotionData2D():MotionData2D
    {    
        theta += Math.PI/180 * rotation;
        return new MotionData2D(radius * Math.cos(theta) + x, radius * Math.sin(theta) + y);
    }
}    

//------------------------------------------------------------------------------------------------

import flash.display.Shape;

class Star extends Shape
{
    private const OUTER_RADIUS:Number = 20;
    private const INNER_RADIUS:Number = 12;
    
    public function Star() {
        graphics.beginFill(0xF9C330);
        graphics.moveTo(0, -OUTER_RADIUS);
        for (var i:int = 1; i <= 11; i++) {
            var radius:Number = (i & 1)?(INNER_RADIUS):(OUTER_RADIUS);
            var theta:Number = 0.2 * Math.PI * i;
            graphics.lineTo(radius * Math.sin(theta), radius * -Math.cos(theta));
        }
        graphics.endFill();
    }
}