/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rDbB
 */

package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(width=420, height=440, backgroundColor=0xFFFFFF)]

	/**
	 *
	 *  ActionScript3.0 アニメーションを久し振りに読み直していらた、スプレーペイントツールを発見。
	 * 　これを元に簡易ペントソフトを作成してみました。
	 * 
	 */
	
	public class Main extends Sprite
	{
		private var canvas:BitmapData;
		private var color:uint;
		private var size:Number = 50;
		private var density:Number = 50;
		private var get_color:Color_get = new Color_get();
		private var get_menu:Menu;
		private var get_size:Size_get;
		
		private var bmp:Bitmap;
		public var filter_sw:Boolean = false;
		
		private var scr:Sprite = new Sprite();
		
		public function Main()
		{
			init();
		}
		
		private function init():void
		{			
			scr.graphics.beginFill(0x000000, 0.8);
			scr.graphics.drawRect(0, 0, 420, 440);
			scr.graphics.endFill();
			addChild(scr);
			
			canvas = new BitmapData(400, 360, true, 0xFF000000);
			bmp = new Bitmap(canvas);
			bmp.filters = [new BlurFilter(2, 2, 3)];
			bmp.x = 10;
			bmp.y = 70;
			addChild(bmp);
			
			get_color.x = 10;
			get_color.y = 15;
			addChild(get_color);
			
			
			get_size = new Size_get(this);
			get_size.y = 45;
			get_size.x = 15;
			addChild(get_size);			
			
			get_menu = new Menu(this);
			get_menu.x = 100;
			get_menu.y = 41;
			addChild(get_menu);
			
			scr.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			scr.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseDown(event:MouseEvent):void
		{
//			color = Math.random() * 0xffffff + 0xff000000;
			color = 0xff000000 + 0x0000ff; 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}

		private function onMouseUp(event:MouseEvent):void
		{
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}

		private function onEnterFrame(event:Event):void
		{
			for(var i:int = 0; i < density; i++)
			{
				if (filter_sw) {
					bmp.filters = [new BlurFilter(2, 2, 3)];
				}else {
					bmp.filters = null;
				}
				var angle:Number = Math.random() * Math.PI * 2;
				var radius:Number = Math.random() * get_size.get_size;
				var xpos:Number = (mouseX + Math.cos(angle) * radius) - 10;
				var ypos:Number = (mouseY + Math.sin(angle) * radius) - 70 ;
				color = 0xFF000000 + get_color.colors[get_color.color_num];
				canvas.setPixel32(xpos, ypos, color);
			}
		}
		
		public function stop_act():void {
			scr.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			scr.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp)
		}
		public function start_act():void {
			scr.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			scr.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
	}
}

	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author ...
	 */
	class Color_get extends Sprite
	{
		public var colors:Array = [0x000000, 0x800080, 0x000080, 0x808000, 0x0000FF, 0x808080, 0x008000, 0xC0C0C0,
								   0x008080, 0xFF0000, 0x00FF00, 0xFF00FF, 0x00FFFF, 0xFFFF00, 0x800000, 0xFFFFFF
								  ];
		 public var color_scr:Array = new Array(colors.length);
		 public var color_num:Number = 9;
		 public var crnt_color:Sprite = new Sprite();
		 public var s:Sprite;
		
		public function Color_get() 
		{
			addChild(crnt_color);
			crnt_color_set(colors[9]);
			for (var i:Number = 0; i < colors.length; i++) {
				color_scr[i] = new Sprite;
				color_scr[i].graphics.lineStyle(2, 0xFFFFFF);
				color_scr[i].graphics.beginFill(colors[i], 1);
				color_scr[i].graphics.drawRect(0, 0, 20, 20);
				color_scr[i].graphics.endFill();
				color_scr[i].x = (i * 23) + 30 ;
				color_scr[i].name = i;
				color_scr[i].addEventListener(MouseEvent.CLICK, onClick);
				color_scr[i].buttonMode = true;
				addChild(color_scr[i]);
			}
		}
		public function onClick(evt:MouseEvent):void {
			var num:int = int(evt.target.name);
			crnt_color_set(colors[num]);
		}
		public function crnt_color_set(col:uint):void {
			color_num = 9;
			for (var i:Number = 0; i < colors.length; i++) {
				if (colors[i] == col) {
					color_num = i;
					break;
				}
			}
			crnt_color.graphics.clear();
			crnt_color.graphics.lineStyle(1, 0xFFFFFF);
			crnt_color.graphics.beginFill(col, 1);
			crnt_color.graphics.drawRect(0, 0, 20, 20);
			crnt_color.graphics.endFill();
		}
	}
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * 
	 * ペイントサイズを求めています。
	 * 
	 */
	class Size_get extends Sprite
	{
		public var text:TextField = new TextField();
		public var frm:TextFormat = new TextFormat();
		public var get_size:Number = 3;
		public var sizes:Array = [3, 5, 7, 10, 15, 20, 25, 30, 35];
		public var sp:Sprite = new Sprite();
		public var m_obj:Main;

		public var btns:Array = new Array(sizes.length);
		
		public function Size_get(m:Main) 
		{
			m_obj = m;
			sp.graphics.beginFill(0xFFFFFF, 1);
			sp.graphics.drawCircle(5, 5, 10);
			sp.graphics.endFill();
			this.addChild(sp);
			text.text = "size " + String(get_size) + " px";
			text.x = 20;
			text.y = -5;
			frm.color = 0xFFFFFF;
			text.setTextFormat(frm);
			this.addChild(text);
			sp.buttonMode = true;
			sp.addEventListener(MouseEvent.CLICK, onClick);
		}
		public function onClick(evt:MouseEvent):void {
			trace("onClick ");
			m_obj.stop_act();
			sp.removeEventListener(MouseEvent.CLICK, onClick);
			for (var i:Number = 0; i < sizes.length; i++) {
				btns[i] = new button(100, sizes[i]*2 + 6);
				btns[i].x = 0;
				if (i == 0) {
					btns[i].y = 30;
				}else {
					btns[i].y =  btns[i - 1].y + (sizes[i-1]*2+6);					
				}
//				trace("i " + i + " y " + btns[i].y+" h "+(sizes[i-1]*2+6));
				btns[i].graphics.beginFill(0xFFFFFF, 1);
				btns[i].graphics.drawCircle(50, sizes[i] + 3, sizes[i]);
				btns[i].name =i;
//				trace("name i "+i+" "+btns[i].name)
				this.addChild(btns[i]);
				btns[i].addEventListener(MouseEvent.CLICK, onClick1);
				btns[i].addEventListener(MouseEvent.MOUSE_OVER, onOver);
			}
		}
		public function onClick1(evt:MouseEvent):void {
			var num:int = int(evt.currentTarget.name);
			trace("onClick1 " + num+" btns.length "+btns.length);
			removeEventListener(MouseEvent.CLICK, onClick1);
			removeEventListener(MouseEvent.MOUSE_OVER, onOver);
			text.text = "size " + String(sizes[num]) + " px";
			frm.color = 0xFFFFFF;
			text.setTextFormat(frm);
			get_size = sizes[num];
			for (var i:Number = 0; i < btns.length; i++) {
				removeChild(btns[i]);
			}
			sp.addEventListener(MouseEvent.CLICK, onClick);
			m_obj.start_act();
		}
		public function onOver(evt:MouseEvent):void {
			var num:int = int(evt.currentTarget.name);
			text.text = "size " + String(sizes[num]) + " px";
			frm.color = 0xFFFFFF;
			text.setTextFormat(frm);
		}
	}
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * 
	 *  ビットマップにフィルターをかけるか否かの指定を得ています。
	 * 
	 */
	class Menu extends Sprite 
	{
		public var m_obj:Main;
		private var text:TextField = new TextField();
		private var frm:TextFormat = new TextFormat();
		private var menu:Array = new Array(2);
		
		private var sp:Sprite = new Sprite();
		
		public function Menu(m:Main) 
		{
			trace("Menu");
			m_obj = m;
			sp.graphics.beginFill(0xFFFFFF, 1);
			sp.graphics.drawRect(0, 2, 15, 15);
			sp.graphics.endFill();
			text.text = "Sharp";
			text.x = 20;
			text.width = 50;
			text.height = 20;
			frm.color = 0xFFFFFF;
			text.setTextFormat(frm);
			sp.addChild(text);
			sp.buttonMode = true;
			addChild(sp);			
			sp.addEventListener(MouseEvent.CLICK, onClick);
			
		}
		public function onClick(evt:MouseEvent):void {
//			trace("onClick");
			m_obj.stop_act();
			sp.removeEventListener(MouseEvent.CLICK, onClick);
			for (var i:Number = 0; i <menu.length; i++) {
				menu[i] = new button(50, 20);
				var menu_text:TextField = new TextField();
				var menu_frm:TextFormat = new TextFormat();
				menu_text.x = 10;
				menu[i].addChild(menu_text);
				menu[i].addEventListener(MouseEvent.CLICK, onClick1);
				if (i == 0) {
					menu_text.text = "Blur";
					menu[i].name = "Blur";
				}else {
					menu_text.text = "Sharp";
					menu[i].name = "Sharp";
				}
				menu_frm.color = 0xFFFFFF;
				menu_text.setTextFormat(frm);
				menu[i].x = 15;
				menu[i].y = i * 20 + 32;
				addChild(menu[i]);				
			}
		}
		
		public function onClick1(evt:MouseEvent):void {
//			trace("onClick1");
			var menu_data:String = evt.currentTarget.name;
			text.text = menu_data;
			frm.color = 0xFFFFFF;
			text.setTextFormat(frm);
			if (menu_data == "Blur") {
				m_obj.filter_sw = true;
			}else {
				m_obj.filter_sw = false
			}
			for (var i:Number = 0; i < menu.length; i++) {
				removeChild(menu[i]);
				menu[i].visible = false;
				menu[i].removeEventListener(MouseEvent.CLICK, onClick1);
				menu[i] = null;
			}
			sp.addEventListener(MouseEvent.CLICK, onClick);
			m_obj.start_act();
		}
		
	}	
	import flash.display.Shape;
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	
	/**
	 * 
	 * 利用者からの情報はSimpleButtonで取得しています。
	 * 　ちなみにSimpleButtonは「初めてのActionScript3.0（O'REILLY)」の8章に記載されています。
	 * 
	 */
	class button extends Sprite
	{
		public var s:Sprite;
		public var btn_width:Number;
		public var btn_height:Number;
		
		public function button(w:Number=50,h:Number=20) 
		{
			btn_width = w;
			btn_height = h;
//			trace(btn_height);
			var sb:SimpleButton = creatbtn();
			addChild(sb);
		}
		public function creatbtn():SimpleButton {
			var rtn:SimpleButton = new SimpleButton();
			rtn.upState = creatbox(0x000000);
			rtn.overState = creatbox(0xFF6347);
			rtn.downState = creatbox(0xFFFFFF);
			rtn.hitTestState = rtn.upState;
			return rtn;
		}
		public function creatbox(col:uint):Shape {
			var rtn:Shape = new Shape();
			rtn.graphics.lineStyle(1, 0xFFFFFF);
			rtn.graphics.beginFill(col, 0.3);
			rtn.graphics.drawRect(0, 0, btn_width, btn_height);
			rtn.graphics.endFill();
			return rtn;
		}
	}
		
