/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rCJW
 */

// forked from Kodai.Takashima's flash on 2011-11-19
package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.filters.*;
    
    public class FlashTest extends MovieClip {
        private var glow:GradientGlowFilter;
        private var crossGraphic:Sprite;
        private var nColorFlag:int = 0;
        public function FlashTest() {
            // Create a cross graphic. 
            crossGraphic = new Sprite(); 
            crossGraphic.graphics.lineStyle(); 
            crossGraphic.graphics.beginFill(0xCCCC00); 
            crossGraphic.graphics.drawRect(60, 90, 100, 20); 
            crossGraphic.graphics.drawRect(100, 50, 20, 100); 
            crossGraphic.graphics.endFill(); 
            
            //crossGraphic.graphics.beginFill(0xFF0000, 100); 
            //crossGraphic.graphics.moveTo(0, 0); 
            //crossGraphic.graphics.lineTo(100, 0); 
            //crossGraphic.graphics.lineTo(100, 100); 
            //crossGraphic.graphics.lineTo(0, 100); 
            //crossGraphic.graphics.lineTo(0, 0); 
            //crossGraphic.graphics.endFill(); 
            addChild(crossGraphic); 
             
            // Apply the glow filter to the cross shape. 
            glow = new GradientGlowFilter(); 
            glow.distance = 0;
            glow.angle = 45;
            glow.colors = [0x000000, 0x009922]; 
            glow.alphas = [0, 1]; 
            glow.ratios = [0, 255];
            glow.blurX = 25; 
            glow.blurY = 25; 
            glow.strength = 1;
            glow.quality = BitmapFilterQuality.HIGH; 
            glow.type = BitmapFilterType.OUTER;
             
            crossGraphic.filters = [glow];
            
            this.buttonMode = true;
            this.addEventListener(MouseEvent.CLICK, ChangeGlowColoer);
            this.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        public function ChangeGlowColoer(evt:MouseEvent) :void{
            if(nColorFlag==0){
                glow.colors = [0xFFFFFF, 0xFF0000];
                nColorFlag=1;
                //glow.strength ++;
            }else if(nColorFlag==1) {
                glow.colors = [0xFFFFFF, 0x00FF00];
                nColorFlag=2;
                //glow.strength ++;
            }else if(nColorFlag==2){
                glow.colors = [0xFFFFFF, 0x0000FF];
                nColorFlag=0;
                //glow.strength ++;
            }

            crossGraphic.filters = [glow];
        }

        public function onMouseMove(event:MouseEvent):void 
        { 
            glow.blurX = (stage.mouseX / stage.stageWidth) * 255; 
            glow.blurY = (stage.mouseY / stage.stageHeight) * 255; 
            crossGraphic.filters = [glow]; 
        } 
    }
}