/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rCGn
 */

// forked from 178ep3's RoundPolygon
package
{
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.geom.Point;
    
    public class ExRoundPolygon extends Sprite
    {
        public function ExRoundPolygon()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            var radius:Number = 29;
            var number:int= 465 / radius /1.6 ;
            var cx:Number = radius;
            var cy:Number = radius;
            var roundPolygon:Shape;
            var sidesAmount:Number = 5;
            var angle:Number = Math.PI * 2 / sidesAmount;
            var angleDegree:Number = angle * 180 / Math.PI;
            var angle2:Number = angle * 0.5;
            var angleDegree2:Number = angle2 * 180 / Math.PI;
            var heightt:Number = radius * Math.cos(angle2);
            var side2:Number = radius * Math.sin(angle2);
            var side:Number = side2 * 2;
            var gapX:Number = side * Math.cos(angle);
            var gapY:Number = side * Math.sin(angle);
            gapY = radius + gapY - heightt;
            var hh:Number = radius+heightt;
            var i:uint=0;
            var q:uint = 0;
            var tau:Number = Math.sqrt(5 ) * 0.5 - 0.5;
            var phi:Number = 1 / tau;
            trace( "phi : " + phi );
            trace( "tau : " + tau );
            var roundedRadius:Number = 5;
            var factor:Number = -1;
            var isEvenLine:Boolean = true;
            var startingX:Number = radius;
            var yPos:Number = -hh * 0.5;
            var number2:Number = number * 1.6;
            for(i=0; i<number2; i++)
            {
                isEvenLine = i % 2 == 0;
                factor = isEvenLine? 1: -1;
                startingX = isEvenLine?cx:cx + gapX + side2;
                yPos += isEvenLine?2*heightt:gapY;
                for(q=0; q<number; q++)
                {
                    roundPolygon = addChild(new Shape())as Shape;
                    roundPolygon.x = startingX + q*hh;
                    roundPolygon.y = yPos;
                    roundPolygon.rotation = factor*angleDegree2*0.5;
//                    塗りや線を設定して
                    roundPolygon.graphics.beginFill(isEvenLine?0xff:0xff00 );
                    roundPolygon.graphics.lineStyle(2);
//                    PolygonクラスのdrawRoundPolygonに設定を渡す
                    Polygon.drawRoundPolygon(roundPolygon.graphics,roundedRadius,radius,sidesAmount);
                    roundPolygon.graphics.endFill();
                }
            }
        }

    }
}
    import flash.geom.Point;
    import flash.display.Graphics;
    

class Polygon
{
    public function Polygon(){}
    
    public static function drawPolygon(target:Graphics,width:Number,polygon:uint):void
    {
        var list:Array = getPoint(width,polygon);
        var i:uint=0;
        var len:uint = list.length;
        
        target.moveTo(list[0].x,list[0].y);
        for(i=1; i<len; i++)
        {
            target.lineTo(list[i].x,list[i].y);
        }
        target.lineTo(list[0].x,list[0].y);
        target.endFill();
    }
    
    public static function drawRoundPolygon(target:Graphics,round:uint,width:Number,polygon:uint):void
    {
        var con:Array = getPoint(width,polygon);
        var anc:Array = [];
        var i:uint=0;
        if(round>10)round=10;
        var n:Number = round/20;
        var cLen:uint = con.length;
        
        for(i=0; i<cLen; i++)
        {
            var p:Point = new Point(0,0);
            var q:Point = new Point(0,0);
            if(i==0)
            {
                p = Point.interpolate(con[cLen-1],con[0],n);
                q = Point.interpolate(con[1],con[0],n);
            }
            else if(i==cLen-1)
            {
                p = Point.interpolate(con[i-1],con[i],n);
                q = Point.interpolate(con[0],con[i],n);
            }
            else 
            {
                p = Point.interpolate(con[i-1],con[i],n);
                q = Point.interpolate(con[i+1],con[i],n);
            }
            anc.push(p);
            anc.push(q);
        }
        
        var len:uint = anc.length;
        target.moveTo(anc[0].x,anc[0].y);
        for(i=1; i<len-2; i+=2)
        {
            target.curveTo(con[(i-1)/2].x,con[(i-1)/2].y,anc[i].x,anc[i].y);
            target.lineTo(anc[i+1].x,anc[i+1].y);
        }
        target.curveTo(con[cLen-1].x,con[cLen-1].y,anc[len-1].x,anc[len-1].y);
        target.lineTo(anc[0].x,anc[0].y);
        target.endFill();
    }
    
    private static function getPoint(width:Number,polygon:uint):Array
    {
        var list:Array = [];
        var angle:Number = 360/polygon;
        var i:Number=0;
        for(i=0; i<360; i+=angle)
        {
            var p:Point = Point.polar(width,i*Math.PI/180);
            list.push(p);
        }
        return list
    }
}