/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rBbt
 */

package {
    import flash.display.BlendMode;
    import flash.display.SimpleButton;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private const tf: TextField = new TextField;
        
        public function FlashTest() {
            
            addChild( tf );
            tf.width = stage.stageWidth;
            tf.height = stage.stageHeight;
            
            trace( "Different ways of creation");
            creationTest();
            trace("\nDifferent ways of create & iterate");
            var count: int = 50000;
            creationAndIterateLinkedList(count);
            creationAndIterateArrayAndObjects(count);
        }
        
        public function creationTest(): void {
            var t: Number;
            const c: int = 750000;
            var i: int;
            var xml: XML = <xml dynamic="true"/>
            t = getTimer();
            for( i=0; i<c; ++i ) {
                var a: Object = {
                    a: "string",
                    b: "string",
                    c: 1
                };
            }
            t = getTimer() - t;
            trace("- create objects: " + t + "ms");
            t = getTimer();
            for( i=0; i<c; ++i ) {
                var a: Object = {
                    a: {
                        
                    },
                    b: "string",
                    c: 1
                };
            }
            t = getTimer() - t;
            trace("- create big objects: " + t + "ms");
            t = getTimer();
            for( i=0; i<c; ++i ) {
                var b: Array = ["string", "string", 1];
            }
            t = getTimer() - t;
            trace("- create arrays: " + t + "ms");
            t = getTimer();
            for( i=0; i<c; ++i ) {
                var d: XML = <xml a="string" b="string" c="1" />;
            }
            t = getTimer() - t;
            trace("- create xmls: " + t + "ms");
            t = getTimer();
            for( i=0; i<c; ++i ) {
                var f: MyObj = new MyObj;
                f.a = "string";
                f.b = "string";
                f.c = 1;
            }
            t = getTimer() - t;
            trace("- create custom type: " + t + "ms");
        }
        
        private function trace(text: String):void {
            tf.appendText(text+"\n");
        }
        
        private function creationAndIterateLinkedList(count:int): void {
            var first: ContentItem = new ContentItem;
            var current: ContentItem = first;
            var t: Number = getTimer();
            for( var i: int = 0; i<count; ++i ) {
                var next: ContentItem = new ContentItem;
                next.clazz = TestClass;
                next.properties = {
                    blendMode: BlendMode.ADD,
                    cacheAsBitmap: true,
                    alpha: 1
                };
                next.styles = {
                    fontStyle: "string",
                    content: "string",
                    color: 0xABCABC
                };
                current.next = next;
            }
            current = first.next;
            while( current ) {
                var foo: Object = new current.clazz, properties: Object, styles: Object, propName: String;
                if( (properties = current.properties) ) {
                    for( propName in properties ) {
                        foo[propName] = properties[propName];
                    }
                }
                if( (styles = current.styles) ) {
                    for( propName in styles ) {
                        foo.setStyle(propName, styles[propName]);
                    }
                    
                }
                current = current.next;
            }
            t = getTimer() - t;
            trace("- create and iterate using linked list: " + t + "ms");
        }
        
        
        private function creationAndIterateArrayAndObjects(count:int): void {
            var list: Array = [];
            var t: Number = getTimer();
            for( var i: int = 0; i<count; ++i ) {
                list[i] = {
                    clazz: TestClass,
                    properties: {
                        blendMode: BlendMode.ADD,
                        cacheAsBitmap: true,
                        alpha: 1
                    },
                    styles: {
                        fontStyle: "string",
                        content: "string",
                        color: 0xABCABC
                    }
                };
            }
            var c: int = list.length;
            for( i = 0; i<c; ++i ) {
                var foo: Object, properties: Object, styles: Object, propName: String, current: Object;
                current = list[i];
                foo = new current.clazz;
                if( (properties = current.properties) ) {
                    for( propName in properties ) {
                        foo[propName] = properties[propName];
                    }
                }
                if( (styles = current.styles) ) {
                    for( propName in styles ) {
                        foo.setStyle(propName, styles[propName]);
                    }
                }
                current = current.next;
            }
            t = getTimer() - t;
            trace("- create and iterate using array: " + t + "ms");
        }

    }
}
import flash.display.SimpleButton;

final class MyObj {
    public var a: String;
    public var b: String;
    public var c: int;
}

class TestClass extends SimpleButton {
    public function setStyle(style: String, value: *): void {}
}


final class ContentItem {
    public var next: ContentItem;
    public var clazz: Class;
    public var properties: Object;
    public var styles: Object;
}
