/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rBa7
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
	
	public class Film extends Sprite{
		private static const W:uint = 99;
		private static const H:uint = 99;
		private static const SP:uint = 10;
		private var _canvas:BitmapData;
		private var _perlin:BitmapData;
		private var seed:uint = Math.floor( Math.random()*0xFFFF );
		private var point:Point = new Point(0, 0);
		private var cx:Number = Math.floor(stage.stageWidth/2);
		private var cy:Number = Math.floor(stage.stageHeight/2);
		private var ct:ColorTransform = new ColorTransform( 0, 0.9, 0.9, 0.6, 0, 0, 0, 0);
		private var sibling:Particle = null;
		private var fl:uint = 50;
	
		public function Film(){
			stage.quality = StageQuality.LOW;
			_canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x0);
			_perlin = new BitmapData( W, H, false, 0x0);
			addChild( new Bitmap(_canvas) );
			
			for(var i:uint=0; i<W*H; i++){
				var p:Particle = new Particle( i%W-W/2, Math.floor(i/W)-H/2, 0, sibling);
				sibling = p;
			}
			this.addEventListener( Event.ENTER_FRAME, update);//
		}
		
		private function update( e:Event ):void{
			point.x ++;
			point.y ++;
			_perlin.perlinNoise( _perlin.width, _perlin.height, 2, seed, false, true, 0, true, [point]);
			var last:Particle = sibling;
			_canvas.lock();
			_canvas.colorTransform( _canvas.rect, ct);
			while(sibling){
				var p:Particle = sibling;
				var col:uint = _perlin.getPixel( p.px+W/2, p.py+H/2);
				p.pz = col >> 16;
				var s:Number = fl/(fl + p.pz);
				_canvas.setPixel( p.px*SP*s + cx, p.py*SP*s + cy, col);
				sibling = p.s;
			}
			_canvas.unlock();
			sibling = last;
		}
	}
}

class Particle{
	public var px:Number;
	public var py:Number;
	public var pz:Number;
	public var s:Particle;
	
	function Particle( _px:Number=0, _py:Number=0, _pz:Number=0, _s:Particle=null){
		px = _px;
		py = _py;
		pz = _pz;
		s = _s;
	}
}