/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rBEd
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.ui.Mouse;
    import flash.ui.MouseCursor;
    import flash.ui.MouseCursorData;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0xffffff")]
    
    public class FlashTest extends Sprite {
        private var cursor:Sprite;
        private var vector:Vector.<BitmapData>;
        private var canvas:Bitmap;
        private var bg:BitmapData;
        private var omegaX:Number = 0;
        private var omegaY:Number = 0;
        
        public function FlashTest() {
            addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(evt:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            canvas = new Bitmap();
            addChild(canvas);
            bg = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
            canvas.bitmapData = bg;
            
            cursor = new Sprite();
            cursor.graphics.lineStyle(1,0);
            cursor.graphics.beginFill(0xffffff);
            cursor.graphics.lineTo(0,16);
            cursor.graphics.lineTo(4,13);
            cursor.graphics.lineTo(7,20);
            cursor.graphics.lineTo(10,19);
            cursor.graphics.lineTo(7,11);
            cursor.graphics.lineTo(11,11);
            cursor.graphics.lineTo(0,0);
            cursor.graphics.endFill();
            
            vector = new Vector.<BitmapData>();
            vector[0] = new BitmapData(12, 21, true, 0x00000000);
            vector[0].draw(cursor);
            
            var cursorData:MouseCursorData = new MouseCursorData();
            cursorData.hotSpot = new Point(0,0);
            cursorData.data = vector;
            Mouse.registerCursor('myCursor', cursorData);
            Mouse.cursor = 'myCursor';
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(evt:Event):void
        {
            bg.lock();
            var parts:BitmapData = vector[0];
            omegaX += 1/60;
            omegaY += 1/50;
            var rect:Rectangle = new Rectangle(0, 0, parts.width, parts.height);
            bg.copyPixels(parts, rect, new Point(stage.mouseX + Math.cos(Math.PI * omegaX)*2 , stage.mouseY + Math.sin(Math.PI * omegaY) * 2), null, null, true);
            
            rect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            bg.colorTransform(rect, new ColorTransform(0.95, 0.9, 0.98));
            bg.applyFilter(bg, rect, new Point(0, -1), new BlurFilter(4, 4));
            bg.unlock();
        }
    }
}