/**
 * Copyright kohie_yamashima ( http://wonderfl.net/user/kohie_yamashima )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rBEI
 */

package {
         import flash.display.*;
         import flash.events.*;
         import flash.text.*;
         import flash.geom.*;
         
         
         
         public class FireFlower extends MovieClip {
             
        
         
         var drawmc:MovieClip=new MovieClip();  //花火の粒子を線（点）描するためのMCの作成
         var viewmc:MovieClip=new MovieClip();//全てのBM、MCを表示するMCを作成
         addChild(viewmc);

         //描画の基盤となるBMの作成
         var bm:BitmapData=new BitmapData(540,400,true,0x00000000);
         var bitmap:Bitmap=new Bitmap(bm);
         viewmc.addChild(bitmap);
         
         
         var bm2:BitmapData=new BitmapData(540,400,true,0x0B000000);//余韻を表現するための、半透明の黒いBMの作成

         //赤色をオーバーレイさせるために、maskというインスタンス名の
         //MCを上に覆いかぶさせるために深度の変更を行う
         viewmc.addChild(mask_mc);

         //エネルギーの減少に使用する定数を設定
         var bmp:Number=0.95;
 
         //一つの花火にを形作る粒子の数を設定
         var count:uint=600;

         //粒子データを保管する配列の作成
         var particleList:Array=new Array;

         //マウスダウンしたら花火用の粒子データを生成
         function MouseDownHandler(event:MouseEvent):void {	 
	 var setX:Number=mouseX;
         var setY:Number=mouseY;//クリック位置に花火を移動
	
	 //粒子データを作成
	 for (var i:uint=0; i<count; i++) {
		private private var particle:Object=new Object;
		particle.x=setX;
		particle.y=setY;
		particle.energy=5*Math.random();
		var angle:Number = Math.random()*360;
		var velocity = 8*Math.random();
		particle.vx=Math.cos(angle)*velocity;
		particle.vy=Math.sin(angle)*velocity;
		particleList.push(particle);
	}
}

        //------粒子データにあわせて、描画を行い、BMに反映させる----------
        function EnterFrameHandler(event:Event):void {
 	drawmc.graphics.clear();
	drawmc.graphics.lineStyle(3,0xFFFFFF);
	var n:uint=particleList.length;
	for (var i:uint=0; i<n; i++) {
        var particle:Object=particleList[i];
	if (particle) {
			
        //各粒子のエネルギー量が一定以下の場合削除する
        if (particle.energy<0.1) {
	particle=null;
	particleList.splice(i,1);
	continue;
			}
　　　　　　　with (particle) {
	x+=vx;
	y+=vy;
				
　　　　　　　//時間が経つごとに粒子のエネルギーを減少させる
	energy*=bmp;
	vx*=bmp;
	vy*=bmp;
	vy+=0.05;//仮想重力の入力
			}
			
　　　　　　　//各粒子データを線（点）描する
	drawmc.graphics.moveTo(particle.x,particle.y);
	drawmc.graphics.lineTo(particle.x+0.5,particle.y+0.5);
		}
	}
	
　　　　　　　//半透明の黒いBMを覆いかぶせる
	bm.draw(drawmc);
	//BMに描画したデータを反映
	bm.draw(bm2);
}

　　　　　　　stage.addEventListener(MouseEvent.CLICK,MouseDownHandler);
　　　　　　　stage.addEventListener(Event.ENTER_FRAME,EnterFrameHandler);
            
    }
}