/**
 * Copyright asou_jp ( http://wonderfl.net/user/asou_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rAyd
 */

package 

{

    import flash.display.BitmapData;

    import flash.display.Graphics;

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.display.StageAlign;

    import flash.display.StageScaleMode;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.geom.Matrix;

    import flash.geom.Point;

    /**

     * ...

     * @author asou_jp

     */

    public class LineShape2 extends Sprite

    {

        

        private var _beginPin:Sprite;

        private var _endPin:Sprite;

        

        public function LineShape2() 

        {

            

            _beginPin = new Sprite();

            _endPin = new Sprite();

            

            _beginPin.graphics.beginFill(0);

            _beginPin.graphics.drawCircle(0, 0, 5);

            _beginPin.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDownHandler);

            _endPin.graphics.beginFill(0);

            _endPin.graphics.drawCircle(0, 0, 5);

            _endPin.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDownHandler);

            

            addChild(_beginPin);

            addChild(_endPin);

            

            _beginPin.x = 50;

            _beginPin.y = 50;

            _endPin.x = 200;

            _endPin.y = 50;

            

            _vector = new Vector.<Joint>();
           start();
        }

        

        private function _mouseDownHandler(e:MouseEvent):void 

        {

            e.currentTarget.startDrag();

            stage.addEventListener(MouseEvent.MOUSE_UP, _mouseUpHandler)

        }

        

        private function _mouseUpHandler(e:MouseEvent):void 

        {

            _beginPin.stopDrag();

            _endPin.stopDrag();

            stage.removeEventListener(MouseEvent.MOUSE_UP, _mouseUpHandler)

        }

        

        private const _RASIAN:Number = Math.PI / 180;

        private const _G:Number = .2; 

        private var _circles:Array;

        private var _vector:Vector.<Joint>;

        private var _isPlaying:Boolean;

        

        /**

         * 開始します。
         */

        public function start():void

        {    

            if(_isPlaying)return;

            _isPlaying = true;

            

            

            //ジョイントの作成

            for ( var i:int = 0; i < 5; i++) {

                _vector.push(new Joint(0, i * 50));

                _vector[i].vy = 1;

            }

            

            //EnterFrame開始

            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);

            

        }

        

        public function setX(value:Number):void

        {

            var i:int;

            var len:int = _vector.length;

            for ( i = 0; i < len; i++)

            {

                _vector[i].x = value;

            }

            _beginPin.x = value;

        }

        

        

        /**

         * 停止します。

         */

        public function stop():void

        {

            if (!_isPlaying) return;

            _isPlaying = false;

            removeEventListener(Event.ENTER_FRAME, _enterFrameHandler);

            while (_vector.length) {

                _vector.shift();

            }

            graphics.clear();

        }

        

        private function _enterFrameHandler(e:Event):void 

        {

            var joint:Joint;

            var i:int;

            var len:int;

            

            len = _vector.length;

            

            var p:Point = new Point();

            p.x = _beginPin.x;

            p.y = _beginPin.y;

        

            for ( i = 0; i < len; i++)

            {

                joint = _vector[i];

                joint.x += joint.vx;

                joint.y += joint.vy;

                joint.vx *= 0.99;

                joint.vy *= 0.99;

                joint.vy += _G;    

                

                var dx:Number = joint.x - p.x;

                var dy:Number = joint.y - p.y;

                var d:Number = Math.sqrt( dx*dx + dy*dy );

                var r:Number = Math.atan2(dy, dx) * 180 / Math.PI;

                if (d > 100) {

                    d = 100;

                    joint.x =　p.x +  Math.cos(r * _RASIAN) * d;

                    joint.y = p.y + Math.sin(r * _RASIAN) * d;

                }

                p.x = joint.x;

                p.y = joint.y;

            }

            

            p.x = _endPin.x;

            p.y = _endPin.y;

        

            for ( i = len-1; i >= 0 ; i--)

            {

                joint = _vector[i];

                joint.x += joint.vx;

                joint.y += joint.vy;

                joint.vx *= 0.99;

                joint.vy *= 0.99;

                joint.vy += _G;    

                

                var dx:Number = joint.x - p.x;

                var dy:Number = joint.y - p.y;

                var d:Number = Math.sqrt( dx*dx + dy*dy );

                var r:Number = Math.atan2(dy, dx) * 180 / Math.PI;

                if (d > 100) {

                    d = 100;

                    joint.x =　p.x +  Math.cos(r * _RASIAN) * d;

                    joint.y = p.y + Math.sin(r * _RASIAN) * d;

                }

                p.x = joint.x;

                p.y = joint.y;

            }

            

            var g:Graphics = graphics;

            g.clear();

            g.lineStyle(1,0xe8342f);

            g.moveTo(_beginPin.x, _beginPin.y);

            for ( i = 0; i < _vector.length; i++) {

                if (i < _vector.length-1) {

                    g.curveTo(

                        _vector[i].x,_vector[i].y,

                        (_vector[i].x + _vector[i+1].x)*.5,

                        (_vector[i].y + _vector[i+1].y)*.5

                    );

                }else {

                    g.curveTo(

                        _vector[i].x,_vector[i].y,

                        (_vector[i].x + _endPin.x)*.5,

                        (_vector[i].y + _endPin.y)*.5

                    );

                    g.curveTo(

                        _endPin.x,_endPin.y,

                        (_endPin.x + _endPin.x)*.5,

                        (_endPin.y + _endPin.y)*.5

                    );

                }

            }

        }

        

    }



}





internal class Joint

{

    

    public function Joint(x:Number=0, y:Number=0) {

        this.x = x;

        this.y = y;

        vx = vy = 0;

    }

    

    public var x:Number;

    public var y:Number;

    public var vx:Number;

    public var vy:Number;

    

}