/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r9oJ
 */

// forked from kwkd's アナログ時計
// forked from umhr's flash on 2010-5-7
/**
- lots o' filters for the hands
- changed the hand geometry to the way I like it >_>
- second hand mechanics adjustment
- recolored hands
- reordered hands
- added loadercontext to allow thumbnail capture
*/
/*
アナログ時計背景画像は以下より拝借。
by Sir Simon Milligan
http://www.flickr.com/photos/sirsimonmilligan/2673082587/
*/

package {
	import flash.display.Loader;	
	import flash.display.Sprite;	
	import flash.events.Event;	
	import flash.net.URLRequest;	
	import flash.filters.GlowFilter;
	import flash.filters.DropShadowFilter;
	import flash.system.LoaderContext;
	[SWF(backgroundColor="0xDDDDDD")]	
	public class Main extends Sprite {		
	private var _seconds:Sprite;		
	private var _minutes:Sprite;		
	private var _hours:Sprite;		
	private var _loader:Loader;		
	public function Main() {
			_loader = new Loader();			
			var uRLRequest:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/8/8c/8c81/8c81534251aa07f3a4b523a295dd5bfe60b6c112");			
			_loader.load(uRLRequest, new LoaderContext(true));			
			this.addChild(_loader);
			
			// 秒針
			_seconds = new Sprite();
			_seconds.graphics.beginFill(0x35413F);
			_seconds.graphics.moveTo(-2, 32);
			_seconds.graphics.lineTo(-1, -175);
			_seconds.graphics.lineTo(1, -175);
			_seconds.graphics.lineTo(2, 32);
			_seconds.graphics.lineTo(0, 35);
			_seconds.x = stage.stageWidth/2 + 2; // ステージの大きさ/2で真ん中に配置
			_seconds.y = stage.stageWidth/2; // 上に同じ
			_seconds.filters = [new DropShadowFilter(3, 180, 0x000000, 0.5, 4, 4)];//, new GlowFilter(0xffffff, 0.3, 4, 4)];

			// 分針
			_minutes = new Sprite();
			_minutes.graphics.beginFill(0x89856A);
			_minutes.graphics.moveTo(-4, 6);
			_minutes.graphics.lineTo(-1, -150);
			_minutes.graphics.lineTo(1, -150);
			_minutes.graphics.lineTo(4, 6);
			_minutes.graphics.lineTo(0, 12);
			_minutes.x = stage.stageWidth/2 + 1; // ステージの大きさ/2で真ん中に配置
			_minutes.y = stage.stageWidth/2; // 上に同じ
			_minutes.filters = [new DropShadowFilter(2, 180, 0x000000, 0.5, 3, 3)];

			// 時針
			_hours = new Sprite();
			_hours.graphics.beginFill(0xEBEEE7);
			_hours.graphics.moveTo(-6, 0);
			_hours.graphics.lineTo(-1, -110);
			_hours.graphics.lineTo(1, -110);
			_hours.graphics.lineTo(6, 0);
			_hours.graphics.lineTo(0, 8);
			_hours.x = stage.stageWidth/2; // ステージの大きさ/2で真ん中に配置
			_hours.y = stage.stageWidth/2; // 上に同じ
			_hours.filters = [new DropShadowFilter(1, 180, 0x000000, 0.3, 2, 2), new GlowFilter(0xEBEEE7, 0.4, 8, 8)]
			
			this.addChild(_hours);			
			this.addChild(_minutes);	
			this.addChild(_seconds);		

			this.addEventListener(Event.ENTER_FRAME,onEnter);
		}
		private function onComplete(event:Event):void {			addChild(_loader);		}
		private function onEnter(event:Event):void {
			var date:Date = new Date();
			var rs:Number, rm:Number, rh:Number;
			rs = date.getSeconds()*6;	// [秒] 戻り値0-59で360°→ 6倍
			var ms:Number = date.getMilliseconds(); // I'm mortally afraid of tweening libraries
			if (ms < 20)
				rs += 0.5;
			else if (ms > 980)
				rs += 2;
			rm = date.getMinutes()*6 + rs / 60;	// [分] 戻り値0-59で360°→ 6倍
			// [時]
			// date.getHours()の戻り値: 0-23
			// (分岐)戻り値0〜11の場合: そのまま
			// (分岐)戻り値12〜23の場合: 戻り値から-12
			// ↑の分岐で戻り値が0〜11の12個になったので360/12=30、30倍すればOK
			rh = date.getHours()%12*30 + rm / 12;
			
			_seconds.rotation = rs;
			_minutes.rotation = rm;
			_hours.rotation = rh;
		}
	}
}
