/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r9iI
 */

/**
 * SWF のバージョンなどをチェックするやつ。
 */
package
{
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.Window;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.net.FileFilter;
    import flash.net.FileReference;
    import org.libspark.swfassist.io.ByteArrayInputStream;
    import org.libspark.swfassist.io.DataInput;
    import org.libspark.swfassist.swf.io.ReadingContext;
    import org.libspark.swfassist.swf.io.SWFReader;
    import org.libspark.swfassist.swf.structures.SWF;
    
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class FlashTest extends Sprite
    {
        private var file: FileReference;
        private var btn:PushButton;
        private var resultWindow:Window;
        private var frameRate:InputText;
        private var frameSize:InputText;
        private var numFrames:InputText;
        private var swfVersion:InputText;
        
        public function FlashTest()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            btn = new PushButton(this, 0, 0, "load swf file", onClick);
            file = new FileReference();
            file.addEventListener(Event.SELECT, onSelect);
            file.addEventListener(Event.COMPLETE, onComp);
            resultWindow = new Window(this, 165 / 2, 165 / 2, "Result");
            resultWindow.setSize(300, 300);
            var hbox: HBox, label: Label;
            
            hbox = new HBox(resultWindow.content);
            hbox.spacing = 10;
            hbox.move(20, 20);
            label = new Label(hbox, 0, 0, "Frame Rate : ");
            frameRate = new InputText(hbox, 0, 0, "");
            frameRate.enabled = false;
            
            hbox = new HBox(resultWindow.content);
            hbox.spacing = 10;
            hbox.move(20, 50);
            label = new Label(hbox, 0, 0, "Frame Size : ");
            frameSize = new InputText(hbox, 0, 0, "");
            frameSize.enabled = false;
            
            hbox = new HBox(resultWindow.content);
            hbox.spacing = 10;
            hbox.move(20, 80);
            label = new Label(hbox, 0, 0, "Num of Frames : ");
            numFrames = new InputText(hbox, 0, 0, "");
            numFrames.enabled = false;
            
            hbox = new HBox(resultWindow.content);
            hbox.spacing = 10;
            hbox.move(20, 110);
            label = new Label(hbox, 0, 0, "SWF Version : ");
            swfVersion = new InputText(hbox, 0, 0, "");
            swfVersion.enabled = false;
            
            
        }
        
        private function onClick(e: Event):void
        {
            file.browse([new FileFilter("load swf file", "*.swf")]);
        }
        
        private function onSelect(e: Event):void 
        {
            removeChild(btn);
            file.load();
        }
        
        private function onComp(e: Event): void 
        {
            var input: DataInput = new ByteArrayInputStream(file.data);
            var context: ReadingContext = new ReadingContext();
            var reader: SWFReader = new SWFReader();
            var swf: SWF = reader.readSWF(input, context);
            frameRate.text = "" + swf.header.frameRate;
            frameSize.text = swf.header.frameSize.xMin + " " + swf.header.frameSize.xMax + " " + 
                             swf.header.frameSize.yMin + " " + swf.header.frameSize.yMax;
            numFrames.text = "" + swf.header.numFrames;
            swfVersion.text = "" + swf.header.version;
            addChild(btn);
        }
    }
}