/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r9aV
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	

        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			
			var comListString:String = '[{"col":16777113,"time":3926,"fx":223,"fy":80,"type":"draw","childlist":[{"y":81,"time":4040,"x":222},{"y":84,"time":4082,"x":220},{"y":87,"time":4103,"x":218},{"y":89,"time":4124,"x":218},{"y":91,"time":4146,"x":215},{"y":93,"time":4166,"x":214},{"y":94,"time":4187,"x":214},{"y":94,"time":4208,"x":212},{"y":95,"time":4229,"x":212},{"y":99,"time":4250,"x":209},{"y":103,"time":4271,"x":203},{"y":104,"time":4292,"x":201},{"y":108,"time":4332,"x":197},{"y":109,"time":4353,"x":197},{"y":110,"time":4416,"x":196},{"y":110,"time":4456,"x":195},{"y":111,"time":4477,"x":195},{"y":111,"time":4742,"x":198},{"y":111,"time":4763,"x":199},{"y":111,"time":4784,"x":200},{"y":110,"time":4805,"x":204},{"y":110,"time":4825,"x":207},{"y":109,"time":4845,"x":208},{"y":109,"time":4865,"x":209},{"y":109,"time":4885,"x":211},{"y":109,"time":4948,"x":213},{"y":109,"time":4969,"x":215},{"y":109,"time":4989,"x":217},{"y":109,"time":5030,"x":218},{"y":108,"time":5050,"x":225},{"y":108,"time":5071,"x":229},{"y":107,"time":5092,"x":231},{"y":107,"time":5112,"x":235},{"y":107,"time":5133,"x":239},{"y":106,"time":5153,"x":242},{"y":106,"time":5214,"x":244},{"y":105,"time":5236,"x":244},{"y":105,"time":5441,"x":240},{"y":105,"time":5462,"x":236},{"y":105,"time":5482,"x":228},{"y":103,"time":5502,"x":224},{"y":103,"time":5522,"x":220},{"y":102,"time":5542,"x":214},{"y":102,"time":5563,"x":211},{"y":101,"time":5583,"x":207},{"y":100,"time":5626,"x":205},{"y":99,"time":5668,"x":203},{"y":98,"time":5689,"x":203},{"y":98,"time":5710,"x":201},{"y":97,"time":5732,"x":200},{"y":97,"time":5752,"x":199},{"y":93,"time":5773,"x":197},{"y":93,"time":5814,"x":196},{"y":92,"time":5834,"x":195},{"y":91,"time":5855,"x":194},{"y":90,"time":5875,"x":193},{"y":89,"time":5916,"x":193},{"y":89,"time":5957,"x":192},{"y":90,"time":6184,"x":193},{"y":92,"time":6205,"x":194},{"y":94,"time":6226,"x":196},{"y":97,"time":6246,"x":200},{"y":99,"time":6267,"x":202},{"y":102,"time":6287,"x":204},{"y":104,"time":6307,"x":207},{"y":106,"time":6328,"x":207},{"y":108,"time":6349,"x":209},{"y":108,"time":6369,"x":210},{"y":109,"time":6390,"x":210},{"y":109,"time":6430,"x":211},{"y":113,"time":6450,"x":213},{"y":114,"time":6471,"x":215},{"y":116,"time":6492,"x":216},{"y":118,"time":6512,"x":218},{"y":119,"time":6532,"x":219},{"y":122,"time":6553,"x":221},{"y":124,"time":6573,"x":222},{"y":126,"time":6635,"x":223},{"y":126,"time":6675,"x":224},{"y":123,"time":6882,"x":224},{"y":118,"time":6903,"x":224},{"y":116,"time":6924,"x":223},{"y":113,"time":6944,"x":223},{"y":112,"time":6964,"x":223},{"y":108,"time":6984,"x":222},{"y":107,"time":7025,"x":222},{"y":104,"time":7066,"x":222},{"y":102,"time":7087,"x":222},{"y":100,"time":7108,"x":222},{"y":99,"time":7129,"x":222},{"y":98,"time":7170,"x":222},{"y":97,"time":7192,"x":222},{"y":96,"time":7213,"x":222},{"y":94,"time":7233,"x":222},{"y":93,"time":7254,"x":221},{"y":92,"time":7295,"x":221},{"y":91,"time":7316,"x":221},{"y":90,"time":7336,"x":221},{"y":89,"time":7378,"x":220}],"id":0},{"col":16777113,"time":8351,"fx":323,"fy":55,"type":"draw","childlist":[{"y":55,"time":8471,"x":324},{"y":56,"time":8491,"x":324},{"y":58,"time":8511,"x":324},{"y":59,"time":8533,"x":324},{"y":64,"time":8554,"x":321},{"y":70,"time":8574,"x":319},{"y":72,"time":8616,"x":319},{"y":79,"time":8649,"x":314},{"y":81,"time":8668,"x":313},{"y":85,"time":8687,"x":311},{"y":87,"time":8706,"x":310},{"y":89,"time":8727,"x":310},{"y":93,"time":8747,"x":308},{"y":94,"time":8768,"x":308},{"y":96,"time":8790,"x":307},{"y":98,"time":8810,"x":306},{"y":100,"time":8831,"x":306},{"y":107,"time":8871,"x":304},{"y":108,"time":8891,"x":304},{"y":107,"time":9088,"x":304},{"y":105,"time":9109,"x":306},{"y":102,"time":9129,"x":309},{"y":101,"time":9150,"x":309},{"y":99,"time":9171,"x":312},{"y":98,"time":9212,"x":314},{"y":96,"time":9254,"x":316},{"y":95,"time":9275,"x":320},{"y":95,"time":9316,"x":322},{"y":95,"time":9336,"x":323},{"y":92,"time":9356,"x":325},{"y":92,"time":9377,"x":326},{"y":91,"time":9418,"x":327},{"y":91,"time":9450,"x":328},{"y":90,"time":9469,"x":329},{"y":89,"time":9513,"x":331},{"y":87,"time":9534,"x":332},{"y":86,"time":9553,"x":333},{"y":84,"time":9573,"x":336},{"y":83,"time":9613,"x":338},{"y":81,"time":9655,"x":340},{"y":81,"time":9909,"x":339},{"y":79,"time":9930,"x":337},{"y":79,"time":9951,"x":334},{"y":79,"time":9971,"x":333},{"y":79,"time":9992,"x":327},{"y":79,"time":10012,"x":325},{"y":79,"time":10052,"x":324},{"y":79,"time":10073,"x":323},{"y":79,"time":10150,"x":322},{"y":78,"time":10170,"x":319},{"y":78,"time":10191,"x":318},{"y":77,"time":10231,"x":315},{"y":77,"time":10292,"x":313},{"y":76,"time":10313,"x":313},{"y":76,"time":10361,"x":311},{"y":76,"time":10381,"x":309},{"y":76,"time":10421,"x":308},{"y":76,"time":10460,"x":307},{"y":74,"time":10481,"x":307},{"y":74,"time":10502,"x":306},{"y":74,"time":10523,"x":305},{"y":74,"time":10570,"x":304},{"y":73,"time":10651,"x":304},{"y":73,"time":10671,"x":303},{"y":73,"time":10757,"x":302},{"y":76,"time":10901,"x":303},{"y":78,"time":10922,"x":305},{"y":85,"time":10953,"x":310},{"y":87,"time":10973,"x":311},{"y":92,"time":10996,"x":316},{"y":94,"time":11015,"x":318},{"y":96,"time":11036,"x":320},{"y":98,"time":11056,"x":322},{"y":98,"time":11077,"x":323},{"y":99,"time":11097,"x":324},{"y":102,"time":11117,"x":325},{"y":105,"time":11158,"x":326},{"y":107,"time":11200,"x":328},{"y":110,"time":11261,"x":330},{"y":110,"time":11281,"x":331},{"y":103,"time":11493,"x":329},{"y":99,"time":11514,"x":328},{"y":93,"time":11556,"x":327},{"y":83,"time":11576,"x":325},{"y":82,"time":11596,"x":325},{"y":80,"time":11637,"x":325},{"y":79,"time":11657,"x":325},{"y":76,"time":11678,"x":324},{"y":75,"time":11701,"x":324},{"y":74,"time":11721,"x":324},{"y":72,"time":11754,"x":324},{"y":69,"time":11774,"x":323},{"y":65,"time":11797,"x":323},{"y":63,"time":11816,"x":323},{"y":62,"time":11837,"x":323},{"y":61,"time":11917,"x":323}],"id":0},{"col":16777113,"time":13198,"fx":105,"fy":132,"type":"draw","childlist":[{"y":132,"time":13450,"x":104},{"y":133,"time":13477,"x":104},{"y":135,"time":13496,"x":101},{"y":135,"time":13516,"x":100},{"y":136,"time":13536,"x":98},{"y":138,"time":13557,"x":94},{"y":141,"time":13579,"x":91},{"y":142,"time":13600,"x":89},{"y":144,"time":13621,"x":88},{"y":144,"time":13642,"x":84},{"y":146,"time":13662,"x":82},{"y":148,"time":13702,"x":80},{"y":148,"time":13786,"x":79},{"y":150,"time":14016,"x":84},{"y":151,"time":14037,"x":88},{"y":152,"time":14057,"x":93},{"y":152,"time":14078,"x":97},{"y":152,"time":14101,"x":104},{"y":153,"time":14122,"x":108},{"y":153,"time":14143,"x":111},{"y":154,"time":14162,"x":114},{"y":154,"time":14183,"x":115},{"y":154,"time":14223,"x":116},{"y":155,"time":14244,"x":116},{"y":155,"time":14265,"x":117},{"y":153,"time":14492,"x":116},{"y":151,"time":14513,"x":113},{"y":150,"time":14533,"x":112},{"y":148,"time":14553,"x":109},{"y":147,"time":14573,"x":108},{"y":146,"time":14593,"x":107},{"y":143,"time":14614,"x":104},{"y":142,"time":14634,"x":103},{"y":141,"time":14655,"x":102},{"y":140,"time":14697,"x":101},{"y":140,"time":14738,"x":100},{"y":139,"time":14779,"x":100},{"y":139,"time":14800,"x":99},{"y":138,"time":14821,"x":99},{"y":137,"time":14842,"x":98},{"y":135,"time":14884,"x":97},{"y":134,"time":14904,"x":96},{"y":133,"time":14924,"x":96},{"y":132,"time":14965,"x":95},{"y":131,"time":15049,"x":95},{"y":134,"time":15385,"x":94},{"y":138,"time":15426,"x":94},{"y":143,"time":15466,"x":94},{"y":147,"time":15508,"x":95},{"y":149,"time":15528,"x":96},{"y":150,"time":15549,"x":96},{"y":151,"time":15569,"x":97},{"y":154,"time":15590,"x":97},{"y":155,"time":15611,"x":97},{"y":157,"time":15631,"x":99},{"y":159,"time":15652,"x":99},{"y":167,"time":15672,"x":99},{"y":169,"time":15692,"x":100},{"y":172,"time":15734,"x":100},{"y":173,"time":15797,"x":100},{"y":172,"time":15989,"x":101},{"y":168,"time":16009,"x":101},{"y":160,"time":16029,"x":102},{"y":157,"time":16050,"x":103},{"y":154,"time":16070,"x":104},{"y":152,"time":16091,"x":104},{"y":148,"time":16111,"x":105},{"y":146,"time":16133,"x":105},{"y":143,"time":16153,"x":105},{"y":141,"time":16194,"x":105},{"y":140,"time":16215,"x":105},{"y":136,"time":16236,"x":105},{"y":135,"time":16277,"x":105},{"y":134,"time":16297,"x":105},{"y":133,"time":16317,"x":105},{"y":132,"time":16361,"x":105},{"y":131,"time":16401,"x":105},{"y":131,"time":16422,"x":106},{"y":130,"time":16463,"x":106}],"id":0},{"col":16777113,"time":18846,"fx":174,"fy":28,"type":"draw","childlist":[{"y":28,"time":18999,"x":173},{"y":30,"time":19041,"x":171},{"y":32,"time":19083,"x":171},{"y":34,"time":19103,"x":169},{"y":38,"time":19124,"x":165},{"y":39,"time":19182,"x":164},{"y":41,"time":19222,"x":161},{"y":42,"time":19263,"x":161},{"y":42,"time":19283,"x":157},{"y":44,"time":19323,"x":157},{"y":46,"time":19343,"x":153},{"y":48,"time":19384,"x":152},{"y":48,"time":19403,"x":150},{"y":51,"time":19421,"x":149},{"y":52,"time":19461,"x":148},{"y":53,"time":19517,"x":148},{"y":53,"time":19537,"x":147},{"y":57,"time":19558,"x":144},{"y":61,"time":19578,"x":143},{"y":61,"time":19803,"x":144},{"y":61,"time":19823,"x":145},{"y":61,"time":19844,"x":146},{"y":59,"time":19865,"x":150},{"y":57,"time":19885,"x":156},{"y":56,"time":19905,"x":160},{"y":55,"time":19925,"x":166},{"y":55,"time":19964,"x":167},{"y":54,"time":19984,"x":167},{"y":54,"time":20003,"x":168},{"y":54,"time":20023,"x":169},{"y":54,"time":20043,"x":170},{"y":54,"time":20063,"x":172},{"y":53,"time":20085,"x":174},{"y":53,"time":20105,"x":175},{"y":52,"time":20184,"x":178},{"y":52,"time":20204,"x":181},{"y":52,"time":20225,"x":184},{"y":51,"time":20562,"x":184},{"y":50,"time":20585,"x":181},{"y":49,"time":20604,"x":177},{"y":47,"time":20624,"x":173},{"y":47,"time":20685,"x":172},{"y":46,"time":20705,"x":171},{"y":46,"time":20745,"x":170},{"y":45,"time":20789,"x":168},{"y":45,"time":20809,"x":165},{"y":45,"time":20830,"x":163},{"y":44,"time":20850,"x":163},{"y":44,"time":20886,"x":162},{"y":43,"time":20905,"x":160},{"y":43,"time":20945,"x":159},{"y":41,"time":20986,"x":155},{"y":38,"time":21005,"x":153},{"y":38,"time":21023,"x":151},{"y":38,"time":21042,"x":150},{"y":37,"time":21080,"x":150},{"y":36,"time":21120,"x":148},{"y":35,"time":21173,"x":147},{"y":35,"time":21195,"x":145},{"y":38,"time":21409,"x":146},{"y":39,"time":21430,"x":146},{"y":41,"time":21450,"x":146},{"y":46,"time":21471,"x":148},{"y":49,"time":21494,"x":149},{"y":57,"time":21514,"x":153},{"y":59,"time":21534,"x":155},{"y":60,"time":21558,"x":155},{"y":62,"time":21579,"x":156},{"y":65,"time":21622,"x":157},{"y":66,"time":21643,"x":158},{"y":68,"time":21664,"x":158},{"y":71,"time":21726,"x":160},{"y":72,"time":21746,"x":160},{"y":73,"time":21767,"x":161},{"y":74,"time":21830,"x":161},{"y":71,"time":22043,"x":161},{"y":69,"time":22087,"x":162},{"y":68,"time":22106,"x":162},{"y":66,"time":22127,"x":162},{"y":64,"time":22147,"x":163},{"y":62,"time":22167,"x":163},{"y":61,"time":22208,"x":163},{"y":60,"time":22229,"x":164},{"y":59,"time":22269,"x":164},{"y":58,"time":22294,"x":164},{"y":57,"time":22334,"x":164},{"y":56,"time":22394,"x":165},{"y":54,"time":22415,"x":165},{"y":51,"time":22455,"x":166},{"y":48,"time":22476,"x":167},{"y":46,"time":22496,"x":167},{"y":45,"time":22538,"x":167},{"y":44,"time":22558,"x":168},{"y":42,"time":22588,"x":168},{"y":36,"time":22630,"x":170},{"y":35,"time":22649,"x":170},{"y":29,"time":22669,"x":172},{"y":28,"time":22694,"x":172},{"y":26,"time":22735,"x":173},{"y":25,"time":22778,"x":173}],"id":0},{"col":16777113,"time":25109,"fx":395,"fy":140,"type":"draw","childlist":[{"y":140,"time":25199,"x":397},{"y":144,"time":25262,"x":394},{"y":149,"time":25282,"x":390},{"y":155,"time":25302,"x":385},{"y":158,"time":25343,"x":382},{"y":160,"time":25366,"x":379},{"y":162,"time":25386,"x":377},{"y":165,"time":25429,"x":375},{"y":167,"time":25450,"x":373},{"y":169,"time":25493,"x":370},{"y":172,"time":25534,"x":367},{"y":173,"time":25557,"x":366},{"y":174,"time":25598,"x":364},{"y":175,"time":25621,"x":364},{"y":176,"time":25662,"x":363},{"y":177,"time":25683,"x":363},{"y":177,"time":25703,"x":362},{"y":179,"time":25724,"x":362},{"y":180,"time":25744,"x":360},{"y":181,"time":25786,"x":359},{"y":181,"time":25973,"x":360},{"y":181,"time":26010,"x":362},{"y":180,"time":26030,"x":367},{"y":178,"time":26050,"x":375},{"y":178,"time":26108,"x":378},{"y":178,"time":26127,"x":380},{"y":176,"time":26147,"x":388},{"y":175,"time":26166,"x":392},{"y":175,"time":26185,"x":397},{"y":175,"time":26205,"x":399},{"y":175,"time":26226,"x":403},{"y":174,"time":26267,"x":405},{"y":174,"time":26288,"x":406},{"y":173,"time":26311,"x":409},{"y":173,"time":26350,"x":412},{"y":172,"time":26569,"x":412},{"y":170,"time":26590,"x":409},{"y":170,"time":26610,"x":407},{"y":169,"time":26630,"x":406},{"y":166,"time":26650,"x":398},{"y":164,"time":26671,"x":396},{"y":162,"time":26712,"x":390},{"y":160,"time":26732,"x":387},{"y":158,"time":26751,"x":383},{"y":158,"time":26771,"x":382},{"y":157,"time":26813,"x":380},{"y":156,"time":26854,"x":377},{"y":156,"time":26874,"x":376},{"y":155,"time":26894,"x":376},{"y":155,"time":26914,"x":375},{"y":155,"time":26955,"x":374},{"y":153,"time":26975,"x":372},{"y":153,"time":27029,"x":371},{"y":152,"time":27068,"x":371},{"y":152,"time":27151,"x":370},{"y":156,"time":27404,"x":371},{"y":159,"time":27444,"x":373},{"y":164,"time":27464,"x":376},{"y":172,"time":27486,"x":380},{"y":174,"time":27512,"x":381},{"y":175,"time":27533,"x":382},{"y":178,"time":27553,"x":383},{"y":181,"time":27573,"x":384},{"y":182,"time":27594,"x":386},{"y":184,"time":27615,"x":386},{"y":187,"time":27635,"x":387},{"y":190,"time":27655,"x":388},{"y":190,"time":27674,"x":389},{"y":192,"time":27696,"x":389},{"y":193,"time":27715,"x":390},{"y":194,"time":27735,"x":391},{"y":195,"time":27775,"x":391},{"y":196,"time":27808,"x":391},{"y":195,"time":28092,"x":392},{"y":191,"time":28113,"x":392},{"y":190,"time":28136,"x":392},{"y":189,"time":28174,"x":392},{"y":188,"time":28218,"x":392},{"y":187,"time":28239,"x":392},{"y":185,"time":28261,"x":392},{"y":184,"time":28282,"x":392},{"y":182,"time":28304,"x":392},{"y":180,"time":28326,"x":392},{"y":179,"time":28367,"x":392},{"y":177,"time":28390,"x":392},{"y":175,"time":28411,"x":392},{"y":173,"time":28432,"x":392},{"y":171,"time":28453,"x":392},{"y":167,"time":28493,"x":392},{"y":166,"time":28515,"x":392},{"y":162,"time":28535,"x":392},{"y":161,"time":28554,"x":392},{"y":157,"time":28575,"x":393},{"y":156,"time":28598,"x":393},{"y":153,"time":28619,"x":393},{"y":149,"time":28639,"x":394},{"y":147,"time":28662,"x":394},{"y":145,"time":28703,"x":394},{"y":143,"time":28746,"x":394},{"y":142,"time":28810,"x":394}],"id":0},{"col":16763904,"time":34765,"fx":114,"fy":329,"type":"draw","childlist":[{"y":328,"time":34843,"x":114},{"y":326,"time":34861,"x":114},{"y":324,"time":34881,"x":114},{"y":322,"time":34903,"x":114},{"y":320,"time":34923,"x":114},{"y":318,"time":34962,"x":114},{"y":315,"time":34981,"x":114},{"y":314,"time":35021,"x":114},{"y":313,"time":35063,"x":114},{"y":312,"time":35102,"x":114},{"y":311,"time":35160,"x":114},{"y":310,"time":35180,"x":114},{"y":307,"time":35243,"x":115},{"y":304,"time":35264,"x":116},{"y":303,"time":35305,"x":116},{"y":302,"time":35347,"x":116},{"y":300,"time":35367,"x":116},{"y":295,"time":35417,"x":117},{"y":293,"time":35455,"x":117},{"y":291,"time":35474,"x":118},{"y":287,"time":35514,"x":119},{"y":286,"time":35533,"x":119},{"y":286,"time":35572,"x":120},{"y":284,"time":35642,"x":120},{"y":282,"time":35663,"x":121},{"y":281,"time":35683,"x":122},{"y":280,"time":35704,"x":122},{"y":279,"time":35745,"x":122},{"y":277,"time":35767,"x":125},{"y":276,"time":35787,"x":126},{"y":275,"time":35807,"x":127},{"y":274,"time":35843,"x":128},{"y":273,"time":35882,"x":128},{"y":273,"time":35901,"x":129},{"y":272,"time":35920,"x":129},{"y":271,"time":35940,"x":131},{"y":267,"time":35960,"x":131},{"y":266,"time":35979,"x":133},{"y":265,"time":35998,"x":135},{"y":264,"time":36017,"x":135},{"y":264,"time":36044,"x":139},{"y":263,"time":36064,"x":139},{"y":262,"time":36084,"x":140},{"y":262,"time":36122,"x":141},{"y":260,"time":36143,"x":141},{"y":257,"time":36168,"x":145},{"y":257,"time":36231,"x":146},{"y":256,"time":36252,"x":147},{"y":256,"time":36273,"x":148},{"y":254,"time":36294,"x":148},{"y":253,"time":36335,"x":150},{"y":253,"time":36362,"x":151},{"y":252,"time":36382,"x":152},{"y":252,"time":36423,"x":154},{"y":251,"time":36444,"x":155},{"y":251,"time":36464,"x":156},{"y":251,"time":36485,"x":157},{"y":251,"time":36525,"x":158},{"y":251,"time":36567,"x":159},{"y":250,"time":36588,"x":160},{"y":250,"time":36608,"x":161},{"y":249,"time":36652,"x":163},{"y":249,"time":36672,"x":165},{"y":249,"time":36715,"x":167},{"y":249,"time":36759,"x":169},{"y":249,"time":36779,"x":170},{"y":248,"time":36799,"x":172},{"y":248,"time":36823,"x":174},{"y":246,"time":36844,"x":176},{"y":246,"time":36865,"x":177},{"y":246,"time":36885,"x":179},{"y":246,"time":36927,"x":180},{"y":246,"time":36948,"x":181},{"y":245,"time":36968,"x":183},{"y":244,"time":37009,"x":186},{"y":244,"time":37030,"x":187},{"y":244,"time":37051,"x":188},{"y":244,"time":37094,"x":190},{"y":244,"time":37136,"x":194},{"y":244,"time":37179,"x":197},{"y":244,"time":37201,"x":199},{"y":244,"time":37282,"x":200},{"y":243,"time":37304,"x":202},{"y":243,"time":37324,"x":204},{"y":243,"time":37345,"x":205},{"y":243,"time":37368,"x":206},{"y":243,"time":37407,"x":207},{"y":243,"time":37471,"x":208},{"y":243,"time":37534,"x":209},{"y":243,"time":37559,"x":210},{"y":243,"time":37598,"x":211},{"y":243,"time":37623,"x":212},{"y":243,"time":37683,"x":213},{"y":243,"time":37704,"x":214},{"y":243,"time":37746,"x":215},{"y":243,"time":37786,"x":216},{"y":243,"time":37806,"x":218},{"y":243,"time":37855,"x":219},{"y":243,"time":37916,"x":223},{"y":244,"time":37935,"x":225},{"y":244,"time":37960,"x":226},{"y":244,"time":37978,"x":229},{"y":244,"time":37996,"x":231},{"y":244,"time":38015,"x":237},{"y":244,"time":38033,"x":239},{"y":244,"time":38052,"x":241},{"y":244,"time":38070,"x":242},{"y":244,"time":38088,"x":243},{"y":244,"time":38107,"x":245},{"y":244,"time":38166,"x":246},{"y":244,"time":38185,"x":247},{"y":245,"time":38247,"x":249},{"y":245,"time":38288,"x":251},{"y":245,"time":38309,"x":254},{"y":245,"time":38331,"x":258},{"y":245,"time":38352,"x":261},{"y":245,"time":38412,"x":263},{"y":245,"time":38434,"x":264},{"y":246,"time":38455,"x":266},{"y":247,"time":38496,"x":266},{"y":247,"time":38517,"x":267},{"y":248,"time":38547,"x":267},{"y":248,"time":38587,"x":268},{"y":250,"time":38608,"x":268},{"y":250,"time":38650,"x":269},{"y":253,"time":38694,"x":270},{"y":254,"time":38714,"x":271},{"y":256,"time":38758,"x":272},{"y":258,"time":38778,"x":273},{"y":260,"time":38797,"x":274},{"y":261,"time":38870,"x":274},{"y":262,"time":38890,"x":275},{"y":263,"time":38929,"x":276},{"y":264,"time":38969,"x":276},{"y":264,"time":38990,"x":277},{"y":265,"time":39011,"x":277},{"y":265,"time":39052,"x":278},{"y":266,"time":39072,"x":278},{"y":269,"time":39095,"x":279},{"y":271,"time":39159,"x":280},{"y":275,"time":39179,"x":282},{"y":276,"time":39199,"x":282},{"y":278,"time":39223,"x":283},{"y":279,"time":39244,"x":283},{"y":282,"time":39285,"x":285},{"y":285,"time":39306,"x":285},{"y":287,"time":39326,"x":287},{"y":289,"time":39347,"x":287},{"y":291,"time":39368,"x":287},{"y":294,"time":39388,"x":288},{"y":296,"time":39451,"x":289},{"y":299,"time":39472,"x":290},{"y":301,"time":39494,"x":290},{"y":303,"time":39536,"x":290},{"y":304,"time":39560,"x":291},{"y":305,"time":39599,"x":291},{"y":306,"time":39643,"x":291},{"y":308,"time":39683,"x":291},{"y":311,"time":39724,"x":292},{"y":312,"time":39745,"x":292},{"y":314,"time":39766,"x":294},{"y":318,"time":39807,"x":295},{"y":320,"time":39850,"x":295},{"y":323,"time":39870,"x":295},{"y":326,"time":39894,"x":296},{"y":331,"time":39914,"x":297},{"y":334,"time":39954,"x":298},{"y":335,"time":39975,"x":299},{"y":338,"time":39996,"x":299},{"y":340,"time":40017,"x":300},{"y":345,"time":40057,"x":303},{"y":346,"time":40078,"x":303},{"y":346,"time":40103,"x":305},{"y":351,"time":40122,"x":307},{"y":352,"time":40141,"x":308},{"y":353,"time":40216,"x":312},{"y":354,"time":40236,"x":314},{"y":354,"time":40274,"x":315},{"y":354,"time":40294,"x":317},{"y":354,"time":40314,"x":319},{"y":354,"time":40334,"x":321},{"y":354,"time":40359,"x":326},{"y":354,"time":40378,"x":328},{"y":353,"time":40423,"x":330},{"y":353,"time":40443,"x":332},{"y":353,"time":40503,"x":334},{"y":353,"time":40523,"x":336},{"y":353,"time":40567,"x":337},{"y":352,"time":40587,"x":339},{"y":352,"time":40630,"x":341},{"y":352,"time":40695,"x":342},{"y":351,"time":40734,"x":343},{"y":351,"time":40779,"x":344},{"y":351,"time":40798,"x":345},{"y":351,"time":40823,"x":346},{"y":350,"time":40843,"x":347},{"y":350,"time":40903,"x":348},{"y":349,"time":40923,"x":348},{"y":349,"time":40952,"x":350},{"y":348,"time":40972,"x":351},{"y":347,"time":40991,"x":351},{"y":346,"time":41011,"x":352},{"y":346,"time":41071,"x":353},{"y":345,"time":41100,"x":355},{"y":343,"time":41141,"x":357},{"y":343,"time":41179,"x":358},{"y":342,"time":41222,"x":358},{"y":342,"time":41284,"x":359},{"y":340,"time":41388,"x":359},{"y":340,"time":41408,"x":360},{"y":339,"time":41452,"x":360},{"y":339,"time":41494,"x":361},{"y":338,"time":41514,"x":361},{"y":337,"time":41560,"x":362},{"y":335,"time":41580,"x":363},{"y":334,"time":41623,"x":364},{"y":333,"time":41644,"x":364},{"y":332,"time":41705,"x":364},{"y":329,"time":41726,"x":365},{"y":328,"time":41752,"x":366},{"y":327,"time":41771,"x":366},{"y":324,"time":41791,"x":366},{"y":323,"time":41812,"x":366},{"y":322,"time":41853,"x":366},{"y":320,"time":41895,"x":365},{"y":319,"time":41936,"x":365},{"y":317,"time":41960,"x":364},{"y":316,"time":41999,"x":363},{"y":315,"time":42043,"x":361},{"y":313,"time":42063,"x":361},{"y":313,"time":42083,"x":360},{"y":313,"time":42103,"x":359},{"y":312,"time":42124,"x":358},{"y":312,"time":42154,"x":353},{"y":312,"time":42174,"x":352},{"y":310,"time":42199,"x":347},{"y":310,"time":42238,"x":346},{"y":310,"time":42277,"x":343},{"y":310,"time":42318,"x":342},{"y":310,"time":42339,"x":340},{"y":310,"time":42376,"x":338},{"y":309,"time":42416,"x":337},{"y":309,"time":42436,"x":335},{"y":309,"time":42456,"x":334},{"y":309,"time":42476,"x":333},{"y":308,"time":42496,"x":331},{"y":307,"time":42515,"x":330},{"y":306,"time":42554,"x":327},{"y":306,"time":42573,"x":326},{"y":304,"time":42599,"x":323},{"y":300,"time":42620,"x":319},{"y":300,"time":42640,"x":318},{"y":298,"time":42663,"x":316},{"y":297,"time":42683,"x":315},{"y":297,"time":42721,"x":314},{"y":296,"time":42740,"x":313},{"y":292,"time":42761,"x":310},{"y":290,"time":42781,"x":309},{"y":290,"time":42802,"x":307},{"y":289,"time":42845,"x":307},{"y":289,"time":42871,"x":306},{"y":289,"time":43224,"x":307},{"y":290,"time":43264,"x":309},{"y":290,"time":43286,"x":310},{"y":291,"time":43307,"x":311},{"y":291,"time":43328,"x":312},{"y":291,"time":43399,"x":314},{"y":291,"time":43419,"x":316},{"y":291,"time":43464,"x":319},{"y":291,"time":43483,"x":320},{"y":291,"time":43504,"x":321},{"y":291,"time":43527,"x":322},{"y":291,"time":43547,"x":323},{"y":289,"time":43567,"x":325},{"y":289,"time":43591,"x":326},{"y":287,"time":43610,"x":328},{"y":287,"time":43630,"x":329},{"y":285,"time":43649,"x":331},{"y":285,"time":43671,"x":332},{"y":284,"time":43691,"x":333},{"y":282,"time":43711,"x":337},{"y":282,"time":43756,"x":340},{"y":281,"time":43776,"x":340},{"y":281,"time":43801,"x":341},{"y":281,"time":43822,"x":342},{"y":280,"time":43844,"x":344},{"y":280,"time":43865,"x":345},{"y":280,"time":43886,"x":347},{"y":279,"time":43906,"x":347},{"y":279,"time":43927,"x":348},{"y":279,"time":43968,"x":349},{"y":279,"time":44011,"x":352},{"y":279,"time":44031,"x":354},{"y":280,"time":44052,"x":354},{"y":280,"time":44073,"x":355},{"y":281,"time":44093,"x":358},{"y":281,"time":44113,"x":359},{"y":282,"time":44138,"x":359},{"y":282,"time":44158,"x":361},{"y":282,"time":44178,"x":362},{"y":284,"time":44201,"x":364},{"y":284,"time":44221,"x":365},{"y":288,"time":44242,"x":369},{"y":289,"time":44304,"x":369},{"y":291,"time":44348,"x":371},{"y":293,"time":44369,"x":372},{"y":294,"time":44410,"x":373},{"y":297,"time":44430,"x":374},{"y":298,"time":44490,"x":374},{"y":300,"time":44530,"x":375},{"y":301,"time":44557,"x":376},{"y":300,"time":44777,"x":376},{"y":291,"time":44796,"x":376},{"y":289,"time":44816,"x":376},{"y":288,"time":44837,"x":377},{"y":287,"time":44878,"x":377},{"y":285,"time":44903,"x":379},{"y":283,"time":44923,"x":379},{"y":282,"time":44944,"x":381},{"y":281,"time":44967,"x":382},{"y":281,"time":44987,"x":383},{"y":280,"time":45007,"x":384},{"y":280,"time":45031,"x":385},{"y":277,"time":45072,"x":390},{"y":275,"time":45116,"x":393},{"y":275,"time":45136,"x":394},{"y":275,"time":45180,"x":395},{"y":275,"time":45200,"x":396},{"y":275,"time":45223,"x":398},{"y":276,"time":45243,"x":400},{"y":276,"time":45262,"x":402},{"y":276,"time":45282,"x":403},{"y":277,"time":45304,"x":404},{"y":278,"time":45324,"x":405},{"y":280,"time":45368,"x":410},{"y":284,"time":45388,"x":412},{"y":286,"time":45409,"x":414},{"y":289,"time":45432,"x":419},{"y":290,"time":45473,"x":420},{"y":293,"time":45515,"x":426},{"y":293,"time":45536,"x":427},{"y":295,"time":45559,"x":435},{"y":296,"time":45579,"x":437},{"y":296,"time":45599,"x":440},{"y":297,"time":45644,"x":442},{"y":297,"time":45665,"x":443},{"y":297,"time":45686,"x":446},{"y":296,"time":45726,"x":449},{"y":296,"time":45936,"x":448},{"y":296,"time":45959,"x":447},{"y":298,"time":45979,"x":441},{"y":299,"time":45999,"x":440},{"y":300,"time":46062,"x":436},{"y":300,"time":46082,"x":435},{"y":301,"time":46104,"x":435},{"y":301,"time":46125,"x":433},{"y":302,"time":46146,"x":433},{"y":303,"time":46171,"x":431},{"y":304,"time":46209,"x":428},{"y":304,"time":46232,"x":427},{"y":305,"time":46295,"x":426},{"y":305,"time":46316,"x":424},{"y":306,"time":46365,"x":419},{"y":307,"time":46384,"x":417},{"y":308,"time":46423,"x":416},{"y":309,"time":46442,"x":415},{"y":309,"time":46462,"x":414},{"y":310,"time":46483,"x":414},{"y":312,"time":46504,"x":411},{"y":312,"time":46568,"x":409},{"y":313,"time":46587,"x":407},{"y":314,"time":46630,"x":406},{"y":314,"time":46652,"x":403},{"y":316,"time":46672,"x":401},{"y":316,"time":46695,"x":400},{"y":317,"time":46735,"x":398},{"y":318,"time":46779,"x":394},{"y":319,"time":46800,"x":394},{"y":319,"time":46822,"x":393},{"y":320,"time":46864,"x":393},{"y":321,"time":46884,"x":392},{"y":321,"time":46909,"x":391},{"y":322,"time":46929,"x":391},{"y":324,"time":46953,"x":390},{"y":325,"time":46978,"x":389},{"y":326,"time":47000,"x":389},{"y":327,"time":47101,"x":388},{"y":327,"time":47140,"x":387},{"y":328,"time":47159,"x":387},{"y":330,"time":47200,"x":383},{"y":331,"time":47224,"x":383},{"y":331,"time":47245,"x":382},{"y":334,"time":47273,"x":381},{"y":335,"time":47292,"x":381},{"y":337,"time":47313,"x":379},{"y":339,"time":47338,"x":377},{"y":341,"time":47358,"x":376},{"y":342,"time":47379,"x":375},{"y":345,"time":47401,"x":373},{"y":346,"time":47442,"x":373},{"y":346,"time":47484,"x":372},{"y":347,"time":47505,"x":372},{"y":349,"time":47528,"x":371},{"y":351,"time":47549,"x":370},{"y":353,"time":47569,"x":368},{"y":354,"time":47611,"x":368},{"y":355,"time":47631,"x":367},{"y":356,"time":47652,"x":366},{"y":358,"time":47673,"x":364},{"y":360,"time":47694,"x":364},{"y":362,"time":47714,"x":362},{"y":364,"time":47736,"x":361},{"y":364,"time":47756,"x":359},{"y":365,"time":47777,"x":359},{"y":366,"time":47800,"x":358},{"y":366,"time":47821,"x":354},{"y":367,"time":47842,"x":353},{"y":369,"time":47873,"x":352},{"y":370,"time":47895,"x":351},{"y":372,"time":47914,"x":348},{"y":373,"time":47934,"x":345},{"y":374,"time":47955,"x":344},{"y":374,"time":47974,"x":342},{"y":375,"time":47994,"x":340},{"y":378,"time":48054,"x":334},{"y":378,"time":48094,"x":333},{"y":379,"time":48154,"x":327},{"y":380,"time":48179,"x":325},{"y":381,"time":48218,"x":322},{"y":381,"time":48237,"x":320},{"y":382,"time":48257,"x":316},{"y":382,"time":48277,"x":314},{"y":383,"time":48319,"x":308},{"y":383,"time":48339,"x":306},{"y":383,"time":48369,"x":305},{"y":383,"time":48412,"x":304},{"y":383,"time":48431,"x":302},{"y":384,"time":48483,"x":299},{"y":384,"time":48505,"x":298},{"y":384,"time":48561,"x":295},{"y":384,"time":48579,"x":294},{"y":384,"time":48621,"x":291},{"y":384,"time":48665,"x":290},{"y":384,"time":48686,"x":288},{"y":384,"time":48706,"x":287},{"y":384,"time":48728,"x":284},{"y":384,"time":48767,"x":281},{"y":384,"time":48793,"x":277},{"y":384,"time":48814,"x":270},{"y":384,"time":48855,"x":267},{"y":384,"time":48884,"x":263},{"y":385,"time":48905,"x":257},{"y":385,"time":48925,"x":256},{"y":385,"time":48982,"x":255},{"y":385,"time":49001,"x":253},{"y":386,"time":49020,"x":248},{"y":386,"time":49040,"x":245},{"y":386,"time":49082,"x":242},{"y":386,"time":49099,"x":241},{"y":386,"time":49116,"x":239},{"y":386,"time":49135,"x":237},{"y":386,"time":49161,"x":235},{"y":386,"time":49182,"x":232},{"y":386,"time":49200,"x":231},{"y":386,"time":49225,"x":226},{"y":386,"time":49243,"x":224},{"y":386,"time":49282,"x":218},{"y":386,"time":49304,"x":217},{"y":386,"time":49324,"x":216},{"y":386,"time":49344,"x":214},{"y":386,"time":49384,"x":210},{"y":386,"time":49404,"x":202},{"y":386,"time":49423,"x":198},{"y":386,"time":49444,"x":192},{"y":386,"time":49482,"x":190},{"y":386,"time":49500,"x":187},{"y":386,"time":49519,"x":183},{"y":386,"time":49538,"x":178},{"y":386,"time":49559,"x":177},{"y":386,"time":49578,"x":173},{"y":386,"time":49597,"x":171},{"y":386,"time":49616,"x":165},{"y":386,"time":49636,"x":164},{"y":386,"time":49655,"x":161},{"y":386,"time":49683,"x":160},{"y":386,"time":49723,"x":156},{"y":386,"time":49741,"x":154},{"y":386,"time":49760,"x":151},{"y":386,"time":49779,"x":148},{"y":386,"time":49800,"x":147},{"y":385,"time":49821,"x":143},{"y":385,"time":49852,"x":142},{"y":385,"time":49875,"x":141},{"y":384,"time":49896,"x":140},{"y":384,"time":49917,"x":138},{"y":383,"time":49938,"x":137},{"y":383,"time":49960,"x":136},{"y":382,"time":50001,"x":135},{"y":382,"time":50044,"x":134},{"y":381,"time":50107,"x":133},{"y":381,"time":50168,"x":132},{"y":380,"time":50188,"x":132},{"y":380,"time":50207,"x":131},{"y":379,"time":50250,"x":130},{"y":378,"time":50314,"x":128},{"y":378,"time":50354,"x":127},{"y":376,"time":50374,"x":127},{"y":374,"time":50413,"x":125},{"y":374,"time":50433,"x":124},{"y":373,"time":50454,"x":124},{"y":373,"time":50480,"x":123},{"y":370,"time":50522,"x":123},{"y":368,"time":50542,"x":119},{"y":366,"time":50607,"x":118},{"y":364,"time":50652,"x":117},{"y":362,"time":50672,"x":116},{"y":361,"time":50695,"x":116},{"y":360,"time":50715,"x":115},{"y":357,"time":50735,"x":114},{"y":352,"time":50761,"x":112},{"y":351,"time":50824,"x":112},{"y":349,"time":50844,"x":111},{"y":348,"time":50863,"x":111},{"y":346,"time":50903,"x":110},{"y":344,"time":50923,"x":110},{"y":343,"time":50944,"x":110},{"y":340,"time":51007,"x":110},{"y":338,"time":51033,"x":110},{"y":336,"time":51087,"x":110},{"y":334,"time":51128,"x":110},{"y":333,"time":51147,"x":110},{"y":332,"time":51165,"x":110},{"y":330,"time":51202,"x":110},{"y":327,"time":51242,"x":110},{"y":325,"time":51278,"x":110},{"y":324,"time":51336,"x":110},{"y":323,"time":51372,"x":110},{"y":322,"time":51419,"x":110},{"y":321,"time":51457,"x":110}],"id":0},{"col":16763904,"time":52573,"fx":118,"fy":360,"type":"draw","childlist":[{"y":360,"time":52753,"x":119},{"y":360,"time":52793,"x":122},{"y":360,"time":52812,"x":123},{"y":361,"time":52872,"x":125},{"y":361,"time":52891,"x":126},{"y":361,"time":52910,"x":127},{"y":361,"time":52929,"x":128},{"y":361,"time":52950,"x":132},{"y":361,"time":52987,"x":133},{"y":361,"time":53010,"x":134},{"y":361,"time":53033,"x":135},{"y":361,"time":53073,"x":136},{"y":361,"time":53097,"x":137},{"y":361,"time":53121,"x":139},{"y":361,"time":53161,"x":141},{"y":361,"time":53181,"x":144},{"y":361,"time":53224,"x":146},{"y":361,"time":53243,"x":149},{"y":360,"time":53283,"x":151},{"y":360,"time":53305,"x":152},{"y":360,"time":53324,"x":154},{"y":360,"time":53344,"x":156},{"y":359,"time":53368,"x":160},{"y":359,"time":53388,"x":161},{"y":358,"time":53413,"x":169},{"y":358,"time":53434,"x":171},{"y":358,"time":53454,"x":175},{"y":358,"time":53497,"x":181},{"y":358,"time":53565,"x":182},{"y":358,"time":53626,"x":183},{"y":357,"time":53646,"x":183},{"y":356,"time":53712,"x":187},{"y":356,"time":53735,"x":188},{"y":356,"time":53775,"x":189},{"y":355,"time":53865,"x":190},{"y":355,"time":53905,"x":191},{"y":354,"time":53930,"x":192},{"y":354,"time":53950,"x":193},{"y":353,"time":54033,"x":194},{"y":352,"time":54095,"x":194},{"y":351,"time":54264,"x":194}],"id":0},{"col":16763904,"time":55285,"fx":159,"fy":315,"type":"draw","childlist":[{"y":316,"time":55312,"x":159},{"y":317,"time":55337,"x":159},{"y":318,"time":55358,"x":159},{"y":319,"time":55419,"x":159},{"y":322,"time":55440,"x":160},{"y":327,"time":55465,"x":161},{"y":328,"time":55485,"x":162},{"y":330,"time":55528,"x":162},{"y":334,"time":55548,"x":163},{"y":335,"time":55568,"x":164},{"y":336,"time":55611,"x":165},{"y":337,"time":55632,"x":165},{"y":338,"time":55652,"x":165},{"y":339,"time":55736,"x":167},{"y":339,"time":55801,"x":168},{"y":339,"time":55841,"x":169},{"y":339,"time":55865,"x":170},{"y":339,"time":55927,"x":171},{"y":339,"time":55979,"x":172},{"y":339,"time":55999,"x":173},{"y":338,"time":56044,"x":173},{"y":338,"time":56064,"x":174},{"y":337,"time":56105,"x":174},{"y":337,"time":56124,"x":175},{"y":336,"time":56168,"x":175},{"y":335,"time":56188,"x":175},{"y":334,"time":56251,"x":175},{"y":333,"time":56296,"x":175},{"y":332,"time":56363,"x":175},{"y":330,"time":56383,"x":176},{"y":329,"time":56403,"x":176},{"y":327,"time":56449,"x":177},{"y":326,"time":56476,"x":177},{"y":325,"time":56536,"x":177},{"y":323,"time":56574,"x":177},{"y":321,"time":56602,"x":177},{"y":319,"time":56683,"x":177},{"y":318,"time":56704,"x":177},{"y":317,"time":56748,"x":177},{"y":316,"time":56768,"x":177},{"y":313,"time":56792,"x":177},{"y":312,"time":56812,"x":177},{"y":311,"time":56832,"x":177}],"id":0},{"col":16763904,"time":58653,"fx":206,"fy":124,"type":"draw","childlist":[{"y":125,"time":58728,"x":206},{"y":126,"time":58748,"x":206},{"y":131,"time":58792,"x":205},{"y":135,"time":58831,"x":204},{"y":138,"time":58852,"x":204},{"y":147,"time":58890,"x":203},{"y":152,"time":58909,"x":203},{"y":153,"time":58928,"x":202},{"y":157,"time":58948,"x":202},{"y":164,"time":58968,"x":201},{"y":172,"time":58987,"x":200},{"y":176,"time":59014,"x":200},{"y":181,"time":59034,"x":200},{"y":187,"time":59054,"x":199},{"y":191,"time":59096,"x":199},{"y":196,"time":59137,"x":199},{"y":199,"time":59160,"x":199},{"y":202,"time":59180,"x":199},{"y":203,"time":59200,"x":199},{"y":206,"time":59227,"x":199},{"y":207,"time":59247,"x":199},{"y":210,"time":59273,"x":199},{"y":214,"time":59313,"x":199},{"y":216,"time":59336,"x":199},{"y":220,"time":59356,"x":199},{"y":221,"time":59376,"x":199},{"y":222,"time":59420,"x":199},{"y":226,"time":59470,"x":199},{"y":227,"time":59496,"x":200},{"y":229,"time":59516,"x":200},{"y":230,"time":59560,"x":200},{"y":231,"time":59579,"x":200},{"y":232,"time":59662,"x":200},{"y":233,"time":59681,"x":200},{"y":236,"time":59705,"x":201}],"id":0},{"col":16763904,"time":60636,"fx":323,"fy":124,"type":"draw","childlist":[{"y":125,"time":60761,"x":323},{"y":128,"time":60781,"x":323},{"y":132,"time":60802,"x":323},{"y":138,"time":60834,"x":323},{"y":140,"time":60854,"x":323},{"y":147,"time":60878,"x":322},{"y":154,"time":60916,"x":321},{"y":154,"time":60936,"x":319},{"y":158,"time":60956,"x":319},{"y":162,"time":60976,"x":318},{"y":164,"time":60999,"x":318},{"y":172,"time":61021,"x":316},{"y":184,"time":61042,"x":312},{"y":186,"time":61064,"x":312},{"y":190,"time":61084,"x":310},{"y":195,"time":61103,"x":308},{"y":202,"time":61128,"x":305},{"y":204,"time":61147,"x":305},{"y":206,"time":61167,"x":303},{"y":216,"time":61193,"x":299},{"y":224,"time":61212,"x":297},{"y":225,"time":61232,"x":296},{"y":229,"time":61253,"x":294},{"y":236,"time":61273,"x":291},{"y":240,"time":61294,"x":290},{"y":240,"time":61315,"x":289},{"y":243,"time":61336,"x":289},{"y":246,"time":61356,"x":288},{"y":247,"time":61400,"x":287},{"y":248,"time":61420,"x":287},{"y":248,"time":61440,"x":286},{"y":252,"time":61484,"x":285},{"y":252,"time":61504,"x":284},{"y":253,"time":61528,"x":284},{"y":254,"time":61547,"x":284},{"y":256,"time":61567,"x":284},{"y":257,"time":61594,"x":283},{"y":258,"time":61633,"x":283},{"y":260,"time":61673,"x":282},{"y":261,"time":61693,"x":282},{"y":262,"time":61767,"x":282}],"id":0},{"col":16763904,"time":62509,"fx":368,"fy":202,"type":"draw","childlist":[{"y":205,"time":62587,"x":368},{"y":214,"time":62607,"x":366},{"y":221,"time":62640,"x":363},{"y":232,"time":62666,"x":358},{"y":240,"time":62685,"x":354},{"y":242,"time":62705,"x":352},{"y":252,"time":62729,"x":346},{"y":256,"time":62748,"x":344},{"y":259,"time":62768,"x":342},{"y":262,"time":62794,"x":341},{"y":264,"time":62814,"x":340},{"y":265,"time":62834,"x":339},{"y":268,"time":62853,"x":337},{"y":272,"time":62872,"x":335},{"y":277,"time":62892,"x":330},{"y":279,"time":62912,"x":329},{"y":280,"time":62953,"x":327},{"y":284,"time":62970,"x":325},{"y":286,"time":63006,"x":324},{"y":286,"time":63024,"x":323},{"y":294,"time":63043,"x":320},{"y":300,"time":63084,"x":317},{"y":305,"time":63129,"x":316},{"y":306,"time":63193,"x":314},{"y":309,"time":63212,"x":312},{"y":311,"time":63237,"x":311},{"y":312,"time":63275,"x":311},{"y":313,"time":63294,"x":310},{"y":317,"time":63314,"x":307},{"y":318,"time":63355,"x":305},{"y":320,"time":63438,"x":305}],"id":0},{"col":16763904,"time":64476,"fx":157,"fy":83,"type":"draw","childlist":[{"y":83,"time":64589,"x":156},{"y":85,"time":64609,"x":156},{"y":95,"time":64634,"x":154},{"y":101,"time":64655,"x":154},{"y":110,"time":64675,"x":154},{"y":122,"time":64702,"x":154},{"y":128,"time":64731,"x":154},{"y":133,"time":64750,"x":154},{"y":136,"time":64769,"x":154},{"y":139,"time":64792,"x":154},{"y":141,"time":64810,"x":154},{"y":144,"time":64828,"x":154},{"y":146,"time":64846,"x":154},{"y":148,"time":64865,"x":154},{"y":149,"time":64884,"x":154},{"y":151,"time":64904,"x":154},{"y":153,"time":64922,"x":154},{"y":158,"time":64957,"x":156},{"y":162,"time":64977,"x":156},{"y":166,"time":65000,"x":156},{"y":170,"time":65020,"x":156},{"y":178,"time":65065,"x":156},{"y":179,"time":65084,"x":156},{"y":185,"time":65103,"x":156},{"y":189,"time":65129,"x":157},{"y":196,"time":65150,"x":157},{"y":197,"time":65192,"x":157},{"y":201,"time":65212,"x":157},{"y":204,"time":65231,"x":157},{"y":206,"time":65252,"x":157},{"y":207,"time":65273,"x":157},{"y":211,"time":65293,"x":157},{"y":214,"time":65313,"x":157},{"y":215,"time":65337,"x":157},{"y":216,"time":65358,"x":157},{"y":220,"time":65379,"x":157},{"y":222,"time":65420,"x":157},{"y":223,"time":65464,"x":157},{"y":225,"time":65506,"x":157},{"y":226,"time":65548,"x":158},{"y":227,"time":65568,"x":158},{"y":228,"time":65613,"x":158},{"y":233,"time":65633,"x":159},{"y":235,"time":65653,"x":159},{"y":236,"time":65693,"x":160},{"y":237,"time":65755,"x":160}],"id":0},{"col":16763904,"time":66569,"fx":98,"fy":183,"type":"draw","childlist":[{"y":184,"time":66601,"x":98},{"y":186,"time":66620,"x":98},{"y":193,"time":66666,"x":99},{"y":195,"time":66705,"x":99},{"y":202,"time":66729,"x":100},{"y":206,"time":66748,"x":101},{"y":212,"time":66767,"x":103},{"y":215,"time":66793,"x":104},{"y":221,"time":66813,"x":105},{"y":225,"time":66832,"x":107},{"y":228,"time":66852,"x":108},{"y":232,"time":66873,"x":108},{"y":236,"time":66892,"x":109},{"y":240,"time":66912,"x":111},{"y":246,"time":66937,"x":113},{"y":249,"time":66958,"x":114},{"y":253,"time":66978,"x":115},{"y":258,"time":67002,"x":117},{"y":260,"time":67043,"x":117},{"y":264,"time":67084,"x":121},{"y":266,"time":67102,"x":121},{"y":268,"time":67129,"x":122},{"y":272,"time":67149,"x":124},{"y":275,"time":67169,"x":126},{"y":277,"time":67192,"x":126},{"y":278,"time":67231,"x":127},{"y":281,"time":67250,"x":128},{"y":281,"time":67292,"x":129},{"y":283,"time":67312,"x":129},{"y":286,"time":67337,"x":130}],"id":0},{"type":"clear","time":75237}]';

			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			//			sound = new Sound(new URLRequest("http://level0.kayac.com/images/murai/DJ%20Dolores%20-%20Oslodum%202004.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("data/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("data/stars_long.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}