/**
 * Copyright zob ( http://wonderfl.net/user/zob )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r9Xi
 */

package  {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.utils.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import net.hires.debug.Stats;
    import frocessing.color.ColorHSV;
    
    public class tunnel extends Sprite
    {
        private var bmpd      :BitmapData     = new BitmapData(200, 200, true, 0x0);
        private var sketch    :BitmapData     = new BitmapData(200, 200, true, 0x0);
        private var tbmpd     :BitmapData     = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
        private var bmp       :Bitmap         = new Bitmap(tbmpd);
        private var D2R       :Number         = Math.PI/180;
        private var vcolor    :ColorHSV       = new ColorHSV(0,0.5,0.9,0.7);
        private var bmRect    :Rectangle      = new Rectangle();
        private var ct        :ColorTransform = new ColorTransform(1,1,1,0.999);
        private var worms     :int            = 5;
        private var beats     :int            = 10;
        private var gets      :Vector.<int>   = new Vector.<int>(50, true);
        
        private var x1        :Number         = .05;
        private var y1        :Number         = .06;
        private var x2        :Number         = 2.25;
        private var y2        :Number         = 2.24;
        private var x3        :Number         = 1.6;
        private var y3        :Number         = .24;
        private var x4        :Number         = 30;
        private var y4        :Number         = 30;
        private var x5        :Number         = 30;
        private var y5        :Number         = 30;
        
        private var sound     :Sound          = new Sound();
        private var byteArray :ByteArray      = new ByteArray();
        private var black     :Boolean        = true;
        private var white     :Boolean        = true;
        private var btxt      :TextField      = new TextField();
        private var wtxt      :TextField      = new TextField();
        
        public function tunnel()
        {
            sound.load(new URLRequest("http://level0.kayac.com/images/murai/Digi_GAlessio_-_06_-_darix_togni.mp3"), new SoundLoaderContext(10, true)); sound.play(0, 99);
            addChild(bmp); bmp.x = (stage.stageWidth - bmp.width)/2; bmp.y = (stage.stageHeight - bmp.height)/2;
            addChild(new Stats());
            addChild(btxt); addChild(wtxt);
            //btxt.visible = wtxt.visible = false;
            btxt.text = "black"; wtxt.text = "white";
            btxt.autoSize = wtxt.autoSize = "left";
            btxt.textColor = 0xFFFFFF; wtxt.textColor = 0x0;
            btxt.scaleX = btxt.scaleY = wtxt.scaleX = wtxt.scaleY = 2;
            btxt.x = 5; wtxt.x = stage.stageWidth - wtxt.width -5;
            btxt.y = wtxt.y = stage.stageHeight - btxt.height -5;
            stage.addEventListener(Event.ENTER_FRAME, processing);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onkeyDown);
        }
        private function processing(e:Event):void
        {
            SoundMixer.computeSpectrum(byteArray, false, 512);
            gets[gets.length-1] = (byteArray.readFloat()>0.4)?1:0;
            var deg:Number = (getTimer()/30);
            var i:int = 0;
            var j:int = 0;
            var px:Number = 0;
            var py:Number = 0;
            var gtx:Number = 0;
            var gty:Number = 0;
            for(i = 0; i < 50; i++)
            {
                if(i<50-1) gets[i] = gets[i+1];
                vcolor.h = getTimer()/10+(i*4);
                vcolor.s = (white)?Math.abs(Math.cos(((getTimer()/100+i)%360)*D2R))*0.7:0.5;//(i/50)*(0.5);
                vcolor.v = (black)?Math.abs(Math.sin(((getTimer()/100+i)%360)*D2R))*0.7:0.9;//(1-(i/50))*(0.5);
                px = -x5+(Math.sin((deg+i)*x1+x2+x3)*x4+x5);
                py = -y5+(Math.cos((deg+i)*y1+y2+y3)*y4+y5);
                gtx = px;
                gty = py;
                
                sketch.fillRect(sketch.rect, vcolor.value32);
                drawBitmapCircle(sketch, bmpd.width/2 + int(gtx), bmpd.height/2 + int(gty), i + 18, 0x0);
                for(j = 0; j < worms; j++)
                {
                    gtx = px + Math.cos((deg+i*6+j*360/worms)*D2R) * 15;
                    gty = py + Math.sin((deg+i*6+j*360/worms)*D2R) * 15;
                    sketch.fillRect(new Rectangle(bmpd.width/2 + int(gtx) - 5, bmpd.height/2 + int(gty) -5, 10, 10), vcolor.value32);
                }
                if(gets[i])
                {
                    for(j = 0; j < beats; j++)
                    {
                        gtx = px + Math.cos((-deg+i*3+j*360/beats)*D2R) * 35;
                        gty = py + Math.sin((-deg+i*3+j*360/beats)*D2R) * 35;
                        sketch.fillRect(new Rectangle(bmpd.width/2 + int(gtx) - 5, bmpd.height/2 + int(gty) -5, 10, 10), vcolor.value32);
                    }
                }
                bmpd.copyPixels(sketch, sketch.rect, new Point(), null, null, true);
            }

            tbmpd.fillRect(tbmpd.rect, bmpd.getPixel32(0,0));
            tbmpd.copyPixels(bmpd, bmpd.rect, new Point(tbmpd.width/4-px, tbmpd.height/4-py));
        }
        public function drawBitmapCircle(target:BitmapData, cX:Number, cY:Number, r:Number, color:Number):void {
            var x:Number = 0;
            var y:Number = 0;
            var r2:Number = r*r;
            for (x=1; x<r; x++) {
                y = Math.ceil(Math.sqrt(r2 - x*x));
                bmRect.topLeft = new Point(cX-x, cY-y);
                bmRect.size = new Point(2*x, 2*y);
                target.fillRect(bmRect, color);
            }
        }
        public function onkeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.UP  : black = !black; break;
                case Keyboard.DOWN: white = !white; break;
            }
            btxt.visible = black; wtxt.visible = white; 
        }
    }
}