/**
 * Copyright bcosizm ( http://wonderfl.net/user/bcosizm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r9H7
 */

package {
	import flash.events.*;
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.objects.primitives.*;
	
	import flash.display.Loader;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    //import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    
    
    public class SilentBill extends BasicView {
    		private var obj_player:Sphere;//球形インスタンス
    		private var obj_ground:Plane;//地面インスタンス
    		private var obj_cube:Cube;//直方体インスタンス
    		
    		private var rotx:Number = 0;
    		private var roty:Number = 0; 
    		
        public function SilentBill() {
            // write as3 code here..
            //マテリアル作成
            var material_w_green:WireframeMaterial = new WireframeMaterial(0x00FF00);
            var material_w_white:WireframeMaterial = new WireframeMaterial(0xFFFFFF);
            var material_c_gray:ColorMaterial = new ColorMaterial(0x666666);
            var material_ground:CompositeMaterial = new CompositeMaterial();
            material_ground.addMaterial(material_c_gray);
            material_ground.addMaterial(material_w_white);
            material_ground.doubleSided= true;
            //直方体
            //マテリアルズリスト
            var materials:MaterialsList = new MaterialsList({all:material_w_white});
            obj_cube = new Cube(materials,700,700,700,10,10,10);
            //球形作成
            obj_player = new Sphere(material_w_green,400,15,15);
            //地面作成
            obj_ground = new Plane(material_ground,10000,10000,10,10);
            
            //3D空間に球体を追加
            obj_ground.pitch(90);
            scene.addChild(obj_ground);
			obj_player.y = 1000;
            scene.addChild(obj_player);
            obj_cube.x = 1000;
            obj_cube.z = 1000;
            obj_cube.y = 700;
            scene.addChild(obj_cube);
            
            //レンダリング開始
            startRendering();
            
            //エンターフレームのイベントを登録
            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        
        //アニメーション
        private function loop(e:Event):void
        {
        		//球体を回転させる
        		obj_player.rotationY +=4;
        		
        		//マウスのX座標がステージの幅の何%の位置にあるか調べてそれを360度で乗算する。
        		var targetRotX:Number = (mouseX/stage.stageWidth)*360;
        		var targetRotY:Number = (mouseY/stage.stageHeight)*360;
        		//イージングの公式を用いて滑らかにする。
        		//値 +=（目標値-現在値）*減速値
        		rotx += (targetRotX-rotx)*0.02;
        		roty += (targetRotY-roty)*0.02;
        		//角度に応じてカメラの位置を設定
        		//横方向
        		camera.x = 2000*Math.sin(rotx*Math.PI/180);
        		camera.z = 2000*Math.cos(rotx*Math.PI/180);
        		//縦方向
        		camera.y = 2000*Math.sin(roty*Math.PI/180);
        		//camera.x= 1000*Math.cos(roty*Math.PI/180);
        }
    }
}