/**
 * Copyright yasyasyas ( http://wonderfl.net/user/yasyasyas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r91v
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Point;
	import flash.utils.Timer;
	
	public class DrawingFlowersRotation_Timer extends Sprite {
		
		var num:int = 12;
		var deg:Number = 360 / num;
		var len:int = 20;
		var petalWidth:int = 60;
		var petalHeight:int = 16;
		var fnum:int = 20;
		var speed:Number;
		var speedList:Array;
		var flowerList:Array;
		
		public function DrawingFlowersRotation_Timer() {
			
			speedList = new Array();
			flowerList = new Array();
			
			for (var k:int = 0; k < fnum; k++) {
			speed = 5 + Math.random() * 5;
			speedList.push(speed);
			}
			
			for (var i:int = 0; i < fnum; i++) {
				var flower:Sprite = new Sprite();
				addChild(flower);
				
				flower.graphics.lineStyle(5,0xFF9900);
				flower.graphics.beginFill(0xFFFF00);
				flower.graphics.drawCircle(0, 0, len);
				flower.graphics.endFill();
				var fx:Number = Math.random() * stage.stageWidth;
				var fy:Number = Math.random() * stage.stageHeight;
				flower.x = fx;
				flower.y = fy;
				
				flowerList.push(flower);
				
				var color:Number = Math.random() * 0xFFFFFF;
				
				for (var j:int = 0; j < num; j++) {
					
					var petal:Shape = new Shape();
					flower.addChild(petal);
					petal.graphics.lineStyle(1);
					petal.graphics.beginFill(color);
					petal.graphics.drawEllipse(0, -petalHeight/2, petalWidth, petalHeight);
					petal.graphics.endFill();
					
					var rad:Number = 2 * Math.PI / num;
					var pt:Point = Point.polar(len, rad * j);
					petal.x = pt.x;
					petal.y = pt.y;
					petal.rotation = deg * j;
				}

			}
			
			var timer:Timer = new Timer(83);
			timer.addEventListener(TimerEvent.TIMER, timerListener);
			timer.start();
			
		}
		
		private function timerListener(e:TimerEvent):void {
			for (var m:int = 0; m < fnum; m++) {
				flowerList[m].rotation += speedList[m];
			}
		}
		

		
	}
}