/**
 * Copyright talte ( http://wonderfl.net/user/talte )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r763
 */

package {
  import flash.display.Sprite
  import flash.events.Event
  import flash.events.MouseEvent
  import flash.text.TextField
  import flash.text.TextFieldAutoSize
  
  public class Field extends Sprite
  {
    private var slider_acc:Slider
    private var slider_decay:Slider
    private var slider_vel0:Slider
    
    private var text_acc:TextField
    private var text_decay:TextField
    private var text_vel0:TextField
    
    public function Field()
    {
      stage.showDefaultContextMenu = false
      stage.focus = this
      this.addEventListener(Event.ADDED_TO_STAGE, onInit)
    }
    public function onInit(event:Event):void 
    {
      this.graphics.lineStyle(1, 0x000000)
      this.graphics.beginFill(0xff7777)
      this.graphics.drawCircle(stage.stageWidth / 2, stage.stageHeight * 2 / 3, 10)
      this.graphics.endFill()
      
      this.slider_vel0 = new Slider
      this.slider_vel0.x = 10
      this.slider_vel0.y = 30
      this.slider_vel0.value = 0.2
      this.slider_vel0.addEventListener(Event.CHANGE, this.onChange)
      this.addChild(this.slider_vel0)
      Bullet.vel0 = Math.pow(slider_vel0.value * 5, 2)
      this.text_vel0 = new TextField
      this.text_vel0.x = 10
      this.text_vel0.y = 10
      this.text_vel0.autoSize = TextFieldAutoSize.LEFT
      this.text_vel0.text = "初速：" + Bullet.vel0
      this.addChild(this.text_vel0)
      
      this.slider_acc = new Slider
      this.slider_acc.x = 10
      this.slider_acc.y = 70
      this.slider_acc.value = 0.5
      this.slider_acc.addEventListener(Event.CHANGE, this.onChange)
      this.addChild(this.slider_acc)
      Bullet.acc = slider_acc.value
      this.text_acc = new TextField
      this.text_acc.x = 10
      this.text_acc.y = 50
      this.text_acc.autoSize = TextFieldAutoSize.LEFT
      this.text_acc.text = "加速：" + Bullet.acc
      this.addChild(this.text_acc)
      
      this.slider_decay = new Slider
      this.slider_decay.x = 10
      this.slider_decay.y = 110
      this.slider_decay.value = 0.9
      this.slider_decay.addEventListener(Event.CHANGE, this.onChange)
      this.addChild(this.slider_decay)
      Bullet.decay = 1 - Math.pow(1 - slider_decay.value, 2)
      this.text_decay = new TextField
      this.text_decay.x = 10
      this.text_decay.y = 90
      this.text_decay.autoSize = TextFieldAutoSize.LEFT
      this.text_decay.text = "減衰：" + Bullet.decay
      this.addChild(this.text_decay)
      
      stage.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown)
    }
    private function onMouseDown(event:MouseEvent):void 
    {
      var bullet:Bullet = new Bullet(stage.stageWidth / 2, stage.stageHeight * 2 / 3, Math.atan2(event.stageY - stage.stageHeight * 2 / 3, event.stageX - stage.stageWidth / 2) * 180 / Math.PI)
      this.addChild(bullet)

    }
    private function onChange(event:Event):void 
    {
      var slider:Slider = Slider(event.target)
      if (slider == slider_vel0)
      {
        Bullet.vel0 = Math.pow(slider_vel0.value * 5, 2)
        this.text_vel0.text = "初速：" + Bullet.vel0
      }
      else if (slider == slider_acc)
      {
        Bullet.acc = slider_acc.value
        this.text_acc.text = "加速：" + Bullet.acc
      }
      else if (slider == slider_decay)
      {
        Bullet.decay = 1 - Math.pow(1 - slider_decay.value, 2)
        this.text_decay.text = "減衰：" + Bullet.decay
      }
    }
  }
}
  import flash.display.Sprite
  import flash.events.Event
  import flash.events.MouseEvent
  import flash.geom.Rectangle
  
  class Bullet extends Sprite
  {
    public static var vel0:Number = 0
    public static var acc:Number = 0
    public static var decay:Number = 0
    
    private var pos_x:Number
    private var pos_y:Number
    private var vel_x:Number = 0
    private var vel_y:Number = 0
    private var dir:Number
    
    public function Bullet(x:Number, y:Number, dir:Number)
    {
      this.pos_x = x
      this.pos_y = y
      this.dir = dir
      
      this.vel_x = vel0 * Math.cos(dir * Math.PI / 180)
      this.vel_y = vel0 * Math.sin(dir * Math.PI / 180)
      
      this.graphics.lineStyle(1, 0x000000)
      this.graphics.beginFill(0xff7777)
      this.graphics.moveTo(5, 0)
      this.graphics.lineTo(-5, -4)
      this.graphics.lineTo(-5, 4)
      this.graphics.lineTo(5, 0)
      this.graphics.endFill()
      
      this.rotation = dir
      
      this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame)
    }
    private function onEnterFrame(event:Event):void 
    {
      this.pos_x += this.vel_x
      this.pos_y += this.vel_y
      this.vel_x *= decay
      this.vel_y *= decay
      this.vel_x += acc * Math.cos(this.dir * Math.PI / 180)
      this.vel_y += acc * Math.sin(this.dir * Math.PI / 180)
      
      this.x = this.pos_x
      this.y = this.pos_y
    }
  }
  class Slider extends Sprite
  {
    private var cursor:Sprite
    private var drag:Boolean = false
    
    public function Slider()
    {
      var child:Sprite = new Sprite
      child.graphics.beginFill(0xdddddd)
      child.graphics.drawRect(0, 0, 108, 9)
      child.graphics.endFill()
      child.graphics.beginFill(0x000000)
      child.graphics.drawRect(4, 4, 100, 1)
      child.graphics.endFill()
      child.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown)
      this.addChild(child)
      
      this.cursor = new Sprite()
      this.cursor.x = 4
      this.cursor.y = 5
      this.cursor.graphics.beginFill(0x000000)
      this.cursor.graphics.moveTo(0, 0)
      this.cursor.graphics.lineTo(-2, 4)
      this.cursor.graphics.lineTo(2, 4)
      this.cursor.graphics.lineTo(0, 0)
      this.cursor.graphics.endFill()
      this.cursor.addEventListener(MouseEvent.MOUSE_DOWN, this.cursor_onMouseDown)
      this.addChild(this.cursor)
      
      this.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove)
    }
    
    public function get value():Number
    {
      return (this.cursor.x - 4) / 100.0
    }
    public function set value(val:Number):void
    {
      if (val < 0)
      {
        val = 0
      }
      else if (val > 1)
      {
        val = 1
      }
      this.cursor.x = val * 100 + 4
    }
    
    private function onMouseDown(event:MouseEvent):void
    {
      this.cursor.x = this.mouseX
      this.cursor.startDrag(false, new Rectangle(4, 5, 100, 0))
      stage.addEventListener(MouseEvent.MOUSE_UP, this.cursor_onMouseUp)
      this.drag = true
      this.dispatchEvent(new Event(Event.CHANGE))
    }
    private function cursor_onMouseDown(event:MouseEvent):void
    {
      this.cursor.startDrag(false, new Rectangle(4, 5, 100, 0))
      this.drag = true
      stage.addEventListener(MouseEvent.MOUSE_UP, this.cursor_onMouseUp)
    }
    private function cursor_onMouseUp(event:MouseEvent):void
    {
      if (this.drag)
      {
        this.cursor.stopDrag()
        stage.removeEventListener(MouseEvent.MOUSE_UP, this.cursor_onMouseUp)
        this.drag = false
      }
    }
    private function onMouseMove(event:MouseEvent):void
    {
      if (this.drag)
      {
        this.dispatchEvent(new Event(Event.CHANGE))
      }
    }
  }
