/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r6s6
 */

package {
    import org.papervision3d.view.BasicView;
    import flash.text.TextField;
    import flash.events.Event;
    import net.hires.debug.Stats;
    import org.papervision3d.core.math.*;
    
    [SWF(backgroundColor="0x000000", frameRate="60")]
    public class PV3D extends BasicView {
        private var _tf : TextField;
        
        public function PV3D() {
            super(0, 0, true, false);
            
            _tf = new TextField();
            addChild(_tf);
            _tf.textColor = 0xffffff;
            _tf.width = 100;
            _tf.height = 465;
             
             var x : Number3D = new Number3D(0.3, 0.5, 1);
             var axis : Number3D = new Number3D(0.6, 0.8, 0);
             var deg : Number = -5.5;
             
             tr(rotate(x, axis, -deg));
             tr(applyQuaternion([x], axis, deg)[0]);
//            addChild(new Stats());

            startRendering();
        }
        
    public static function rotate(x : Number3D, axis : Number3D, angle : Number) : Number3D
    {
        var nCos:Number	= Math.cos(angle);
        var nSin:Number	= Math.sin(angle);
        var scos:Number	= 1 - nCos;

        var sxy	:Number = axis.x * axis.y * scos;
        var syz	:Number = axis.y * axis.z * scos;
        var sxz	:Number = axis.x * axis.z * scos;
        var sz	:Number = nSin * axis.z;
        var sy	:Number = nSin * axis.y;
        var sx	:Number = nSin * axis.x;

        var nx : Number = (nCos + axis.x * axis.x * scos) * x.x + (-sz + sxy) * x.y + (sy + sxz) * x.z;
        var ny : Number = (sz + sxy) * x.x + (nCos + axis.y * axis.y * scos) * x.y + (-sx + syz) * x.z;
        var nz : Number = (-sy + sxz) * x.x + (sx + syz) * x.y + (nCos + axis.z * axis.z * scos) * x.z;

        return new Number3D(nx, ny, nz);
    }
    
    // axisを軸にangle回転させる変換を、srcsの要素それぞれに適用する
    public static function applyQuaternion(srcs : Array, axis : Number3D, angle : Number) : Array
    {
        var q : Quaternion = Quaternion.createFromAxisAngle(
            axis.x / axis.modulo, 
            axis.y / axis.modulo, 
            axis.z / axis.modulo,
            angle
            );
        var qc : Quaternion = Quaternion.conjugate(q);
        
        var ret : Array = [];
        for each(var src : Number3D in srcs){
            var qSrc : Quaternion = new Quaternion(src.x, src.y, src.z, 0);
            var qDst : Quaternion = Quaternion.multiply(qc, qSrc);
            qDst.mult(q);
            ret.push(new Number3D(qDst.x, qDst.y, qDst.z));
        }
        return ret;
    }
    
    override protected function onRenderTick(e : Event = null) : void
        {
            super.onRenderTick(e);
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }
    }
}