/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r6lK
 */

// forked from clockmaker's drawTriangles for Flash Player 9
/**
 * drawTriangle for Flash Player 9
 * レガシーな時代のトライアングル描写
 * @author yasu
 * @see http://clockmaker.jp/
 */
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    
    [SWF(width="465", height="465")]
    public class Main extends Sprite {
        public function Main() {
            // image
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onLoad);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/4/4b/4bfd/4bfda5176985d9243c3a6887cd736eb942d56ad3"), new LoaderContext(true));
            // bg
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, 465, 465);
            // canvas
            addChild(_base = new Shape());
            // control points
            for (var i:int = 0; i < 4; i++) {
                var sp:Sprite = new Sprite();
                sp.graphics.lineStyle(2, 0xFFFFFF);
                sp.graphics.beginFill(0x0);
                sp.graphics.drawRect(-5, -5, 10, 10);
                sp.x = POSITIONS[ i ][ 0 ];
                sp.y = POSITIONS[ i ][ 1 ];
                sp.buttonMode = true;
                sp.addEventListener(MouseEvent.MOUSE_DOWN, _onMouseEvent);
                addChild(sp);
                _controls[ i ] = sp;
            }
        }
        private const POSITIONS:Array = [[ 100, 100 ], [ 350, 150 ], [ 80, 300 ], [ 400, 400 ]];
        private var _base:Shape;
        private var _bmp:Bitmap;
        private var _currentDrag:Sprite;
        private var _controls:Array /*Sprite*/ = [];
        
        private function _onMouseEvent(e:MouseEvent):void {
            switch (e.type) {
                case MouseEvent.MOUSE_DOWN:
                    _currentDrag = (e.currentTarget as Sprite);
                    _currentDrag.startDrag();
                    stage.addEventListener(MouseEvent.MOUSE_MOVE, _onMouseEvent);
                    stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseEvent);
                    break;
                case MouseEvent.MOUSE_MOVE:
                    _draw();
                    e.updateAfterEvent();
                    break;
                case MouseEvent.MOUSE_UP:
                    _currentDrag.stopDrag();
                    stage.removeEventListener(MouseEvent.MOUSE_MOVE, _onMouseEvent);
                    stage.removeEventListener(MouseEvent.MOUSE_UP, _onMouseEvent);
                    break;
            }
        }
        
        private function _onLoad(e:Event):void {
            _bmp = (e.target as LoaderInfo).content as Bitmap;
            _draw();
        }
        
        private function _draw():void {
            _base.graphics.clear();
            var vertices:Array = [
                _controls[ 0 ].x, _controls[ 0 ].y,
                _controls[ 1 ].x, _controls[ 1 ].y,
                _controls[ 2 ].x, _controls[ 2 ].y,
                _controls[ 2 ].x, _controls[ 2 ].y,
                _controls[ 1 ].x, _controls[ 1 ].y,
                _controls[ 3 ].x, _controls[ 3 ].y,
                ];
            var indices:Array = [
                0, 1, 2,
                2, 1, 3,
                ];
            var uvtData:Array = [
                0, 0,
                1, 0,
                0, 1,
                1, 1,
                ];
            GraphicUtil.drawTriangles(_base.graphics, _bmp.bitmapData, vertices, indices, uvtData);
        }
    }
}
import flash.display.*;
import flash.geom.*;

class GraphicUtil {
    public static function drawTriangles(g:Graphics, bitmapData:BitmapData, vertices:Array /*Number*/, indices:Array /*int*/, uvtData:Array /*Number*/):void {
        if (vertices.length % 6 != 0)
            throw new Error();
        for (var i:int = 0; i < vertices.length; i += 6) {
            var p0:Point = new Point(bitmapData.width * uvtData[ indices[ i / 2 ] * 2 ], bitmapData.height * uvtData[ indices[ i / 2 ] * 2 + 1 ]);
            var p1:Point = new Point(bitmapData.width * uvtData[ indices[ i / 2 + 1 ] * 2 ], bitmapData.height * uvtData[ indices[ i / 2 + 1 ] * 2 + 1 ]);
            var p2:Point = new Point(bitmapData.width * uvtData[ indices[ i / 2 + 2 ] * 2 ], bitmapData.height * uvtData[ indices[ i / 2 + 2 ] * 2 + 1 ]);
            var a0:Point = new Point(vertices[ i ], vertices[ i + 1 ]);
            var a1:Point = new Point(vertices[ i + 2 ], vertices[ i + 3 ]);
            var a2:Point = new Point(vertices[ i + 4 ], vertices[ i + 5 ]);
            var matrix:Matrix = _buildTransformMatrix(p0, p1, p2, a0, a1, a2);
            g.beginBitmapFill(bitmapData, matrix, false, true);
            _drawTriangle(g, p0, p1, p2, matrix);
            g.endFill();
        }
    }
    
    private static function _buildTransformMatrix(
        a0:Point, a1:Point, a2:Point,
        b0:Point, b1:Point, b2:Point):Matrix {
        var matrixA:Matrix = new Matrix(
            a1.x - a0.x, a1.y - a0.y,
            a2.x - a0.x, a2.y - a0.y);
        matrixA.invert();
        var matrixB:Matrix = new Matrix(
            b1.x - b0.x, b1.y - b0.y,
            b2.x - b0.x, b2.y - b0.y);
        var matrix:Matrix = new Matrix();
        matrix.translate(-a0.x, -a0.y); // (原点)へ移動 
        matrix.concat(matrixA); // 単位行列に変換(aの座標系の逆行列)
        matrix.concat(matrixB); // bの座標系に変換 
        matrix.translate(b0.x, b0.y); // b0へ移動 
        return matrix;
    }
    
    private static function _drawTriangle(g:Graphics, p0:Point, p1:Point, p2:Point, matrix:Matrix):void {
        p0 = matrix.transformPoint(p0);
        p1 = matrix.transformPoint(p1);
        p2 = matrix.transformPoint(p2);
        //g.lineStyle(1, 0x808080); // debug
        g.moveTo(p0.x, p0.y);
        g.lineTo(p1.x, p1.y);
        g.lineTo(p2.x, p2.y);
        g.lineTo(p0.x, p0.y);
    }
}