/**
 * Copyright CuchuFlurito ( http://wonderfl.net/user/CuchuFlurito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r6l2
 */

// forked from CuchuFlurito's forked from: forked from: 3D tag cloud
// forked from esabear's 3D tag cloud
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.filters.BitmapFilterQuality;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.materials.special.BitmapParticleMaterial;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.events.InteractiveScene3DEvent;

    public class FlashTest extends Sprite {
        private var scale:Number = 20;
        private var radius:Number = 750;
        private var smoothing:Boolean = true;
        private var minAlpha:Number = 0.3;
        private var tags:Array;
        private var tag_num:uint;
        private var bv:BasicView;
        private var tagArray:Array;
        private var tagContainer:DisplayObject3D;

        public function FlashTest() {
            // write as3 code here..
            init ();
        }
        
        private function init ():void {
            tags = ["Pubis 1","Pubis 2","Pubis 3","Pubis 4","Pubis 5","Pubis 6","Pubis 7","Pubis 8","Pubis 9","Pubis 0","Pecho 0","Pecho 1", "Pecho 2", "Pecho 3", "Pecho 4", "Pecho 5", "Pecho 6", "Pecho 7", "Pecho 8", "Pecho 9", "Boca 0", "Boca 1", "Boca 2", "Boca 3", "Boca 4", "Boca 5", "Boca 6", "Boca 7", "Boca 8", "Boca 9", "Ojos 0", "Ojos 1", "Ojos 2", "Ojos 3", "Ojos 4", "Ojos 5", "Ojos 6", "Ojos 7", "Ojos 8", "Ojos 9"];
            tag_num = tags.length;
            tagArray = [];
            tagContainer = new DisplayObject3D ("tag_container");
            tagContainer.x = -radius * 0.5;
            tagContainer.y =  radius * 0.25;
            
            bv = new BasicView (stage.stageWidth, stage.stageHeight, true, true);
            bv.viewport.interactive = true;
            bv.scene.addChild (tagContainer);
            bv.camera.z = -2 * radius;
            bv.camera.zoom = 30;
            bv.startRendering ();
            
            addChild (bv);
            
            buildTags ();
            
            addEventListener (Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function buildTags ():void {
            var i:uint;
            for (i = 0; i < tag_num; i++) {
                // 2D
                var txt:TextField = new TextField ();
                txt.text = tags[i];
                var txtW:Number = txt.textWidth + 17;
                var txtH:Number = txt.textHeight + 4;
                var bitmap:BitmapData = new BitmapData (txtW, txtH, true, 0x01FFFFFF);
                    bitmap.draw (txt);

                var phi:Number = Math.acos((2 * (i + 1) - 1) / tag_num - 1);
                var theta:Number = Math.sqrt(tag_num * Math.PI) * phi;

                // 3D
                var material:BitmapParticleMaterial = new BitmapParticleMaterial (bitmap);
                    material.interactive = true;
                    material.smooth = smoothing;
                var tag:Particle = new Particle (material, scale, 0, 0, 0);
                var tagHolder:Particles = new Particles ("tag_");
                    tagHolder.addParticle (tag);
                    tagHolder.x = radius * Math.cos (theta) * Math.sin (phi);
                    tagHolder.y = radius * Math.sin (theta) * Math.sin (phi);
                    tagHolder.z = radius * Math.cos (phi);
                    tagHolder.useOwnContainer = true;
                    tagHolder.autoCalcScreenCoords = true;
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OVER, objectOverHandler);
                    tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_OUT, objectOutHandler);
                    //tagHolder.addEventListener (InteractiveScene3DEvent.OBJECT_PRESS, objectPressHandler);

                tagContainer.addChild (tagHolder);
                tagArray.push (tagHolder);
            }
        }
        
        private function objectOverHandler (e:InteractiveScene3DEvent):void {
	    bv.viewport.buttonMode = true;
            
        }

        private function objectOutHandler (e:InteractiveScene3DEvent):void {
	    bv.viewport.buttonMode = false;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray [j].filters = [];
            }
        }
        
        private function enterFrameHandler (e:Event):void {
            tagContainer.rotationX += (mouseY - stage.stageHeight * 0.5) * 0.01;
            tagContainer.rotationY += (mouseX - stage.stageWidth * 0.5) * 0.01;

            for (var j:uint = 0; j < tag_num; j++) {
                tagArray[j].alpha = minAlpha + (1 - minAlpha) * (1 - (tagArray[j].screen.z - radius) / (2 * radius));
            }
        }
    }
}