/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r6kc
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(backgroundColor=0)]
    public class Gallery extends Sprite {
        public var _data_array:Array;
        public var _loadCount:int;
        
        public function Gallery() {
            stage.align = "TL";
            stage.scaleMode = "noScale";
            
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener(Event.COMPLETE, onCompleteXML);
            
            var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&q=moon&imglic=commercial&max-results=6&imgmax=512&start-index=1";
            Security.loadPolicyFile("http://photos.googleapis.com/data/crosssdomain.xml");
            
            myURLLoader.load(new URLRequest( xmlURL ));
        }
        
        private function onCompleteXML(e:Event):void {
            var myXML:XML = new XML( e.currentTarget.data );
            default xml namespace = new Namespace("http://search.yahoo.com/mrss/");
            _data_array = [];
            
            for(var i:int=0;i<6;i++){
                var loader:Loader = new Loader();
                var myURLRequest:URLRequest = new URLRequest(myXML.channel.item[i].group.content.@url);
                
                var myLoaderContext:LoaderContext = new LoaderContext(true);
                loader.load(myURLRequest, myLoaderContext);
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
                
                var data:Object = new Object();
                data["link"] = myXML.channel.item[i].link;
                data["credit"] = myXML.channel.item[i].group.credit;
                data["loader"] = loader;
                
                _data_array[i] = data;
            }
        }
        
        private function onCompleteImg(e:Event):void {
            _loadCount ++;
            if(_loadCount < 6){ return; };
            
            for(var i:int=0;i<6;i++){
                var imgWidth:int = _data_array[i].loader.content.width;
                var imgHeight:int = _data_array[i].loader.content.height;
                
                var myBitmapData:BitmapData = new BitmapData(imgWidth, imgHeight);
                myBitmapData.draw( _data_array[i].loader.content );
                
                var smoothBitmap:Bitmap = new Bitmap(myBitmapData, "auto", true);
                _data_array[i]["bitmap"] = smoothBitmap;
            }
            
            addChild( _data_array[1].loader );
                      
        } 
    }
}