/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r5kv
 */

package 
{
   import flash.display.Bitmap;
   import flash.display.BitmapData;
   import flash.display.Sprite;
   import flash.display.StageQuality;
   import flash.events.Event;
   import flash.events.MouseEvent;
   import flash.filters.BlurFilter;
   import flash.geom.ColorTransform;
   import flash.geom.Point;
   
   /**
    * ...
    * @author Thi
    */
   public class Particulas extends Sprite 
   {
      
      public function Particulas():void 
      {
         if (stage) init();
         else addEventListener(Event.ADDED_TO_STAGE, init);
      }
      
      private function init(e:Event = null):void 
      {
         removeEventListener(Event.ADDED_TO_STAGE, init);
         // entry point
         stage.frameRate = 0
         stage.quality = StageQuality.LOW
         stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
         //
         vars()
         
      }
      
      //_____________________________________________________________________________
      private function ativar(e:MouseEvent = null):void
      {
         stage.frameRate = 24
         stage.removeEventListener(MouseEvent.MOUSE_MOVE, ativar)
         stage.addEventListener(Event.MOUSE_LEAVE, desativar)
         stage.quality = StageQuality.BEST;
         //
         Px[0] = mouseX + .5 / scale
         Py[0] = mouseY / scale
      }
      
      private function desativar(e:Event = null):void
      {
         stage.frameRate = 0
         stage.addEventListener(MouseEvent.MOUSE_MOVE, ativar)
         stage.removeEventListener(Event.MOUSE_LEAVE, desativar)
         stage.quality = StageQuality.LOW
      }
      //_____________________________________________________________________________
      
      private var Sw:Number = stage.stageWidth, Sh:Number = stage.stageHeight
      
      private var numPart:int = 1000
      private var Px:Vector.<Number> = new Vector.<Number>(numPart) // posição x
      private var Py:Vector.<Number> = new Vector.<Number>(numPart) // posição y
      private var Pvx:Vector.<Number> = new Vector.<Number>(numPart) // velo x
      private var Pvy:Vector.<Number> = new Vector.<Number>(numPart) // velo y
      private var Pc:Vector.<Number> = new Vector.<Number>(numPart) // cor
      private function vars():void
      {
         iniVector()
         iniStuff()
         addListeners()
      }
      
      private function iniVector():void
      {
         var i:int = 0
         while (i < numPart)
         {
            Px[int(i)] = Math.random() * Sw1
            Py[int(i)] = Math.random() * Sh1
            Pvx[int(i)] =  Math.random() * 8 - 4
            Pvy[int(i)] =  Math.random() * 8 - 4
            Pc[int(i)] = 0xFFFFFF //uint(Math.random() * 16777215)
            ++i
         }
         Pc[0] = 0xFF0000
         Pc[Pc.length-1] = 0xFF00FF
      }
      
      private var D:BitmapData
      private var B:Bitmap 
      
      private var scale:Number = 40
      //private var scale_direto:int = 1 << scale
      private var Sw1:Number = stage.stageWidth / scale, Sh1:Number = stage.stageHeight / scale
      
      private var VM:Number = .5
      
      private function iniStuff():void
      {
         D = new BitmapData(Sw, Sh, false, 0xFFFFFF)
         B = new Bitmap(D, "auto", true)
         B.scaleX = B.scaleY = scale
         stage.addChild(B)
      }
      
      private function addListeners():void
      {
         stage.addEventListener(Event.ENTER_FRAME, ef)
         stage.addEventListener(Event.ENTER_FRAME, bitmapRefresh)
         stage.addEventListener(Event.ENTER_FRAME, scaleRefresh)
      }
      
      private function ef(e:Event = null):void
      {
         D.lock()
         particulasRefresh()
         partRefresh()
         D.unlock()
         
      }
      
      private function partRefresh():void
      {
         var l:int = numPart - 1
         var X:Number = Px[l]
         var Y:Number = Py[l]
         var VX:Number = Pvx[l]
         var VY:Number = Pvy[l]
         var C:Number = Pc[l]
         
         
         var DX:Number = mouseX / scale - X
         var DY:Number = mouseY / scale - Y
         var Dist:Number = Math.sqrt(DX * DX + DY * DY)
         
         var MX:Number = VM * DX / Dist
         var MY:Number = VM * DY / Dist
         
         MX = MX < 0? -MX : MX
         MY = MY < 0? -MY : MY
         
         
         VX += DX / Dist
         VY += DY / Dist
         
         if (VX > 0 && VX > MX)
         {
            VX = MX
         }
         else if (VX < 0 && VX < -MX)
         {
            VX = -MX
         }
         if (VY > 0 && VY > MY)
         {
            VY = MY
         }
         else if (VY < 0 && VY < -MY)
         {
            VY = -MY
         }
         
         X += VX
         Y += VY
         
         X = X<0? X + Sw1 : X > Sw1? X - Sw1 : X
         Y = Y<0? Y + Sh1 : Y > Sh1? Y - Sh1 : Y
         
         D.setPixel(X, Y, C)
         
         Px[l] = X
         Py[l] = Y
         Pvx[l] = VX
         Pvy[l] = VY
         Pc[l] = C
         
         
      }
      
      private function particulasRefresh():void
      {
         
         var i:int = 0
         while (i < numPart-1)
         {
            var X:Number = Px[int(i)]
            var Y:Number = Py[int(i)]
            var VX:Number = Pvx[int(i)]
            var VY:Number = Pvy[int(i)]
            var C:Number = Pc[int(i)]
            
            var DX:Number = Px[int(i + 1)] - X
            var DY:Number = Py[int(i + 1)] - Y
            var Dist:Number = Math.sqrt(DX * DX + DY * DY)
            
            var MX:Number = VM * DX / Dist
            var MY:Number = VM * DY / Dist
            
            MX = MX < 0? -MX : MX
            MY = MY < 0? -MY : MY
            
            
            VX += DX / Dist
            VY += DY / Dist
            
            if (VX > 0 && VX > MX)
            {
               VX = MX
            }
            else if (VX < 0 && VX < -MX)
            {
               VX = -MX
            }
            if (VY > 0 && VY > MY)
            {
               VY = MY
            }
            else if (VY < 0 && VY < -MY)
            {
               VY = -MY
            }
            
            X += VX
            Y += VY
            
            X = X<0? X + Sw : X > Sw? X - Sw : X
            Y = Y<0? Y + Sh : Y > Sh? Y - Sh : Y
            
            D.setPixel(X, Y, C)
            
            Px[int(i)] = X
            Py[int(i)] = Y
            Pvx[int(i)] = VX
            Pvy[int(i)] = VY
            Pc[int(i)] = C
            
            ++i
         }   
      }
      
      
      
      private var col:ColorTransform = new ColorTransform(Math.random()*2, Math.random()*2, Math.random()*2, .9)
      private var blur:BlurFilter = new BlurFilter(2, 2, 1)
      private var scale2:Number = scale
      private function bitmapRefresh(e:Event = null):void
      {
         if (Math.random() > 0/*.95*/)
         {
            D.colorTransform(D.rect, col)
            D.applyFilter(D, D.rect, new Point(0, 0), blur)
            
            if (scale2 > 1)
            {
               --scale2
               VM += .18
               trace(scale2)
               trace(VM)
            }
            
            else if (Math.random() > .9)
            {
               stage.removeEventListener(Event.ENTER_FRAME, bitmapRefresh)
               stage.addEventListener(Event.ENTER_FRAME, bitmapRefresh2)
               
               col = new ColorTransform(R, G, Bl, 1)
               R2 = Math.random() + .55
               G2 = Math.random() + .55
               B2 = Math.random() + .55
            }
         }
      }
      
      private var col2:ColorTransform = new ColorTransform(1, 1, 1, .9)
      private var R:Number = Math.random()+.8
      private var G:Number = Math.random()+.8
      private var Bl:Number = Math.random()+.8
      private var R2:Number, G2:Number, B2:Number
      private function bitmapRefresh2(e:Event = null):void
      {
         
         D.colorTransform(D.rect, col)
         D.applyFilter(D, D.rect, new Point(0, 0), blur)
         
         if (Math.random() > .9)
         {
            R2 = Math.random() + .55
            G2 = Math.random() + .55
            B2 = Math.random() + .55
            
            if (Math.random() > .9)
            {
               var i:int = 0
               while (i < numPart)
               {
                  Px[int(i)] = i+mouseX
                  Py[int(i)] = i+mouseY
                  ++i
               }
               
            }
         }
         
            
         R += (R2 - R) * .1
         G += (G2 - G) * .1
         Bl += (B2 - Bl) * .1
         col = new ColorTransform(R,G,Bl,1)
            
         
      }
      
      private function scaleRefresh(e:Event = null):void
      {
         if (scale > 10)
         {
            stage.quality = StageQuality.LOW
         } else 
         {
            stage.quality = StageQuality.HIGH
         }
         if (scale > 1.01)
         {
            scale += (scale2 - scale) * .1
            Sw1 = stage.stageWidth / scale 
            Sh1 = stage.stageHeight / scale
            B.scaleX = B.scaleY = scale
            D.scroll(scale/scale2,scale/scale2)
         } else {
            scale = 1
            Sw1 = stage.stageWidth / scale 
            Sh1 = stage.stageHeight / scale
            B.scaleX = B.scaleY = scale
            D.scroll(scale / scale2, scale / scale2)
            stage.removeEventListener(Event.ENTER_FRAME,scaleRefresh)
         }
         
         
         
      }
      
      
   }
}