/**
 * Copyright aass ( http://wonderfl.net/user/aass )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r5Sz
 */



package {
	import flash.display.Sprite;
    import flash.events.Event;
    public class BallFollowingMouse extends Sprite {
    		private var ballCount:uint = 50;
    		private var speed:Number = 0.1;
    		
        public function BallFollowingMouse() {
            // write as3 code here..
            for (var i:uint = 0; i < ballCount; i++) {
            		addChild(new Ball(this, 300));
            		//プライベートなクラスBallで丸を描く
            }
        		addEventListener(Event.ENTER_FRAME, followMouse);
         }
        private function followMouse(eventObject:Event):void {
        		//カスタムイベントを配信する
        		dispatchEvent(new BallEvent(BallEvent.FOLLOW, mouseX, mouseY, speed));
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;

class Ball extends Sprite {
	
	private var angle:Number;
	private var radius:Number;
	private var sizeRate:Number = 0.1;
	private const deceleration:Number = 0.2;
	//コンストラクタ（第２引数＝マウスからの最大距離）
	public function Ball(timeline:Sprite, maxRadius:Number) {
		var randomRate:Number = Math.random();
		angle = 2 * Math.PI * Math.random();
		radius = maxRadius * randomRate;	//各ボールインスタンスの距離をランダムに決める
		createBall(randomRate);
		timeline.addEventListener(BallEvent.FOLLOW, follow);	//イベントリスナーの登録
	}
	private function createBall(randomRate:Number):void {
		var myGraphics:Graphics = graphics;
		myGraphics.beginFill(Math.floor(0xFFFFFF * randomRate) + 1);
		myGraphics.drawCircle(0, 0, radius * sizeRate);
		alpha = 1 - randomRate;	//距離が離れるほど透明に
	}
	private function follow(eventObject:BallEvent):void {
		var randomRate:Number = Math.random();
		angle += eventObject.speed;
		angle %= Math.PI*2;
		var nX:Number = eventObject.targetX + radius * Math.cos(angle);
		var nY:Number = eventObject.targetY + radius * Math.sin(angle);
		x += (nX - x) * deceleration * randomRate;
		y += (nY - y) * deceleration * randomRate;
	}
}
class BallEvent extends Event {
	public static const FOLLOW:String = "follow";
	private var _targetX:Number;
	private var _targetY:Number;
	private var _speed:Number;
	public function get targetX():Number {
		return _targetX;
	}
	public function get targetY():Number {
		return _targetY;
	}
	public function get speed():Number {
		return _speed;
	}
	public function BallEvent(event_str:String, myTargetX:Number, myTargetY:Number, mySpeed:Number) {
		super(event_str);
		_targetX = myTargetX;
		_targetY = myTargetY;
		_speed = mySpeed;
	}
	public override function clone():Event {
		return new BallEvent(type, targetX, targetY, speed);
	}
	public override function toString():String{
		return formatToString("BallEvent", "type", "bubbles", "cancelable", "eventPhase", "targetX", "targetY", "speed");
	}
}
