/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r50i
 */

// forked from yuuganisakase's 3D Mandelbrot 
package  
{
	import com.flashdynamix.motion.layers.BitmapLayer;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.papervision3d.core.effects.BitmapColorEffect;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]
	public class Mandelblob extends BasicView
	{
		private var bfx:BitmapEffectLayer;
		private var pixels:Pixels;
		private var i:int = 0;
		
		private var pool:PixelPool = new PixelPool();
		
		public function Mandelblob() 
		{
    Wonderfl.capture_delay( 33);
			super(465, 465, true, false, "Target");
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.addEventListener(Event.ENTER_FRAME, onEnter);
			setup();
		}
		private function setup():void
		{
			bfx = new BitmapEffectLayer(viewport, 465, 465, false, 0xeeeeee, "clear_pre", false, false);
//			bfx.filters = [ new BlurFilter(2, 2, 1) ];
			pixels = new Pixels(bfx);
			
			scene.addChild(pixels);
			
			viewport.containerSprite.addLayer(bfx);
			camera.z = -260;
			camera.x = 388;
			camera.y = 150;
			var t:DisplayObject3D = new DisplayObject3D();
			t.x = 190;
			t.y = 120;
			t.z = 50;
			camera.target = t;
		}
		
		 
		public function calc_stroke3D(x:int, y:int, z:int):int {
			var sc:int = 380;
            var cx:Number = (x  - sc  / 2.2)/ (sc *0.55);
            var cy:Number = (y - sc/ 2.3)/ (sc*0.45);
			var cz:Number =  (z -sc /4) / (sc *0.38);
			
            var xx:Number = 0.0;
            var yy:Number = 0.0;
			var zz:Number = 0.0;
            
			var nnn:int = 2;
			
			
			var n:int;
            for (n = 1; n < 16; n++) {
                 var r2:Number = xx * xx + yy * yy + zz * zz;
                 if(r2 > 4){n--; break;}
                 var theta:Number = Math.atan2(Math.sqrt(xx * xx + yy * yy), zz);
        	 var phi:Number = Math.atan2(yy, xx) ;
//				 var t0:Number = Math.pow(r2, nnn/2);
				 var t1:Number = Math.sin(theta * nnn);
				 
                 xx = r2 * t1 * Math.cos(phi * nnn) + cx;
				 yy = r2 * t1 * Math.sin(phi * nnn) + cy;
				 zz = r2 * Math.cos(theta * nnn) + cz;
             }
             return n *255/15;
        }

		private function onEnter(e:Event):void 
		{
			var num:int = 380;
			var n:int = pixels.pixels.length;
			for (var uu:int = 0; uu < n; uu++) {
				pool.disposeObject(pixels.pixels[uu]);
			}
			pixels.removeAllpixels();
			
			if (i < num) {
				for (var j:int = 0; j < num; j++) {
					if (i % 2 != 0) {
						break;
					}

					var ss:int = num * 0.07;
					
					for (var k:int = 0; k < ss; k++) {
						var c:uint = calc_stroke3D(i, j,k);
						
						if (c > 60) {
							
							var cc:uint = c << 16 | c << 8 | c << 0;
							pixels.addPixel3D(pool.getObject(cc, i , j , k));
						}
					}
				}
				trace("pixels length = " + pixels.pixels.length);
			}
			i += 1;

			singleRender();
		}
				
	}

}
import org.papervision3d.core.geom.renderables.Pixel3D;
class PixelPool
{
	public var array:Vector.<Pixel3D> = new Vector.<Pixel3D>();
	
	public function PixelPool():void
	{
		
	}
	public function getObject(_c:uint, _x:Number, _y:Number, _z:Number):Pixel3D
	{
		if (array.length != 0) {
			var p:Pixel3D = array.pop();
			p.x = _x;
			p.y = _y;
			p.z = _z;
			p.color = _c;
			return p;
		}else {
			return new Pixel3D(_c, _x, _y, _z);
		}
	}
	public function disposeObject(_p:Pixel3D):void
	{
		array.push(_p);
	}
	
}






