/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r4Xk
 */

// forked from robertpenner's forked from: [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from clockmaker's [PV3D]BitmapFileMaterialを利用した場合のクロスドメイン対処方法
// forked from a24's forked from: [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
package {
    import flash.system.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    /**
    * 外部画像をBitmapFileMaterialを使って読み込むデモ
    */
    public class Main extends BasicView {
        public function Main():void {
            opaqueBackground = 0x0; // 背景を黒くする
            
            // クロスドメイン対策
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            // 画像ファイルのパス
            const url:String = "http://assets.wonderfl.net/images/related_images/7/7a/7a1e/7a1e6ef276b0d7da95e79499fbfae10ceee8e9b6";
            
            // マテリアル(テクスチャ)をBitmapFileMaterialとして作成
            var material:BitmapFileMaterial = new BitmapFileMaterial(url, true);
            material.doubleSided = true; // 両面にテクスチャを貼る
            
            // 平面を作成
            var tree1:Plane = new Plane(material, 1200, 1200);
            var step:Number = 15;
            
            // 画面を表示
            scene.addChild(tree1);
             
            // レンダリング開始
            startRendering();
            
            // ついでに回転でもさせておく
            addEventListener("enterFrame", function():void {
                   var direction:Number = 1;
                   if (tree1.z >= 800)
                        direction = -1;
                   else if (tree1.z <= 0)
                        direction = 1;
                   tree1.z += step*direction; 
                  
            });
        }
    }
}