/**
 * Copyright Izotopus ( http://wonderfl.net/user/Izotopus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r3yH
 */

// forked from shapevent's Zoom Pan
package {

	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.geom.*;


       [SWF(width=500, height=500, frameRate=30, backgroundColor=0xFFFFFF)]

       public class ZoomPan extends MovieClip {
           
		private var sw:Number;
		private var sh:Number;
		private var s:Shape;
		private var scale:Number;
		private var scaleDest:Number;
		private var down:Boolean;
		private var dx:Number;
		private var dy:Number;
		private var time:Number;


               public function ZoomPan(){
                  // init
			sw = stage.stageWidth;
			sh = stage.stageHeight;
			
			s = Shape(addChild(new Shape()));
			
			scale = 1;
			scaleDest = 1;
			down = false;
			dx = 0, dy = 0, time = 0;
			
			addInstructions();
			vectorTexture();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
			addEventListener(Event.ENTER_FRAME, onLoop);
			
			
			
			
			
			
			
			
			

               }
               // private methods

		private function addInstructions():void{
			var instruct:Sprite = Sprite(addChild(new Sprite()));
			with (instruct.graphics) beginFill(0x666666), drawRect(0,0,285, 30);
			instruct.x = instruct.y = 20;
			var txt:TextField = TextField(instruct.addChild(new TextField()));
			txt.defaultTextFormat = new TextFormat("Verdana", 11);
			txt.x = txt.y = 5;
			txt.selectable = false;
			with (txt) textColor = 0xFFFFFF, autoSize = "left", text = "Click and hold to zoom, move mouse to pan";
		}
		private function vectorTexture():void{
			var cols:Vector.<uint> = Vector.<uint>([0xFFFFFF, 0x000000]);
			var rnd:Vector.<Number> = new Vector.<Number>(6, true);
			
			for(var i:int = 0 ; i<50; i++){
				with(s.graphics){
					lineStyle(Math.random() * 50 + 2, cols[int(Math.random()*cols.length)]);
					drawCircle(Math.random() * sw, Math.random() * sh, 10 + Math.random() * Math.random() * 400);
				}
			}
			s.graphics.lineStyle(20, 0xCCCCCC);
			s.graphics.drawRect(0, 0,sw, sh);
		}
		private function onDown(evt:MouseEvent):void{ down = true; }
		private function onUp(evt:MouseEvent):void{ down = false; }
		private function onLoop(evt:Event):void {
		   if (down){
			 scaleDest *= 1.05;  
			 time = 0;
		   }else{
			 time++;
			 // zoom out after 30 iterations
			 if (time == 30){
				 scaleDest = 1;  
			 }
		   }
		   scale += (scaleDest - scale) / 4;
		   if (scale > 10) scale = scaleDest = 10;
		   
		   dx += (mouseX - dx) / 4;
		   dy += (mouseY - dy) / 4;
		   if (dx < 0) dx = 0;
		   if (dy < 0) dy = 0;
		   if (dx > sw) dx = sw;
		   if (dy > sh) dy = sh;
		   
		   // matrix zoom/pan
		   var m:Matrix = s.transform.matrix;
		   m.identity();
		   m.translate(-dx,-dy);
		   m.scale(scale, scale);
		   m.translate(dx,dy);
		   s.transform.matrix = m;
		}
		

       }

}