/**
 * Copyright yasohachi ( http://wonderfl.net/user/yasohachi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r3hl
 */

package
{
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.core.effects.BitmapColorEffect;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	[SWF(width=465,height=465,backgroundColor=0x0,frameRate=30)]
	public class MagicSquare extends Sprite
	{
		private var container:Sprite;
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var renderer:BasicRenderEngine;
		private var rootNode:DisplayObject3D;
		private var bfx:BitmapEffectLayer;
		private var circle:Plane;
		private var ct:ColorTransform;
		private var pixels:Pixels;
		private var pixelList:Array;
		
		public function MagicSquare()
		{
			stage.quality = StageQuality.HIGH;
			container = new Sprite();
			addChild(container);
			container.x = stage.stageWidth/2;
			container.y = stage.stageHeight/2;
			
			viewport = new Viewport3D(0,0,true,true);
			scene = new Scene3D();
			camera = new Camera3D();
			renderer = new BasicRenderEngine();
			rootNode = scene.addChild(new DisplayObject3D("rootNode"));
			addEventListener(Event.ENTER_FRAME,onFrame);
			
			addChild(viewport);
			camera.zoom = 30;
			camera.focus = 200;
			camera.target = DisplayObject3D.ZERO;
			
			bfx = new BitmapEffectLayer(viewport,stage.stageWidth,stage.stageHeight,true,0,BitmapClearMode.CLEAR_PRE);
			bfx.addEffect(new BitmapLayerEffect(new BlurFilter(2,2,4)));
			bfx.addEffect(new BitmapColorEffect(0.99,0.98,0.98,0.95));
			
			ct = new ColorTransform(1,1,1,1);
			bfx.drawCommand = new BitmapDrawCommand(null,ct,BlendMode.ADD);
			bfx.clippingPoint = new Point(0,-7);
			bfx.drawLayer.blendMode = BlendMode.OVERLAY;
			viewport.containerSprite.addLayer(bfx);
			
			var mat2:MovieMaterial = new MovieMaterial(makeCircle());
			mat2.smooth = true;
			circle = new Plane(mat2,50,50);
			circle.rotationX += 80;
			circle.y -= 15;
			rootNode.addChild(circle);
			bfx.addDisplayObject3D(circle);
			
			initPixels();
			scene.addChild(pixels);
			
			/*
			var particle:ParticleMaterial = new ParticleMaterial(0xffffff,1,ParticleMaterial.SHAPE_CIRCLE);
			var particles:ParticleField = new ParticleField(particle,1000,0.3,500,500,500);
			scene.addChild(particles);
			*/
		}
		
		private function makeCircle():Sprite{
			var spr:Sprite = new Sprite();
			spr.graphics.beginFill(0xccccff,1);
			spr.graphics.drawCircle(0,0,25);
			spr.graphics.drawCircle(0,0,22);
			spr.graphics.endFill();
			
			var rad:int = 0;
			var dr:int = 360 / 5 * 2;
			var deg:Number;
			
			spr.graphics.lineStyle(2,0xffffff);
			spr.graphics.moveTo(22*Math.cos(0),22*Math.sin(0));
			for(var i:int = 0;i < 5;i++){
				rad += dr;
				if(rad >= 360) rad -= 360;
				deg = rad * Math.PI / 180;
				spr.graphics.lineTo(22*Math.cos(deg),22*Math.sin(deg));
			}
			return spr;
		}
		
		private function initPixels():void{
			var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport,465,465,true,0,BitmapClearMode.CLEAR_PRE,true);
			viewport.containerSprite.addLayer(layer);
			layer.addEffect(new BitmapLayerEffect(new BlurFilter(4,4,4),true));
			pixels = new Pixels(layer);
			pixelList = [];
			addPixel3D();
			pixels.rotationX += 80;
			pixels.y -= 15;
		}
		
		private function addPixel3D():void{
			var num:int = Math.floor(Math.random() * 1000) % 30 + 20;
			for(var i:int = 0;i < num;i++){
				pixels.addPixel3D(makePixel3D());
			}
		}
		
		private function makePixel3D():Pixel3D{
			var rad:Number = Math.random() * 360 * Math.PI / 180;
			var x:Number = 25 * Math.sin(rad);
			var y:Number = 25 * Math.cos(rad);
			var z:Number = -3 * Math.random();
			var p:Pixel3D = new Pixel3D(0xffffff00,x,y,z);
			pixelList.push(p);
			return p;
		}
		
		public function onFrame(e:Event):void{
			circle.roll(5);
			pixels.roll(5);
			for(var i:int = pixelList.length-1;i > -1;i--){
				var p:Pixel3D = Pixel3D(pixelList[i]);
				p.z -= 2;
				if(p.z < -30){
					pixels.removePixel3D(p);
					pixelList.splice(i,1);
				}else{
					p.x *= 1.015;
					p.y *= 1.015;
				}
			}
			addPixel3D();
			renderer.renderScene(scene,camera,viewport);
		}
		
	}
}