/**
 * Copyright moriyak ( http://wonderfl.net/user/moriyak )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r3Vh
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Rectangle;
	
	/**
	 * こんなかんじにTumblrとかをみたいんです。
	 * 周辺視野使ったRSSリーダなんて楽しそう。
	 *
	 * カーソルキーで移動、スペースで拡大。
	 *
	 * @author moriyak
	 */
	public class Main extends Sprite 
	{
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			var desk:Desk = new Desk();
			desk.x = (stage.stageWidth - Constants.CARD_WIDHT) / 2;
			desk.y = (stage.stageHeight - Constants.CARD_HEIGHT) / 2;
			this.addChild(desk);
			
			var controller:Controller = new Controller(desk, this.stage);
			
			makeMask();
		}
		
		private function makeMask():void
		{
			var bmd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true);
			bmd.fillRect(new Rectangle(0, 0, stage.stageWidth, stage.stageHeight), 0xAA000000);
			bmd.fillRect(new Rectangle((stage.stageWidth - Constants.CARD_WIDHT) / 2, (stage.stageHeight - Constants.CARD_HEIGHT) / 2,
				Constants.CARD_WIDHT, Constants.CARD_HEIGHT), 0x000000);
			var bmp:Bitmap = new Bitmap(bmd);
			bmp.filters = [new BlurFilter(40, 40)];
			this.addChild(bmp);
		}
		
	}
	
}


	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.display.Stage;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	import caurina.transitions.Tweener;
	

	class Card extends Sprite
	{
		private var tf:TextField;
		private var bmp:Bitmap;
		
		public function Card(useBitmap:Boolean=true) 
		{
			initFace(useBitmap);
		}
		
		private function initFace(useBitmap:Boolean):void
		{
			this.graphics.beginFill(0xFFFFFF);
			this.graphics.drawRect(0, 0, Constants.CARD_WIDHT, Constants.CARD_HEIGHT);
			this.graphics.endFill();
			this.filters = [new DropShadowFilter()];	
			
			var sp:Sprite = new Sprite();
			var title:TextField = new TextField();
			title.text = "Test Card";
			title.autoSize = TextFieldAutoSize.LEFT;
			
			var fmt:TextFormat = new TextFormat();
			fmt.size = 25;
			title.setTextFormat(fmt);
			sp.addChild(title);
			
			tf = new TextField();
			tf.width = this.width;
			tf.height = this.height;
			tf.text = "ffoooooooooooooooooooooobaaarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr";
			tf.wordWrap = true;
			tf.y = title.height + 5;
			tf.autoSize = TextFieldAutoSize.LEFT;
			sp.addChild(tf);
			
			if(useBitmap) {
			var bmd:BitmapData = new BitmapData(sp.width, sp.height);
			bmd.draw(sp);
			var bmp:Bitmap = new Bitmap(bmd);
			
			this.addChild(bmp);
			return;
			}
			
			this.addChild(sp);
		}
		
	}

class Constants
{
	public static const CARD_WIDHT:int = 200;
		public static const CARD_HEIGHT:int = 110;
		
		public static const CARD_COLUMN:int = 8;
		public static const CRAD_ROW:int = 15;
		
		public static const CARD_MARGIN:int = 5;
		
	}


	class Desk extends Sprite
	{
		private var cardArray:Array = [];
		
		public function Desk() 
		{
			setCards();
		}
		
		private function setCards():void
		{
			for (var i:int = 0; i < Constants.CARD_COLUMN; i++) {
				for (var j:int = 0; j < Constants.CRAD_ROW; j++) {
					var card:Card = new Card();
					
					card.x = (card.width * i) + (Constants.CARD_MARGIN * (i + 1));
					card.y = (card.height * j) + (Constants.CARD_MARGIN * (j + 1));
					
					this.addChild(card);
					
					cardArray.push(card);
				}
			}
		}
		
	}

	class Controller
	{
		private var desk:Desk;
		private var isOnZoom:Boolean;
		private var isZooming:Boolean;
		private var isOnTransition:Boolean;
		private var destX:Number;
		private var destY:Number;
		private var zoomCard:Card;
		
		public function Controller(desk:Desk, stage:Stage)
		{
			this.desk = desk;
			zoomCard = new Card();
			zoomCard.x = (stage.stageWidth - zoomCard.width) / 2;
			zoomCard.y = (stage.stageHeight - zoomCard.height) / 2;
			zoomCard.alpha = 0;
			stage.addChild(zoomCard);
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
		}
		
		
		private function onKeyDown(e:KeyboardEvent):void
		{
			switch(e.keyCode) {
				case Keyboard.LEFT : move("left"); break;
				case Keyboard.RIGHT : move("right"); break;
				case Keyboard.UP : move("up"); break;
				case Keyboard.DOWN : move("down"); break;
				case Keyboard.SPACE : zoomInOut(); break;
			}
		}
		
		private function move(direction:String):void 
		{
			if (this.isOnZoom) return;
			
			if (this.isOnTransition) {
				desk.x = destX;
				desk.y = destY;
			}
			
			this.isOnTransition = true;
			
			var dx:Number = 0;
			var dy:Number = 0;
			
			switch(direction) {
				case "left" : dx = Constants.CARD_WIDHT + Constants.CARD_MARGIN; break;
				case "right" : dx = -Constants.CARD_WIDHT - Constants.CARD_MARGIN; break;
				case "up" : dy = Constants.CARD_HEIGHT + Constants.CARD_MARGIN; break;
				case "down" : dy = -Constants.CARD_HEIGHT - Constants.CARD_MARGIN; break;
			}
			
			destX = desk.x + dx;
			destY = desk.y + dy;
			
			trace("destX : " + destX);
			trace("destY : " + destY);
			
			Tweener.addTween(desk, { x : destX, y:destY, time:0.5, transition:"easeOutExpo", onComplete: onTransComplete } );
		}
		
		private function onTransComplete():void
		{
			this.isOnTransition = false;
		}
		
		private function zoomInOut():void
		{
			if (this.isZooming) return;
			
			var scale:Number = 2;
	
			this.isZooming = true;
			
			var dx:Number = Constants.CARD_WIDHT / 2 * (scale-1);
			var dy:Number = Constants.CARD_HEIGHT / 2 * (scale-1);
			
			if (this.isOnZoom) {
				Tweener.addTween(zoomCard, { x:zoomCard.x + dx, y:zoomCard.y + dy, scaleX:1, scaleY:1, time:0.5, transition:"easeOutExpo", onComplete:onZoomInOutComplete } );
				Tweener.addTween(zoomCard, { alpha:0, time:0.5, transition:"easeOutSine" } );
				return;
			}
			
			zoomCard.alpha = 1;
			Tweener.addTween(zoomCard, { x:zoomCard.x - dx, y:zoomCard.y - dy, scaleX:scale, scaleY:scale, time:0.5, transition:"easeOutExpo", onComplete:onZoomInOutComplete } );
			
			
		}
		
		private function onZoomInOutComplete():void
		{
			this.isZooming = false;
			
			if (this.isOnZoom) {
				this.isOnZoom = false;
				return;
			}
			
			this.isOnZoom = true;
		}
	}