/**
 * Copyright ShipNK ( http://wonderfl.net/user/ShipNK )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r3Nl
 */

package {
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate="60")]
    
    public class FlashTest extends Sprite {
        
        private var i:int;
        private var paper:BitmapData = new BitmapData( 550, 400, false, 0 );
        private var bit:Bitmap = new Bitmap( paper );
        private var shape:Shape = new Shape();
        private var sprite:Sprite = new Sprite();
        private var arr:Array = [];
        private var arrInfo:Array = [];
        
        public function FlashTest() {
            addChild( bit );
            stage.addEventListener( Event.ENTER_FRAME, process );
            stage.addEventListener( MouseEvent.CLICK, clickEvent );
        }
        
        private function clickEvent ( e:MouseEvent ):void
        {
            for( i = 0; i < arr.length; ++ i )
            {
                arrInfo[ i ].xspeed = Math.random() * 100 - 50;
                arrInfo[ i ].xmouse = Math.random() * 550;
            }

        }

        
        private function process (e:Event) :void
        {
            shape = new Shape();
            arr.push( shape );
            arrInfo.push( {xspeed:Math.random() * 17 - 8, xmouse:mouseX} );
            sprite.addChild( shape );
            shape.graphics.beginFill( 0xff0000 + int( Math.random() * 20000 ) );
            shape.graphics.drawCircle( 0, 0, Math.random() * 30 );
            shape.x = mouseX;
            shape.y = mouseY;
            
            //
            
            for( i = arr.length - 1; i > -1; -- i )
            {
                shape = arr[ i ] as Shape;
                shape.y -= 3;
                shape.x += arrInfo[ i ].xspeed;
                shape.alpha *= 0.95;
                shape.scaleX *= 0.97;
                shape.scaleY *= 0.97;
                arrInfo[ i ].xspeed *= 0.9;
                shape.x += ( arrInfo[ i ].xmouse - shape.x ) * 0.1;
            }
            remove();
            
            //
            
            paper.colorTransform( paper.rect, new ColorTransform( 1, 1, 1, 0.9 ) );
            paper.draw( sprite );
            paper.applyFilter( paper, paper.rect, new Point, new BlurFilter( 8, 8 ) );
        }

        private function remove ( ):int
        {
            for(i = arr.length - 1; i > -1; -- i )
            {
                if( arr[ i ].alpha < 0.01 )
                {
                    sprite.removeChild( arr[ i ] );
                    arr.splice( i, 1 );
                    arrInfo.splice( i, 1 );
                    return 0;
                }

            }
            return 0;
        }

    }
}