/**
 * Copyright noonat ( http://wonderfl.net/user/noonat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r2DO
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    [SWF(backgroundColor="#888888")]
    public class Spirals extends Sprite {
        protected var _elapsed:Number = 0;
        protected var _rings:Array = [];
        protected var _text:TextField;
        protected var _time:Number = 0;
        
        function Spirals() {
            addChild(_text = new TextField());
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage, false);
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false);
        }
        
        protected function onAddedToStage(event:Event):void {
            stage.frameRate = 30;
            x = stage.stageWidth / 2;
            y = stage.stageHeight / 2;
            _time = getTimer() / 1000;
            
            var count:uint = 20;
            var radius:Number = 50;
            for (var i:uint = 0; i < 8; ++i) {
                var ring:Ring = new Ring(radius, count, (i % 2 ? -1 : 1));
                _rings.push(ring);
                addChild(ring);
                count += 14;
                radius += 38;
            }
        }
        
        protected function onEnterFrame(event:Event):void {
            var time:Number = getTimer() / 1000;
            _elapsed = Math.min(time - _time, 0.1);
            _time = time;
            rotation += 50 * _elapsed;
            for each (var ring:Ring in _rings) {
               ring.update(_elapsed);
            }
        }
    }
}

import caurina.transitions.Tweener;
import flash.display.Sprite;

class Ring extends Sprite {
    static protected const RAD_TO_DEG:Number = 180 / Math.PI;
    public var angle:Number = 0;
    protected var _angle:Number;
    protected var _angleSign:Number;
    protected var _angleSpeed:Number = 90;
    protected var _squares:Array = [];
    
    function Ring(radius:Number, count:uint, angleSign:Number) {
        _angle = 165 * angleSign;
        _angleSign = angleSign;
        var angleStep:Number = (2 * Math.PI) / count;
        for (var i:uint = 0; i < count; ++i) {
            var angle:Number = i * angleStep;
            var color:uint = i % 2 ? 0xffffff : 0x000000;
            var x:Number =  Math.sin(angle) * radius;
            var y:Number = -Math.cos(angle) * radius;
            var square:Square = new Square(x, y, angle, color);
            square.rotation = angle * RAD_TO_DEG;
            _squares.push(square);
            addChild(square);
        }
        twist(1);
    }
    
    public function straighten(delay:Number=4):void {
        Tweener.addTween(this, {
            angle: 0,
            delay: delay,
            time: 1,
            onComplete: twist
        });
    }
    
    public function twist(delay:Number=2):void {
        Tweener.addTween(this, {
            angle: _angle,
            delay: delay,
            time: 1,
            onComplete: straighten
        });
    }
    
    public function update(elapsed:Number):void {
        for each (var square:Square in _squares) {
            square.rotation = angle + (square.angle * RAD_TO_DEG);
        }
    }
}

class Square extends Sprite {
    public var angle:Number;
    
    function Square(x:Number, y:Number, angle:Number, color:uint) {
        graphics.clear();
        graphics.lineStyle(1.4, color, 0.6, true, 'none', 'miter', 'square');
        graphics.drawRect(-5.5, -5.5, 11.5, 11.5);
        this.angle = angle;
        this.x = x;
        this.y = y;
    }
}
