/**
 * Copyright guillaume_guillaume ( http://wonderfl.net/user/guillaume_guillaume )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r1p5
 */

// forked from hig_an's flash on 2010-2-11
//forked from hig_an's snow
package {
	import flash.display.SpreadMethod;
    import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.PixelSnapping;
    import flash.events.Event;
    import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import net.hires.debug.Stats;
	
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    public class Saq001 extends Sprite {
		private static const GRAVITY:Number = 20;
		private static const DRAG:Number = 0.3;
		
		private var _canvas:BitmapData;
		private var _glow:BitmapData;
		private var _glowMtx:Matrix;
		private var _forceMap:BitmapData;
		private var _snow:Array;
		
		public function Saq001():void {
			this._canvas = new BitmapData(465, 465, false, 0x0);
			this.addChild(new Bitmap(this._canvas)) as Bitmap;
			
			this._glow = new BitmapData(465 / 4, 465 / 4, false, 0x0);
			var bm:Bitmap = this.addChild(new Bitmap(this._glow, PixelSnapping.NEVER, true)) as Bitmap;
			bm.scaleX = bm.scaleY = 4;
			bm.blendMode = BlendMode.ADD;
			this._glowMtx = new Matrix(0.25, 0, 0, 0.25);
			
			var tf:TextField = new TextField();
			tf.defaultTextFormat = new TextFormat('Verdana', 64, 0xffffff, true);
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.text = "WONDERFL";
			tf.x = (465 - tf.width) / 2;
			tf.y = (465 - tf.height) / 2;
			this._forceMap = new BitmapData(465, 465, false, 0x0);
			this._forceMap.draw(tf, tf.transform.matrix);
			this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0, 0), new BlurFilter(8, 8));
			
			this._snow = [];
			this.addChild(new Stats());;
			this.addEventListener(Event.ENTER_FRAME, this.updata);
		}
		public function emitParticle(ex:Number, ey:Number, s:Number = 1, c:int = 0xffffff, vx:Number = 0, vy:Number = 0):void {
			var p:SnowParticle = new SnowParticle();
			p.x = ex;
			p.y = ey;
			p.vx = vx;
			p.vy = vy;
			p.s = s;
			p.c = c;
			this._snow.push(p);
		}
		
		
		public function updata(e:Event):void {
			this._canvas.lock();
			this._canvas.fillRect(this._canvas.rect, 0x0);
			var n:int = this._snow.length;
			var d:Number;
			var gravity:Number = GRAVITY / 1000;
			while (n--) {
				var p:SnowParticle = this._snow[n];
				p.vy += gravity * p.s;
				p.vx *= 0.99;
				p.vy *= 0.99;
				d = 1 - (this._forceMap.getPixel(p.x, p.y) / 0xffffff) * DRAG;
				p.vx *= d;
				p.vy *= d;
				p.x += p.vx;
				p.y += p.vy;
				this._canvas.setPixel(p.x, p.y, p.c);
				if (p.x > this.stage.stageWidth) {
				this._snow.splice(n, 1);	
				}
			}
			this._canvas.unlock();
			this._glow.draw(this._canvas, this._glowMtx);
			
			n = 10;
			while (n--) {
			this.emitParticle(Math.random() * this.stage.stageWidth, 0, Math.random() + 0.5);
			
			}
		}
	}
}
class SnowParticle {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var s:Number;
	public var c:int;
	
	public function SnowParticle() {
	this.x = 0;
	this.y = 0;
	this.vx = 0;
	this.vy = 0;
	this.s = 1;
	this.c = 0xFFFFFF;
	}
}