/**
 * Copyright Exyphrius ( http://wonderfl.net/user/Exyphrius )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r1g9
 */

package 
{

    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.sampler.StackFrame;


    public class Equation_Solver extends MovieClip
    {
        private static var inputText:TextField = new TextField();
        private static var outputText:TextField = new TextField();
        private static var newUserVarText:TextField = new TextField();

        private static var arrowSprite:Sprite = new Sprite();
        private static var newUserVarBtn:Sprite = new Sprite();
        private static var userVarTextCollection:Sprite = new Sprite();
        private static var copyAnsSprite:Sprite = new Sprite();
        
        private static var arrowBoxColors:Array = new Array(0x0000FF,0xFF0000,0x700070);
        private static var arrowColors:Array = new Array(0xFFFF00,0x00B000,0x0000FF);
        private static var delVarColors:Array = new Array(0xDF0000, 0x0000AF)
        private static var letter:Array = new Array()
        private static var userVarTextField:Array = new Array()
        private static var premadeEquations:Array = new Array()
        private static var mathFunction:Array = new Array()
        private static var mathConst:Array = new Array()
        private static var deleteVarArray:Array = new Array()
        
        private static var arrowPathCmd:Vector.<int> = new Vector.<int>();
        private static var arrowPathData:Vector.<Number> = new Vector.<Number>();
        private static var deleteVarPathCmd:Vector.<int> = new Vector.<int>();
        private static var deleteVarPathData:Vector.<Number> = new Vector.<Number>();
        private static var copyAnsPathCmd:Vector.<int> = new Vector.<int>();
        private static var copyAnsPathData:Vector.<Number> = new Vector.<Number>();
        
        private static var inTextFont:TextFormat = new TextFormat();
        private static var userVarFont:TextFormat = new TextFormat();
        private static var outTextFont:TextFormat = new TextFormat();
        
        private static const boxSize:int = 30;
        private static const smallBoxSize:int = 15
        private static const boxCurve:int = 0;
        private static var UVC:int = 0 //user variable counter
        private static var keyWordColor:int = 0xF09040
        private static var userVarColor:int = 0x0090FF
        private static var mathConstColor:int = 0x00B000
        private static var errorColor:int = 0xFF0000
        private static var lightErrorColor:int = 0xFFA0A0
        
        private static var detectedError:String = ""
        
        public static var inDegrees:Boolean = true


        public function Equation_Solver()
        {
            letter = ("abcdefghijklmnopqrstuvwxyz".split(""))
            
            userVarTextField[0] = new Array()//names
            userVarTextField[1] = new Array()//values
            userVarTextField[2] = new Array()//comments
            
            mathConst[0] = new Array("pi", "e")
            mathConst[1] = new Array(Math.PI, Math.E)
            mathFunction = ["abs", "acos", "asin","atan","ceil",
                            "cos","cot","csc","floor","ln",
                            "random","round","sin","sec","sqrt","tan"]
                            
            inTextFont.font = "Calibri";
            inTextFont.size = 12
            userVarFont.font = "Calibri";
            userVarFont.size = 12
            
            drawNewUserVarBtn(0);
            newUserVarBtn.x = 30
            newUserVarBtn.y = 130
            userVarTextCollection.x = 20
            userVarTextCollection.y = 130
            addChild(newUserVarBtn)
            addChild(userVarTextCollection)
            newUserVarBtn.addChild(newUserVarText)
            newUserVarText.type = "dynamic"
            newUserVarText.defaultTextFormat = userVarFont
            newUserVarText.textColor = 0xFFFFFF
            newUserVarText.selectable = false
            newUserVarText.text = "Add new variable"
            newUserVarText.wordWrap = false
            newUserVarText.multiline = false
            newUserVarText.border = false
            //newUserVarText.width = 98
//            newUserVarText.height = 20
            newUserVarText.autoSize = "left"
            newUserVarText.x = (newUserVarBtn.width/2)-(newUserVarText.width/2)
            newUserVarText.y = (newUserVarBtn.height/2)-(newUserVarText.height/2)
            addChild(inputText);
            //inTextFont.color = Math.random() * Math.pow(2,32);
            inputText.defaultTextFormat = inTextFont;
            inputText.text = "Type your equation here.";
            inputText.x = 20;
            inputText.y = 20;
            inputText.width = 100;
            inputText.height = 100;
            inputText.type = "input";
            inputText.border = true;
            inputText.multiline = false;
            inputText.wordWrap = true;
            inputText.restrict = ".1234567890()+/*@abcdefghijklmnopqrstuvwxyz\\-\\^";
            inputText.defaultTextFormat = inTextFont;
            //inputText.maxChars = 20;
            addChild(outputText);
            outputText.text = "Answer";
            outTextFont.font = "Calibri";
            sizeOutputText();
            outputText.type = "dynamic";
            outputText.border = false;
            outputText.multiline = false;
            outputText.wordWrap = false;
            outputText.selectable = true;
            outputText.antiAliasType = "normal";
            makeArrowPath();
            drawArrowSprite(1);
            addChild(arrowSprite);
            arrowSprite.x = (280/2)-(arrowSprite.width/2);
            arrowSprite.y = (140/2)-(arrowSprite.height/2);
            inputText.addEventListener(FocusEvent.FOCUS_IN, clearText);
            arrowSprite.addEventListener(MouseEvent.CLICK, arrowDown);
            inputText.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            newUserVarBtn.addEventListener(MouseEvent.CLICK, newUserVarBtnDownHandler)
        }
        private function arrowDown(event:MouseEvent):void
        {
            updateText();
        }
        private function keyDownHandler(key:KeyboardEvent):void
        {
            //inTextFont.color = Math.random() * Math.pow(2,24);
            inputText.defaultTextFormat = inTextFont;
            //var bee:int = Number(inTextFont.color);
            //var tempRed:Number = (bee-((bee)%65536))/65536;
            //var tempGreen:Number = (bee-(bee%256)- (tempRed*65536))/256;
            //var tempBlue:int = 0;
            //trace(inTextFont.color.toString(16), tempRed, tempGreen)
            if (key.keyCode == 13)
            {
                updateText();
            }
        }
        private function makeArrowPath():void
        {
            var snap:Number = boxSize / 20;
            arrowPathCmd.push(1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2);
            arrowPathData.push(10*snap, 2*snap,//start 
              17*snap,  9*snap,   //upper pit
               1*snap,  9*snap, //back
               1*snap, 11*snap, //back
              17*snap, 11*snap,   //lower pit
              10*snap, 18*snap, //bottom
              11*snap, 19*snap, //bottom
              19*snap, 11*snap, //front
              19*snap,  9*snap, //front
              11*snap,  1*snap, //top
              10*snap,  2*snap) //top
              snap = smallBoxSize/20
              deleteVarPathCmd.push(1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2)
              deleteVarPathData.push( 2*snap,  1*snap,
                                      1*snap,  2*snap,
                                      9*snap, 10*snap,
                                      1*snap, 18*snap,
                                      2*snap, 19*snap,
                                     10*snap, 11*snap,
                                     18*snap, 19*snap,
                                     19*snap, 18*snap,
                                     11*snap, 10*snap,
                                     19*snap,  2*snap,
                                     18*snap,  1*snap,
                                     10*snap,  9*snap,
                                      2*snap,  1*snap)
                                     
        }
        private function clearText(event:FocusEvent):void
        {
            if (inputText.text == "Type your equation here.")
            {
                inputText.text = "";
                inputText.removeEventListener(FocusEvent.FOCUS_IN, clearText);
                drawArrowSprite(0);
                outputText.text = "";
                sizeOutputText();
            }
        }
        private function newUserVarBtnDownHandler(evt:MouseEvent):void
        {
            addNewUserVar()
        }
        private function addNewUserVar():void
        {            
            for (var v:int = 0; v<3; v++)
            {
                userVarTextField[v][UVC] = new TextField();
                userVarTextCollection.addChild(userVarTextField[v][UVC])
                userVarTextField[v][UVC].y = UVC*25
                userVarTextField[v][UVC].border = true
                userVarTextField[v][UVC].multiline = false
                userVarTextField[v][UVC].wordWrap = false
                userVarTextField[v][UVC].background = true
                userVarTextField[v][UVC].height = 20
                userVarTextField[v][UVC].type = "input"    
                userVarTextField[v][UVC].defaultTextFormat = userVarFont
                userVarTextField[v][UVC].addEventListener(FocusEvent.FOCUS_IN, quickTextClear);
            }
            for (var w:int = 0; w<2; w++)
            {                
                userVarTextField[w][UVC].backgroundColor = lightErrorColor
                userVarTextField[w][UVC].width = 60
                userVarTextField[w][UVC].addEventListener(KeyboardEvent.KEY_UP, userVarEmptyChecker);
                userVarTextField[w][UVC].addEventListener(KeyboardEvent.KEY_DOWN, userVarEmptyChecker);
            }            
            deleteVarArray[UVC] = new Sprite()
            deleteVarArray[UVC].name = UVC
            deleteVarArray[UVC].addEventListener(MouseEvent.MOUSE_OVER, delVarMouseOverHandler)
            deleteVarArray[UVC].addEventListener(MouseEvent.MOUSE_OUT, delVarMouseOutHandler)
            deleteVarArray[UVC].addEventListener(MouseEvent.CLICK, delVarClickHandler)
            drawDeleteVarSprite(deleteVarArray[UVC], 0)
            addChild(deleteVarArray[UVC])
            //deleteVarArray[UVC].graphics.copyFrom(deleteVarSprite)
            deleteVarArray[UVC].x = 10 - (smallBoxSize/2)
            deleteVarArray[UVC].y = (UVC*25 + 140) - (smallBoxSize/2)
            userVarTextField[0][UVC].restrict = "abcdefghijklmnopqrstuvwxyz"
            userVarTextField[1][UVC].restrict = ".0123456789"
            userVarTextField[0][UVC].text = "Name"
            userVarTextField[1][UVC].text = "Value"
            userVarTextField[2][UVC].text = "Comment"
            userVarTextField[2][UVC].backgroundColor = 0xE0E0FF
            userVarTextField[2][UVC].width = 120
            userVarTextField[0][UVC].x = 0
            userVarTextField[1][UVC].x = userVarTextField[0][UVC].width + 5
            userVarTextField[2][UVC].x = userVarTextField[1][UVC].width + 5 + userVarTextField[1][UVC].x
            UVC++
            newUserVarBtn.y = 130 + 25*UVC
        }
        private function delVarMouseOverHandler(event:MouseEvent):void
        {
            drawDeleteVarSprite(Sprite(event.currentTarget), 1)
        }
        private function delVarMouseOutHandler(event:MouseEvent):void
        {
            drawDeleteVarSprite(Sprite(event.currentTarget), 0)
        }
        private function delVarClickHandler(event:MouseEvent):void
        {
            trace(userVarTextField[0])
            removeChild(deleteVarArray[event.currentTarget.name])
            deleteVarArray.splice(event.currentTarget.name, 1)
            for (var aa:int = 0; aa<3; aa++)
            {
                userVarTextCollection.removeChild(userVarTextField[aa][event.currentTarget.name])    
                userVarTextField[aa].splice(event.currentTarget.name, 1)        
                for (var ac:int = event.currentTarget.name; ac<deleteVarArray.length; ac++)
                {
                    userVarTextField[aa][ac].y = 25*ac
                }    
            }
            for (var ab:int = event.currentTarget.name; ab<deleteVarArray.length; ab++)
            {
                trace(deleteVarArray[ab].name, ab)
                deleteVarArray[ab].name = ab
                deleteVarArray[ab].y = 25*ab + 130
                trace(deleteVarArray[ab].name, ab)
            }
                    newUserVarBtn.y = (deleteVarArray.length)*25 + 130
            trace(userVarTextField[0])
            trace("Clicked")
            UVC--
        }
        private function userVarEmptyChecker(event:KeyboardEvent):void
        {
            trace(event.currentTarget.text)
            if (event.currentTarget.text != "" && event.currentTarget.text != ".")
            {
                event.currentTarget.background = false
            }
            else
            {
                event.currentTarget.background = true
            }
        }
        private function quickTextClear(event:FocusEvent):void
        {
            event.currentTarget.text = ""
            event.currentTarget.removeEventListener(FocusEvent.FOCUS_IN, quickTextClear);
        }
        private function drawNewUserVarBtn(colorMode:int):void
        {
            newUserVarBtn.graphics.clear()
            newUserVarBtn.graphics.lineStyle(0, 0x000000);
            newUserVarBtn.graphics.beginFill(arrowBoxColors[colorMode]);
            newUserVarBtn.graphics.drawRect(0,0,104, 20);
            newUserVarBtn.graphics.endFill();
        }
        private function drawDeleteVarSprite(delVarSprite:Sprite, colorMode:int):void
        {
            delVarSprite.graphics.clear()
            delVarSprite.graphics.beginFill(delVarColors[colorMode]);
            delVarSprite.graphics.drawRect(0, 0, smallBoxSize, smallBoxSize)
            delVarSprite.graphics.endFill();
            delVarSprite.graphics.beginFill(0xFFFFFF);
            delVarSprite.graphics.drawPath(deleteVarPathCmd, deleteVarPathData);
            delVarSprite.graphics.endFill();
        }
        private function drawArrowSprite(colorMode:int):void
        {
            if (inputText.text != "Type your equation here.")
            {
                arrowSprite.graphics.clear();
                arrowSprite.graphics.lineStyle(0, 0x000000);
                arrowSprite.graphics.beginFill(arrowBoxColors[colorMode]);
                arrowSprite.graphics.drawRoundRect(0, 0, boxSize, boxSize, boxCurve, boxCurve);
                arrowSprite.graphics.endFill();
                arrowSprite.graphics.beginFill(arrowColors[colorMode]);
                arrowSprite.graphics.drawPath(arrowPathCmd, arrowPathData);
                arrowSprite.graphics.endFill();
            }
            else
            {
                arrowSprite.graphics.clear();
                arrowSprite.graphics.lineStyle(0, 0x000000);
                arrowSprite.graphics.beginFill(arrowBoxColors[colorMode]);
                arrowSprite.graphics.drawRoundRect(0, 0, boxSize, boxSize, boxCurve, boxCurve);
                arrowSprite.graphics.endFill();
            }
        }
        private function updateText():void
        {
            if (inputText.text != "Type your equation here." && inputText.text != "")
            {
                //trace("------------New start----------------");
                inputText.text = omitEquationSpaces(inputText.text);
                outputText.text = solveEquation(inputText.text);
                if (outputText.text == "Infinity")
                {
                    outputText.text = "Number too high"
                }
                else if (outputText.text == "SUPERBREAK")
                {
                    outputText.text = detectedError
                }
                //trace("---------------End-------------------");
                sizeOutputText();
                
            }
            else
            {
                stage.focus = inputText;
            }
        }
        private function sizeOutputText():void
        {
            var fontSize:int = 150;
            var pointA:int = fontSize;
            var pointB:int = 0;
            var midPoint:int = (pointA + pointB) / 2;
            var perfectFit:Boolean = false;
            outputText.wordWrap = false;
            outputText.multiline = false;
            outputText.autoSize = "center";
            if (outputText.text != "")
            {
                while (perfectFit == false)
                {

                    midPoint = (pointA + pointB) / 2;
                    fontSize = midPoint;
                    outTextFont.size = fontSize;
                    outputText.defaultTextFormat = outTextFont;
                    outputText.text = outputText.text
                    ;
                    if (outputText.height > 100 || outputText.width > 100)
                    {
                        //trace("Tried font size " + fontSize+ "Too large: Width/Height: ",outputText.width, "/", outputText.height, "A, mid, B", pointA, midPoint, pointB)
                        pointA = midPoint;
                    }
                    else
                    {

                        //trace("Tried font size " + fontSize+ "Too small: Width/Height: ",outputText.width, "/", outputText.height, "A, mid, B", pointA, midPoint, pointB)
                        pointB = midPoint;
                    }
                    if (pointA - pointB <=1)
                    {
                        //trace("Perfect fit found. PointA/PointB/PointA-PointB", pointA, "/", pointB, "/", pointA-pointB)
                        midPoint = pointB;
                        perfectFit = true;
                        outTextFont.size = midPoint;
                        outputText.defaultTextFormat = outTextFont;
                        outputText.text = outputText.text
                        //trace("Midpoint: " + midPoint, outTextFont.size)
                    }
                }
            }

            outputText.border = false;
            outputText.wordWrap = false;
            outputText.multiline = false;
            outputText.x = 210-(outputText.width)/2;
            outputText.y = 70-(outputText.height)/2;
            //trace(outputText.x, arrowSprite.x + arrowSprite.width, outputText.width, outputText.height)
            //trace(outputText.x, outputText.y)
        }
        public function solveEquation(equation:String):String
        {
            return resolveParentheeses(equation);
        }
        public function omitEquationSpaces(inputString:String):String
        {
            return inputString = inputString.split(" ").join("")
        }
        private function resolveParentheeses(remainingEquation:String, level:int = 0, charOffset:int = 0):String
        {
            var equationArray:Array = new Array();
            var char:Array = new Array();
            var numString:String = "";
            var hadParentheeses:Boolean = false;
            var superBreak:Boolean = false;
            var simplified:String = "";
            ;
            char = remainingEquation.split("");
            //trace("Resolve Parentheeses called: Starting loop: Standby for result!");
            mainLoop:for (var a:int = 0; a < char.length; a++)
            {
                if (superBreak == true || remainingEquation == "SUPERBREAK")
                {
                    //trace("BREAKING DUE TO SUPERBREAK")
                    break mainLoop;
                }
                trace("   Trying character \"" + char[a]+ "\"","a = " + a, "\". Level is " + level, "equationArray: " , equationArray);
                //trace("Equation Array (level "+level+"): " + equationArray)
                if (char[a] == ")")
                {
                    if (numString != "")
                    {
                        equationArray.push(Number(numString));
                        numString = "";
                        //trace("Number resolved. Number was found to be: "+String(equationArray[equationArray.length-1]));
                    }
                    if (level <= 0)
                    {
                        //trace("BREAK------ Improper parethentical expression found.");
                        simplified = "SUPERBREAK";
                        superBreak = true;
                        break mainLoop;
                    }
                    else
                    {
                        equationArray.push(resolveOperations(equationArray));
                        //trace("     Added \"" +equationArray[equationArray.length-1]+"\" to the equation array.";//trace("Equation Array: " + equationArray)
                        //trace("DESCENDING------ Fitting RightPar found. Descending stack layer. Level = " + level, "Simplified = " + simplified);
                        level--;
                    }
                }
                else if (char[a] == "(")
                {
                    hadParentheeses = true;
                    if (numString != "")
                    {
                        equationArray.push(Number(numString));
                        numString = "";
                        //trace("Number resolved. Number was found to be: "+String(equationArray[equationArray.length-1]));
                    }
                    level++;
                    var tempString:String = "";
                    var tempLevel:int = 1;
                    stringLoop:for (var b:int = a+1; b < char.length; b++)
                    {
                        if (char[b] == "(")
                        {
                            tempLevel++;
                        };
                        if(char[b] == ")")
                        {
                            if (b == a+1)
                            {
                                trace("Found stupid par lolol")
                                break stringLoop;
                            }
                            tempLevel--;
                            if (tempLevel == 0)
                            {
                                
                                trace("Going up a new layer. TempString = \"" + tempString +"\" " +"Level = " + level, "Equation Array: " + equationArray, "a = ", a, "charOffset = ", charOffset)
                                var resolvedString:String = resolveParentheeses(tempString, level, charOffset+a+1)
                                level--
                                trace("char: " + char, "ResolvedString: ",resolvedString)
                                trace("Going down a level: "+level)
                                a = b
                                equationArray.push(Number(resolvedString));//trace("  Char arr is now: " + char)
                                break stringLoop;
                            }
                        }
                        tempString = tempString+char[b]
                        if (b == char.length-1)
                        {
                            trace("Equation did not have enough right Par.")
                            remainingEquation = "SUPERBREAK";
                            detectedError = "The number of parentheeses did not match"
                        }
                    //trace("Added \"" + char[b] + "\" to tempString")
                    }
                }
//trace("------------------------BLEH BLEH BLEH" + ", tempString:" + tempString + ", Level: " + level + ", ResolvePar: " +resolveParentheeses(tempString, level), "Equation Array: " + equationArray)
                else if (char[a] == "+" || char[a] == "-" || char[a] == "*" || char[a] == "/" || char[a] == "^")
                {
                    if (numString != "")
                    {
                        equationArray.push(Number(numString));
                        //trace("Number resolved. Number was found to be: "+ numString);
                        numString = "";
                    }
                    equationArray.push(char[a]);
                    //trace("Added \"" +char[a]+"\" to the equation array.");
                }
                else if (char[a] == "@")
                {
                    if (outputText.text != "Answer" && outputText.text != "" && outputText.text != "undefined" && outputText.text !=  "Number too high" && outputText.text != "NaN" && outputText.text != "Invalid last answer")
                    {
                        if (numString != "")
                        {
                            equationArray.push(Number(numString));
                            numString = "";
                            //trace("Number resolved. Number was found to be: "+String(equationArray[equationArray.length-1]));
                        }    
                        equationArray.push(Number(outputText.text));
                        //trace("Added last answer to equation array: " + outputText.text);
                    }
                    else
                    {
                        remainingEquation = "SUPERBREAK";
                        detectedError = "Invalid last answer"
                    }
                }
                else
                {
                    //trace("blahhhh")
                    if (char[a] == ".")
                    {
                        //trace("Adding number character: "+char[a]);
                        numString = numString + char[a];
                        continue mainLoop;
                    }
                    else
                    {
                        for (var c:int = 0; c<10; c++)
                        {
                            if (char[a] == String(c))
                            {
                                //trace("Adding Number character: "+char[a]);
                                numString = numString + char[a];
                                continue mainLoop;
                            }
                        }
                        var word:Array = new Array()
                        findLetter: for (var o:int = 0; o<letter.length;o++)
                        {
                            if (char[a] == letter[o])
                            {
                                trace("FOUND A FRIGGIN LETTER! "+char[a])
                                if (numString != "")
                                {
                                    equationArray.push(Number(numString));
                                    numString = "";
                                    //trace("Number resolved. Number was found to be: "+String(equationArray[equationArray.length-1]));
                                }
                                word.push(char[a])
                                var levelLoop:int = 0
//                                trace(levelLoop)
//                                for (levelLoop = 0; levelLoop<2; levelLoop++)
//                                {
//                                    trace(levelLoop)
//                                    trace("ALL HAIL LEVELLOOP")
//                                }
//                                trace(levelLoop)
                                searchRest: for (var p:int = a+1; p<char.length; p++)
                                {
                                    //trace("Trying additional character \""+char[p]+"\" ")
                                    var isLetter:Boolean = false
                                    findMoreLetters: for (var q:int = 0; q<letter.length;q++)
                                    {
                                        if (char[p] == letter[q])
                                        {
                                            
                                            isLetter = true
                                            word.push(char[p])
                                            trace("Found additional letter \"" + letter[q]+ "\": Word: " + word)
                                            break findMoreLetters;
                                        }
                                    }
                                    if (isLetter == false)
                                    {        
                                        break searchRest;                                        
                                    }
                                    if  (p == char.length-1)
                                    {
                                        p++
                                        break searchRest;
                                    }
                                }                                
                                trace("p:"+p)
                                trace("middle: a/p: ",a,p)
                                inTextFont.color = 0xFF0000
                                var wordString:String = word.join("")
                                var keywordFound:Boolean = false
                                //trace("Wordstring: " + wordString)
                                if (keywordFound == false)
                                {
                                    functionSearch: for (var r:int = 0; r<mathFunction.length;r++)
                                    {
                                        if (wordString == mathFunction[r])
                                        {
                                            trace("changing to keyword color")
                                            inTextFont.color = keyWordColor
                                            keywordFound = true
                                            var funcParLevel:int = 1
                                            if (char[p] == "(")
                                            {
                                                tempString = ""
                                                funcVal: for (var u:int = p+1; u<char.length; u++)
                                                {
                                                    trace(char[u])
                                                    //stuff start
                                                    if (char[u] == "(")
                                                    {
                                                        funcParLevel++;
                                                    };
                                                    if(char[u] == ")")
                                                    {
                                                        if (u == p+1)
                                                        {
                                                            trace("Found stupid par lolol")
                                                            break funcVal;
                                                        }
                                                        funcParLevel--;
                                                        if (funcParLevel == 0)
                                                        {                
                                                            trace("Math Function: Going up a new layer. Tempstring: " , tempString, "funcParLevel = \"" + funcParLevel +"\" " +"Level = " + level, "Equation Array: " + equationArray, "p = ", p, "charOffset = ", charOffset)
                                                            var resolvedString2:String = resolveParentheeses(tempString, 100, charOffset+u)
                                                            trace("char: " + char, "eqA", equationArray)
                                                            trace("Math Function: Going down a level: "+level)
                                                            equationArray.push(resolveMathFunc(r, Number(resolvedString2)));//trace("  Char arr is now: " + char)
                                                            inputText.setTextFormat(inTextFont, charOffset+a, charOffset+p)
                                                            p = u
                                                            trace("   Made p === u: ", p, u)
                                                            break funcVal;                    
                                                        }
                                                    }
                                                    tempString = tempString+char[u]
                                                    if (u == char.length-1)
                                                    {
                                                        trace("Equation did not have enough right Par.")
                                                        remainingEquation = "SUPERBREAK";
                                                        detectedError = "Parentheeses did not match"
                                                    }
                                                //trace("Added \"" + char[b] + "\" to tempString")
                                                }
                                            }
                                            else 
                                            {
                                                //superbreak
                                            }
                                            break functionSearch;
                                                //stuff end
                                        }
                                    }
                                }
                                if (keywordFound == false)
                                {
                                    for (var t:int = 0; t<mathConst[0].length; t++)
                                    {                                        
                                        if (wordString == mathConst[0][t])
                                        {                                            
                                            //trace("changing to mathConst color")
                                            equationArray.push(mathConst[1][t])
                                            trace(equationArray)
                                            inTextFont.color = mathConstColor
                                            inputText.setTextFormat(inTextFont, charOffset+a, charOffset+p)
                                            keywordFound = true
                                            p--
                                        }
                                    }
                                }
                                if (keywordFound == false)
                                {
                                    for (var s:int = 0; s<userVarTextField[0].length; s++)
                                    {                                        
                                        if (wordString == userVarTextField[0][s].text)
                                        {
                                            keywordFound = true
                                            if (userVarTextField[1][s].text != "." && userVarTextField[1][s].text != "" && userVarTextField[1][s].text != "Value")
                                            {
                                                trace("changing to userVar color")
                                                equationArray.push(Number(userVarTextField[1][s].text))
                                                inTextFont.color = userVarColor
                                                inputText.setTextFormat(inTextFont, charOffset+a, charOffset+p)
                                                p--
                                            }
                                            else
                                            {
                                                remainingEquation = "SUPERBREAK";
                                                detectedError = "Variable empty"                                                
                                                userVarTextField[1][s].backgroundColor = errorColor
                                                inTextFont.color = errorColor
                                                inputText.setTextFormat(inTextFont, charOffset+a, charOffset+p)
                                                
                                            }
                                        }
                                    }
                                }
                                if (keywordFound == false)
                                {
                                    remainingEquation = "SUPERBREAK";
                                    detectedError = "Unknown word"
                                    inTextFont.color = errorColor
                                    inputText.setTextFormat(inTextFont, charOffset+a, charOffset+p)
                                }
                                inTextFont.color = 0x000000
                                a = p                
                                trace("MADE A = P!!!!: ", a, p)
                                break findLetter;
                                }
                            }
                        }
                    }
                }
        
                if (numString != "")
                {
                    equationArray.push(Number(numString));
                    numString = "";
                    //trace("Number resolved. Number was found to be: "+String(equationArray[equationArray.length-1]));
                }
                if (remainingEquation != "SUPERBREAK")
                {
                    simplified = resolveOperations(equationArray);
                }
                else
                {
                    simplified = detectedError
                }
                //trace("End of loop. Level: " +level);
                return simplified;
            }
            public function resolveCoterminal(angle:Number):Number
            {
                while (angle >= 360)
                {
                    //trace("Lowering angle: ", angle)
                    angle -=360
                }
                while (angle < 0)
                {
                    //trace("highering angle: ", angle)
                    angle +=360
                }
                return angle;
            }
            private function resolveMathFunc(funcID:int, val:Number):Number
            {
                if (funcID == 0)
                {
                    return Math.abs(val)
                }
                else if (funcID == 1)
                {
                    return Math.acos(val)
                }
                else if (funcID == 2)
                {
                    return Math.asin(val)
                }
                else if (funcID == 3)
                {
                    return Math.atan(val)
                }
                else if (funcID == 4)
                {
                    return Math.ceil(val)
                }
                else if (funcID == 5)
                {
                    trace("Finding cos")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 90 || val == 270)
                        {
                            return 0;
                        }
                        else 
                        {
                            val = (val/180)*Math.PI
                            return Math.cos(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 90 || val == 270)
                        {
                            return 0;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return Math.cos(val)
                        }
                    }
                }
                else if (funcID == 6) //cot
                {
                    //trace("Finding cot")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 0 ||val == 180)
                        {
                            return 1/0;
                        }
                        else if (val == 90 ||val == 270)
                        {
                            return 0;
                        }
                        else
                        {    
                            val = (val/180)*Math.PI
                            return 1/Math.tan(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 0 ||val == 180)
                        {
                            return 1/0;
                        }
                        else if (val == 90 ||val == 270)
                        {
                            return 0;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return 1/Math.tan(val)
                        }
                    }
                }
                else if (funcID == 7) //csc
                {
                    //trace("Finding csc")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 0 || val == 180)
                        {
                            return 1/0;
                        }
                        else 
                        {
                            val = (val/180)*Math.PI
                            return 1/Math.sin(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 0 || val == 180)
                        {
                            return 1/0;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return 1/Math.sin(val)
                        }
                    }
                }
                else if (funcID == 8)
                {
                    return Math.floor(val)
                }
                else if (funcID == 9)
                {
                    return Math.log(val)
                }
                else if (funcID == 10)
                {
                    return Math.random()
                }
                else if (funcID == 11)
                {
                    return Math.round(val)
                }
                else if (funcID == 12)//sin
                {
                    //trace("Finding sin")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 0 || val == 180)
                        {
                            return 0;
                        }
                        else 
                        {
                            val = (val/180)*Math.PI
                            return Math.sin(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 0 || val == 180)
                        {
                            return 0;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return Math.sin(val)
                        }
                    }
                }
                else if (funcID == 13) //sec
                {
                    trace("Finding cos")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 90 || val == 270)
                        {
                            return 1/0;
                        }
                        else 
                        {
                            val = (val/180)*Math.PI
                            return 1/Math.cos(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 90 || val == 270)
                        {
                            return 1/0;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return 1/Math.cos(val)
                        }
                    }
                }
                else if (funcID == 14)
                {
                    return Math.sqrt(val)
                }
                else if (funcID == 15) //tan
                {
                    //trace("Finding tan")
                    if(inDegrees)
                    {                        
                        val = resolveCoterminal(val)
                        //trace(" VAL", val)
                        if (val == 0 ||val == 180)
                        {
                            return 0;
                        }
                        else if (val == 90 ||val == 270)
                        {
                            return 1/0;
                        }
                        else if (val == 45 || val == 135 || val == 225 || val == 315)
                        {
                            return 1;
                        }
                        else
                        {    
                            val = (val/180)*Math.PI
                            return Math.tan(val)
                        }
                    }
                    else
                    {
                        val = (val/Math.PI)*180
                        val = resolveCoterminal(val)
                        if (val == 0 ||val == 180)
                        {
                            return 0;
                        }
                        else if (val == 90 ||val == 270)
                        {
                            return 1/0;
                        }
                        else if (val == 45 || val == 135 || val == 225 || val == 315)
                        {
                            return 1;
                        }
                        else
                        {        
                            val = (val/180)*Math.PI                    
                            return Math.tan(val)
                        }
                    }
                }
                else
                {
                    return 0/0
                }
            }
            private function resolveOperations(equationArray:Array):String
            {
                trace("     %Resolve operations called. Equation array:" + equationArray)
                var simplified:String = "";
                var numArray:Array = new Array();
                var operationArray:Array = new Array();
                var numShift:Array = new Array();
                var breakout:int = 0;
                var numNumbers:int = 0;
                var indexLoc:int = 0;
                for (var g:int = 0; g < 4; g++)
                {
                    operationArray[g] = new Array();
                    for (var h:int = 0; h < 2; h++)
                    {
                        operationArray[g][h] = new Array  ;
                    }
                }//0 = special, 1 = ^, 2 = */, 3 = +- [0] = index, [1] = operation
                for (var d:int = 0; d<equationArray.length; d++)
                {
                    //breakout++;
                    if (breakout >= 9)
                    {
                        break;
                        //trace("BREAKOUT CALLLLLLED")
                    }
                    if (equationArray[d] is Number)
                    {
                        //trace("added number to numArray" , equationArray[d])
                        numArray.push(equationArray[d]);
                        if (equationArray[d + 1] is Number)
                        {
                            equationArray.splice(d+1, 0, "*");
                        }
                        //trace("Added multiplication due to two numbers being next to each other", equationArray);
                    }
                    else
                    {
                        if (equationArray[d] == "^")
                        {
                            //trace("added operation to opArray" , equationArray[d])
                            operationArray[1][0].push(numArray.length-1);
                            operationArray[1][1].push(equationArray[d]);
                        }
                        else if (equationArray[d] == "*" || equationArray[d] == "/")
                        {
                            //trace("added operation to opArray" , equationArray[d])
                            operationArray[2][0].push(numArray.length-1);
                            operationArray[2][1].push(equationArray[d]);
                        }
                        else if (equationArray[d] == "+" || equationArray[d] == "-")
                        {
                            //trace("added operation to opArray" , equationArray[d])
                            operationArray[3][0].push(numArray.length-1);
                            operationArray[3][1].push(equationArray[d]);
                        }
                    }
                }
                numNumbers = numArray.length;
                for (var p:int = 0; p < numNumbers; p++)
                {
                    numShift[p] = 0;
                }
                //trace("     Power array: " + operationArray[1], "Multiplicaiton Array: " + operationArray[2], "Addition Array: " + operationArray[3], "number array " + numArray)
                while (operationArray[1][0].length > 0)
                {
                    //trace("Breakout Count: ", breakout)
                    //breakout++;
                    if (breakout > 9)
                    {
                        //trace("breakout called")
                        break;
                    }
                    indexLoc = operationArray[1][0][0];
                    if (operationArray[1][1][0] == "^")
                    {
                        //trace("Empowering", numArray[indexLoc-numShift[indexLoc]+1], numArray[indexLoc-numShift[indexLoc]], indexLoc, numShift[indexLoc])
                        numArray.splice(indexLoc-numShift[indexLoc], 2, Math.pow(numArray[indexLoc-numShift[indexLoc]] , numArray[indexLoc-numShift[indexLoc]+1]));
                        operationArray[1][0].shift();
                        operationArray[1][1].shift();
                        for (var j:int = indexLoc; j < numNumbers; j++)
                        {
                            numShift[j]++;
                        }
                        //trace("Num array", numArray, "numShift:", numShift)
                    }
                    else
                    {
                        //trace(" ^ Something messed up. Something landed in the Operations array that wasn't supposed to.")
                    }
                }
                
                
                while (operationArray[2][0].length > 0)
                {
                    //trace("Breakout Count: ", breakout)
                    //breakout++;
                    if (breakout > 9)
                    {
                        //trace("breakout called")
                        break;
                    }
                    indexLoc = operationArray[2][0][0];
                    if (operationArray[2][1][0] == "*")
                    {
                        trace(numArray)
                        trace("Multiplying", numArray[indexLoc-numShift[indexLoc]+1], numArray[indexLoc-numShift[indexLoc]], indexLoc, numShift[indexLoc])
                        numArray.splice(indexLoc-numShift[indexLoc], 2, numArray[indexLoc-numShift[indexLoc]] * numArray[indexLoc-numShift[indexLoc]+1]);
                        trace(numArray)
                        operationArray[2][0].shift();
                        operationArray[2][1].shift();
                        for (var k:int = indexLoc; k < numNumbers; k++)
                        {
                            numShift[k]++;
                        }
                        //trace("Num array", numArray, "numShift:", numShift)
                    }
                    else if (operationArray[2][1][0] == "/")
                    {
                        //trace("Dividing", numArray[indexLoc-numShift[indexLoc]+1], numArray[indexLoc-numShift[indexLoc]], indexLoc, numShift[indexLoc])
                        numArray.splice(indexLoc-numShift[indexLoc], 2, numArray[indexLoc-numShift[indexLoc]] / numArray[indexLoc-numShift[indexLoc]+1]);
                        operationArray[2][0].shift();
                        operationArray[2][1].shift();
                        for (var l:int = indexLoc; l < numNumbers; l++)
                        {
                            numShift[l]++;
                        }
                        //trace("Num array", numArray, "numShift:", numShift)
                    }
                    else
                    {
                        //trace("*/ Something messed up. Something landed in the Operations array that wasn't supposed to.")
                    }
                }        
                while (operationArray[3][0].length > 0)
                {
                    //breakout++;
                    //trace("Breakout Count: ", breakout)
                    if (breakout > 9)
                    {
                        trace("breakout called")
                        break;
                    }
                    trace(operationArray[3][1][0] == "+", operationArray[3][1][0])
                indexLoc = operationArray[3][0][0];
                if (operationArray[3][1][0] == "+")
                {
                    trace("adding operations", operationArray[3][0])
                    trace("Adding", numArray[indexLoc-numShift[indexLoc]+1], numArray[indexLoc-numShift[indexLoc]], indexLoc, numShift[indexLoc])
                    numArray.splice(indexLoc-numShift[indexLoc], 2, numArray[indexLoc-numShift[indexLoc]] + numArray[indexLoc-numShift[indexLoc]+1]);
                    operationArray[3][0].shift();
                    operationArray[3][1].shift();
                    trace("adding operations", operationArray[3][0].length)
                    for (var m:int = indexLoc; m < numNumbers; m++)
                    {
                        numShift[m]++;
                    }
                    trace("Num array", numArray, "numShift:", numShift)
                    trace("logic: ",operationArray[3][0].length > 0)
                }
                else if (operationArray[3][1][0] == "-")
                {
                    trace("subtracting operations", operationArray[3][0])
                    //trace("Subtracting", numArray[indexLoc-numShift[indexLoc]+1], numArray[indexLoc-numShift[indexLoc]], indexLoc, numShift[indexLoc])
                    numArray.splice(indexLoc-numShift[indexLoc], 2, numArray[indexLoc-numShift[indexLoc]] - numArray[indexLoc-numShift[indexLoc]+1]);
                    operationArray[3][0].shift();
                    operationArray[3][1].shift();
                    for (var n:int = indexLoc; n < numNumbers; n++)
                    {
                        numShift[n]++;
                    }
                    //trace("Num array", numArray, "numShift:", numShift)
                }
                else
                {
                    //trace("+- Something messed up. Something landed in the Operations array that wasn't supposed to.")
                }
            }
            simplified = String(numArray[0]);
            trace("     %Equation resolved to: " +simplified)
            trace(operationArray[3][1],operationArray[3][1].length)
            return simplified;
        }
    }
}