/**
 * Copyright russ ( http://wonderfl.net/user/russ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0wQ
 */

package {
import flash.display.Sprite;
import flash.events.MouseEvent;

public class SpriteMouseOver extends Sprite {
    public function SpriteMouseOver():void {
        var placementMode:uint = 1; // 0 == sprite at origin and drawing far out; 1 == draw at origin and place far out.
        var RAND_MAX:uint = 200;

        for (var i:uint = 0; i < 10; i++) {
            var s:Sprite = new Sprite();
            s.name = "s" + (i + 1);
            s.graphics.lineStyle(1, 0);
            s.graphics.beginFill(0xFF0000);
            if (placementMode == 0) {
                s.graphics.drawRect(Math.random() * RAND_MAX, Math.random() * RAND_MAX, 10, 10);
            }
            else {
                s.graphics.drawRect(0, 0, 10, 10);
                s.x = Math.random() * RAND_MAX;
                s.y = Math.random() * RAND_MAX;
            }
            stage.addChild(s);
            s.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover);
            s.addEventListener(MouseEvent.ROLL_OUT, onMouseRollout);
            trace("Added " + s.name + " at x=" + s.x + ", y=" + s.y + " -- width = " + s.width);
        }
    }

    private function onMouseRollout(e:MouseEvent):void {
        e.target.alpha = 1;
    }

    private function onMouseRollover(e:MouseEvent):void {
        trace("Rolled over target: " + e.target.name + " (currentTarget = " + e.currentTarget.name + ")");
        e.target.alpha = 0.5;
    }
}
}
