/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0wK
 */

package
{
	import com.bit101.components.PushButton;
	import com.bit101.components.TextArea;
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class Main extends Sprite
	{	
		private var src:TextArea;
		private var dest:TextArea;
		
		public function Main()
		{
			src = new TextArea(this);
			dest = new TextArea(this);
			
			src.width = dest.width = stage.stageWidth;
			src.height = 100;
			
			dest.y = src.height + 100;
			dest.height = stage.stageHeight - dest.y;
			
			new PushButton(this, 0, 120, "Description", onClick);
			onClick();
		}
		
		private function onClick(event:Event = null):void
		{
			dest.text = MD2.digest(src.text);
		}
	}
}

class MD2
{
	public static function digest(str:String):String
	{
		var data:Array = [];
		for (var i:int = 0; i < str.length; i++)
		{
			data[i] = str.charCodeAt(i);
		}
		
		var num:int = 16 - data.length % 16;
		for (i = 0; i < num; i++)
		{
			data[data.length] = num;
		}
		
		var check:Array = new Array(16).map(function(...a):* { return 0; } );
		var l:int = 0;
		for (i = 0; i < data.length / 16; i++)
		{
			for (var j:int = 0; j < 16; j++)
			{
				var c:int = data[i * 16 + j];
				check[j] ^= PI[c ^ l];
				l = check[j];
			}
		}

		data = data.concat(check);
		
		var buffer:Array = new Array(48).map(function(...a):* { return 0; } );
		var n:int = data.length / 16;
		for (i = 0; i < n; i++)
		{
			for (j = 0; j < 16; j++)
			{
				buffer[16 + j] = data[i * 16 + j];
				buffer[32 + j] = buffer[16 + j] ^ buffer[j];
			}
			
			var t:int;
			for (t = j = 0; j < 18; j++)
			{
				for (var k:int = 0; k < 48; k++)
				{
					t = buffer[k] ^= PI[t];
				}
				t = (t + j) % 256;
			}
		}

		return buffer.slice(0, 16).map
		(
			function(e:int, ...a):*
			{
				var zero:String = (e < 0x10) ? "0" : "";
				return zero + e.toString(16);
			}
		).join("");
	}
	
	public static const PI:Array =
	[
		41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6,
		19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188,
		76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24,
		138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251,
		245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63,
		148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50,
		39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165,
		181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210,
		150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157,
		112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27,
		96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15,
		85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197,
		234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65,
		129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123,
		8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233,
		203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228,
		166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237,
		31, 26, 219, 153, 141, 51, 159, 17, 131, 20
	]
}