/**
 * Copyright Naohiko.Ueno ( http://wonderfl.net/user/Naohiko.Ueno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0mM
 */

package
{
//    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.ui.ContextMenu;
    
    import feathers.system.DeviceCapabilities;
    
    import starling.core.Starling;

    [SWF(width="465",height="465",frameRate="60",backgroundColor="#2f2f2f")]
    public class ComponentsExplorerWeb extends flash.display.Sprite
    {
        public function ComponentsExplorerWeb()
        {
            // Wonderflのプレピュー用にキャプチャ撮りたいときだけ第1引数をtrueにする。
            // 第2引数はキャプチャを撮るまでの秒数。
            WonderflCaptureUtil.init(false, 1);
            
            var menu:ContextMenu = new ContextMenu();
            menu.hideBuiltInItems();
            this.contextMenu = menu;
            
            if(this.stage)
            {
                this.stage.align = StageAlign.TOP_LEFT;
                this.stage.scaleMode = StageScaleMode.NO_SCALE;
            }
            
            this.loaderInfo.addEventListener(Event.COMPLETE, loaderInfo_completeHandler);
        }
        
        private var _starling:Starling;
        
        private function start():void
        {
            Starling.handleLostContext = true;
            Starling.multitouchEnabled = false;
            this._starling = new Starling(Main, this.stage);
            this._starling.enableErrorChecking = false;
            //this._starling.showStats = true;
            //this._starling.showStatsAt(HAlign.LEFT, VAlign.BOTTOM);
            this._starling.start();
            
            // Wonderflのプレピュー用キャプチャを撮るときだけStarlingの画面をビットマップ化してstage最前面に追加する。
            if (WonderflCaptureUtil.captureEnabled)
            {
                this._starling.juggler.delayCall(function():void
                {
                    captureStarling(stage);
                }, WonderflCaptureUtil.captureDelay - 0.5);
            }
            
            //pretends to be an iPhone screen
            DeviceCapabilities.dpi = 163;
            DeviceCapabilities.screenPixelWidth = stage.stageWidth;
            DeviceCapabilities.screenPixelHeight = stage.stageHeight;
        }
        
        private function loaderInfo_completeHandler(event:Event):void
        {
            this.start();
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

import starling.core.RenderSupport;
import starling.core.Starling;

function captureStarling(stage:Stage, starlingInstance:Starling=null):void
{
    if (starlingInstance == null)
        starlingInstance = Starling.current;
    
    if (starlingInstance == null)
        throw new IllegalOperationError("Starling instance is missing");
    if (starlingInstance.context == null)
        throw new IllegalOperationError("Contex3D is missing");
        
    var captchaData:BitmapData = new BitmapData(465, 465, false);
    
    var support:RenderSupport = new RenderSupport();
    RenderSupport.clear(starlingInstance.stage.color, 1.0);
    support.setOrthographicProjection(0, 0, captchaData.width, captchaData.height);
    starlingInstance.stage.render(support, 1.0);
    support.finishQuadBatch();
    
    starlingInstance.context.drawToBitmapData(captchaData);
    
    var textField:flash.text.TextField = new flash.text.TextField();
    textField.defaultTextFormat = new TextFormat("Arial", 10, 0xFFFFFF);
    textField.text = "This is captured image for winderfl preview.";
    textField.autoSize = TextFieldAutoSize.CENTER;
    textField.x = 465 - textField.width - 4;
    textField.y = 465 - textField.height - 4;
    var sprite:flash.display.Sprite = new flash.display.Sprite();
    sprite.graphics.beginFill(0x000000, 0.5);
    sprite.graphics.drawRoundRect(textField.x - 2, textField.y - 2, textField.width + 2, textField.height + 2, 6);
    sprite.addChild(textField);
    captchaData.draw(sprite);
    
    var captcha:Bitmap = new Bitmap(captchaData);
    stage.addChild(captcha);
    stage.addEventListener(MouseEvent.CLICK, stage_clickHandler);
    
    function stage_clickHandler(event:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.CLICK, stage_clickHandler);
        stage.removeChild(captcha);
        captchaData.dispose();
    }
}

import flash.errors.IllegalOperationError;
import flash.utils.getDefinitionByName;

class WonderflCaptureUtil
{
    // Wonderfl default setting @see http://wonderfl.net/help#help_capture
    private static var _capture:Boolean = true;
    private static var _captureDelay:Number = 3;
    
    private static var _inited:Boolean = false;
    private static var _wonderflClassChecked:Boolean = false;
    private static var _wonderflClass:Class;
    
    public static function get captureEnabled():Boolean
    {
        return wonderflClass ? _capture : false;
    }
    
    public static function get captureDelay():Number
    {
        return _captureDelay;
    }
    
    public static function get wonderflClass():Class
    {
        if (_wonderflClassChecked)
            return _wonderflClass;
        else
        {
            try
            {
                _wonderflClassChecked = true;
                _wonderflClass = getDefinitionByName("Wonderfl") as Class
                return _wonderflClass;
            }
            catch (e:Error) {}
        }
        
        return null;
    }
    
    public static function init(capture:Boolean=false, captureDelay:Number=3):void
    {
        if (_inited)
            throw new IllegalOperationError("WonderflCaptureUtil is already inited.");
        
        _inited = true;
        _capture = capture;
        _captureDelay = captureDelay;
        
        if (wonderflClass)
        {
            if (capture)
                wonderflClass["capture_delay"](captureDelay);
            else
                wonderflClass["disable_capture"]();
        }
    }
}

import feathers.controls.ScreenNavigator;
import feathers.controls.ScreenNavigatorItem;
import feathers.motion.transitions.ScreenSlidingStackTransitionManager;
import feathers.themes.AzureMobileTheme;

import starling.display.Sprite;
import starling.events.Event;

class Main extends starling.display.Sprite
{
    private static const MAIN_MENU:String = "mainMenu";
    private static const BUTTON:String = "button";
    private static const BUTTON_SETTINGS:String = "buttonSettings";
    private static const BUTTON_GROUP:String = "buttonGroup";
    private static const CALLOUT:String = "callout";
    private static const GROUPED_LIST:String = "groupedList";
    private static const GROUPED_LIST_SETTINGS:String = "groupedListSettings";
    private static const LIST:String = "list";
    private static const LIST_SETTINGS:String = "listSettings";
    private static const PAGE_INDICATOR:String = "pageIndicator";
    private static const PICKER_LIST:String = "pickerList";
    private static const PROGRESS_BAR:String = "progressBar";
    private static const SCROLL_TEXT:String = "scrollText";
    private static const SLIDER:String = "slider";
    private static const SLIDER_SETTINGS:String = "sliderSettings";
    private static const TAB_BAR:String = "tabBar";
    private static const TEXT_INPUT:String = "textInput";
    private static const TOGGLES:String = "toggles";
    
    public function Main()
    {
        super();
        this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }
    
    private var _theme:AzureMobileTheme;
    private var _navigator:ScreenNavigator;
    private var _transitionManager:ScreenSlidingStackTransitionManager;
    
    private function addedToStageHandler(event:Event):void
    {
        this._theme = new AzureMobileTheme(this.stage);
        
        this._navigator = new ScreenNavigator();
        this.addChild(this._navigator);
        
        this._navigator.addScreen(MAIN_MENU, new ScreenNavigatorItem(MainMenuScreen,
            {
                showButton: BUTTON,
                showButtonGroup: BUTTON_GROUP,
                showCallout: CALLOUT,
                showGroupedList: GROUPED_LIST,
                showList: LIST,
                showPageIndicator: PAGE_INDICATOR,
                showPickerList: PICKER_LIST,
                showProgressBar: PROGRESS_BAR,
                showScrollText: SCROLL_TEXT,
                showSlider: SLIDER,
                showTabBar: TAB_BAR,
                showTextInput: TEXT_INPUT,
                showToggles: TOGGLES
            }));
        
        const buttonSettings:ButtonSettings = new ButtonSettings();
        this._navigator.addScreen(BUTTON, new ScreenNavigatorItem(ButtonScreen,
            {
                complete: MAIN_MENU,
                showSettings: BUTTON_SETTINGS
            },
            {
                settings: buttonSettings
            }));
        
        this._navigator.addScreen(BUTTON_SETTINGS, new ScreenNavigatorItem(ButtonSettingsScreen,
            {
                complete: BUTTON
            },
            {
                settings: buttonSettings
            }));
        
        this._navigator.addScreen(BUTTON_GROUP, new ScreenNavigatorItem(ButtonGroupScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(CALLOUT, new ScreenNavigatorItem(CalloutScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(SCROLL_TEXT, new ScreenNavigatorItem(ScrollTextScreen,
            {
                complete: MAIN_MENU
            }));
        
        const sliderSettings:SliderSettings = new SliderSettings();
        this._navigator.addScreen(SLIDER, new ScreenNavigatorItem(SliderScreen,
            {
                complete: MAIN_MENU,
                showSettings: SLIDER_SETTINGS
            },
            {
                settings: sliderSettings
            }));
        
        this._navigator.addScreen(SLIDER_SETTINGS, new ScreenNavigatorItem(SliderSettingsScreen,
            {
                complete: SLIDER
            },
            {
                settings: sliderSettings
            }));
        
        this._navigator.addScreen(TOGGLES, new ScreenNavigatorItem(ToggleScreen,
            {
                complete: MAIN_MENU
            }));
        
        const groupedListSettings:GroupedListSettings = new GroupedListSettings();
        this._navigator.addScreen(GROUPED_LIST, new ScreenNavigatorItem(GroupedListScreen,
            {
                complete: MAIN_MENU,
                showSettings: GROUPED_LIST_SETTINGS
            },
            {
                settings: groupedListSettings
            }));
        
        this._navigator.addScreen(GROUPED_LIST_SETTINGS, new ScreenNavigatorItem(GroupedListSettingsScreen,
            {
                complete: GROUPED_LIST
            },
            {
                settings: groupedListSettings
            }));
        
        const listSettings:ListSettings = new ListSettings();
        this._navigator.addScreen(LIST, new ScreenNavigatorItem(ListScreen,
            {
                complete: MAIN_MENU,
                showSettings: LIST_SETTINGS
            },
            {
                settings: listSettings
            }));
        
        this._navigator.addScreen(LIST_SETTINGS, new ScreenNavigatorItem(ListSettingsScreen,
            {
                complete: LIST
            },
            {
                settings: listSettings
            }));
        
        this._navigator.addScreen(PAGE_INDICATOR, new ScreenNavigatorItem(PageIndicatorScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(PICKER_LIST, new ScreenNavigatorItem(PickerListScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(TAB_BAR, new ScreenNavigatorItem(TabBarScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(TEXT_INPUT, new ScreenNavigatorItem(TextInputScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.addScreen(PROGRESS_BAR, new ScreenNavigatorItem(ProgressBarScreen,
            {
                complete: MAIN_MENU
            }));
        
        this._navigator.showScreen(MAIN_MENU);
        
        this._transitionManager = new ScreenSlidingStackTransitionManager(this._navigator);
        this._transitionManager.duration = 0.4;
    }
}


import starling.display.DisplayObject;
import feathers.data.HierarchicalCollection;
import feathers.controls.ToggleSwitch;
import feathers.controls.GroupedList;
import feathers.controls.Slider;
import starling.textures.Texture;
import flash.display.BitmapData;
import feathers.controls.Button;
import feathers.controls.Header;
import starling.display.Image;
import feathers.data.ListCollection;
import feathers.controls.Radio;
import feathers.controls.List;
import feathers.controls.Check;
import feathers.controls.Screen;
import starling.core.Starling;
import feathers.controls.ScrollText;
import feathers.controls.ButtonGroup;
import feathers.skins.StandardIcons;
import feathers.controls.TabBar;
import flash.display.Shape;
import starling.animation.Tween;
import feathers.controls.PickerList;
import feathers.controls.TextInput;
import feathers.core.ToggleGroup;
import feathers.controls.Callout;
import feathers.controls.Label;
import feathers.controls.ProgressBar;
import feathers.controls.PageIndicator;

import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ButtonGroupScreen extends Screen
{
    public function ButtonGroupScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _buttonGroup:ButtonGroup;
    
    override protected function initialize():void
    {
        this._buttonGroup = new ButtonGroup();
        this._buttonGroup.dataProvider = new ListCollection(
            [
                { label: "One", triggered: button_triggeredHandler },
                { label: "Two", triggered: button_triggeredHandler },
                { label: "Three", triggered: button_triggeredHandler },
                { label: "Four", triggered: button_triggeredHandler },
            ]);
        this.addChild(this._buttonGroup);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Button Group";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._buttonGroup.validate();
        this._buttonGroup.x = (this.actualWidth - this._buttonGroup.width) / 2;
        this._buttonGroup.y = this._header.height + (this.actualHeight - this._header.height - this._buttonGroup.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function button_triggeredHandler(event:Event):void
    {
        const button:Button = Button(event.currentTarget);
        trace(button.label + " triggered.");
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]
[Event(name="showSettings",type="starling.events.Event")]

class ButtonScreen extends Screen
{
//    [Embed(source="/../assets/images/skull.png")]
//    private static const SKULL_ICON:Class;
    
    public static const SHOW_SETTINGS:String = "showSettings";
    
    private static function getIconImage():Image
    {
        var shape:Shape = new Shape();
        shape.graphics.beginFill(0x000000);
        shape.graphics.drawCircle(12, 12, 9);
        shape.graphics.drawCircle(8, 10, 3);
        shape.graphics.drawCircle(16, 10, 3);
        shape.graphics.endFill();
        var bitmapData:BitmapData = new BitmapData(24, 24, true, 0x00000000);
        bitmapData.draw(shape);
        return new Image(Texture.fromBitmapData(bitmapData));
    }
    
    public function ButtonScreen()
    {
        super();
    }
    
    public var settings:ButtonSettings;
    
    private var _button:Button;
    private var _header:Header;
    private var _backButton:Button;
    private var _settingsButton:Button;
    
    private var _icon:Image;
    
    override protected function initialize():void
    {
//        this._icon = new Image(Texture.fromBitmap(new SKULL_ICON()));
        this._icon = getIconImage();
        this._icon.scaleX = this._icon.scaleY = this.dpiScale;
        
        this._button = new Button();
        this._button.label = "Click Me";
        this._button.isToggle = this.settings.isToggle;
        if(this.settings.hasIcon)
        {
            this._button.defaultIcon = this._icon;
        }
        this._button.horizontalAlign = this.settings.horizontalAlign;
        this._button.verticalAlign = this.settings.verticalAlign;
        this._button.iconPosition = this.settings.iconPosition;
        this._button.iconOffsetX = this.settings.iconOffsetX;
        this._button.iconOffsetY = this.settings.iconOffsetY;
        this._button.width = 264 * this.dpiScale;
        this._button.height = 264 * this.dpiScale;
        this._button.addEventListener(Event.TRIGGERED, button_triggeredHandler);
        this.addChild(this._button);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._settingsButton = new Button();
        this._settingsButton.label = "Settings";
        this._settingsButton.addEventListener(Event.TRIGGERED, settingsButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Button";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        this._header.rightItems = new <DisplayObject>
            [
                this._settingsButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._button.validate();
        this._button.x = (this.actualWidth - this._button.width) / 2;
        this._button.y = this._header.height + (this.actualHeight - this._header.height - this._button.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function button_triggeredHandler(event:Event):void
    {
        trace("button triggered.")
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function settingsButton_triggeredHandler(event:Event):void
    {
        this.dispatchEventWith(SHOW_SETTINGS);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ButtonSettingsScreen extends Screen
{
    public function ButtonSettingsScreen()
    {
    }
    
    public var settings:ButtonSettings;
    
    private var _header:Header;
    private var _list:feathers.controls.List;
    private var _backButton:Button;
    
    private var _isToggleToggle:ToggleSwitch;
    private var _horizontalAlignPicker:PickerList;
    private var _verticalAlignPicker:PickerList;
    private var _iconToggle:ToggleSwitch;
    private var _iconPositionPicker:PickerList;
    private var _iconOffsetXSlider:Slider;
    private var _iconOffsetYSlider:Slider;
    
    override protected function initialize():void
    {
        this._isToggleToggle = new ToggleSwitch();
        this._isToggleToggle.isSelected = this.settings.isToggle;
        this._isToggleToggle.addEventListener(Event.CHANGE, isToggleToggle_changeHandler);
        
        this._horizontalAlignPicker = new PickerList();
        this._horizontalAlignPicker.typicalItem = Button.HORIZONTAL_ALIGN_CENTER;
        this._horizontalAlignPicker.dataProvider = new ListCollection(new <String>
            [
                Button.HORIZONTAL_ALIGN_LEFT,
                Button.HORIZONTAL_ALIGN_CENTER,
                Button.HORIZONTAL_ALIGN_RIGHT
            ]);
        this._horizontalAlignPicker.listProperties.typicalItem = Button.HORIZONTAL_ALIGN_CENTER;
        this._horizontalAlignPicker.selectedItem = this.settings.horizontalAlign;
        this._horizontalAlignPicker.addEventListener(Event.CHANGE, horizontalAlignPicker_changeHandler);
        
        this._verticalAlignPicker = new PickerList();
        this._verticalAlignPicker.typicalItem = Button.VERTICAL_ALIGN_BOTTOM;
        this._verticalAlignPicker.dataProvider = new ListCollection(new <String>
            [
                Button.VERTICAL_ALIGN_TOP,
                Button.VERTICAL_ALIGN_MIDDLE,
                Button.VERTICAL_ALIGN_BOTTOM
            ]);
        this._verticalAlignPicker.listProperties.typicalItem = Button.VERTICAL_ALIGN_BOTTOM;
        this._verticalAlignPicker.selectedItem = this.settings.verticalAlign;
        this._verticalAlignPicker.addEventListener(Event.CHANGE, verticalAlignPicker_changeHandler);
        
        this._iconToggle = new ToggleSwitch();
        this._iconToggle.isSelected = this.settings.hasIcon;
        this._iconToggle.addEventListener(Event.CHANGE, iconToggle_changeHandler);
        
        this._iconPositionPicker = new PickerList();
        this._iconPositionPicker.typicalItem = Button.ICON_POSITION_RIGHT_BASELINE;
        this._iconPositionPicker.dataProvider = new ListCollection(new <String>
            [
                Button.ICON_POSITION_TOP,
                Button.ICON_POSITION_RIGHT,
                Button.ICON_POSITION_RIGHT_BASELINE,
                Button.ICON_POSITION_BOTTOM,
                Button.ICON_POSITION_LEFT,
                Button.ICON_POSITION_LEFT_BASELINE,
                Button.ICON_POSITION_MANUAL
            ]);
        this._iconPositionPicker.listProperties.typicalItem = Button.ICON_POSITION_RIGHT_BASELINE;
        this._iconPositionPicker.selectedItem = this.settings.iconPosition;
        this._iconPositionPicker.addEventListener(Event.CHANGE, iconPositionPicker_changeHandler);
        
        this._iconOffsetXSlider = new Slider();
        //there is no actual limit. these are aribitrary.
        this._iconOffsetXSlider.minimum = -50;
        this._iconOffsetXSlider.maximum = 50;
        this._iconOffsetXSlider.step = 1;
        this._iconOffsetXSlider.value = this.settings.iconOffsetX;
        this._iconOffsetXSlider.addEventListener(Event.CHANGE, iconOffsetXSlider_changeHandler);
        
        this._iconOffsetYSlider = new Slider();
        this._iconOffsetYSlider.minimum = -50;
        this._iconOffsetYSlider.maximum = 50;
        this._iconOffsetYSlider.step = 1;
        this._iconOffsetYSlider.value = this.settings.iconOffsetY;
        this._iconOffsetYSlider.addEventListener(Event.CHANGE, iconOffsetYSlider_changeHandler);
        
        this._list = new feathers.controls.List();
        this._list.isSelectable = false;
        this._list.dataProvider = new ListCollection(
            [
                { label: "isToggle", accessory: this._isToggleToggle },
                { label: "horizontalAlign", accessory: this._horizontalAlignPicker },
                { label: "verticalAlign", accessory: this._verticalAlignPicker },
                { label: "icon", accessory: this._iconToggle },
                { label: "iconPosition", accessory: this._iconPositionPicker },
                { label: "iconOffsetX", accessory: this._iconOffsetXSlider },
                { label: "iconOffsetY", accessory: this._iconOffsetYSlider }
            ]);
        this.addChild(this._list);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Button Settings";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function isToggleToggle_changeHandler(event:Event):void
    {
        this.settings.isToggle = this._isToggleToggle.isSelected;
    }
    
    private function horizontalAlignPicker_changeHandler(event:Event):void
    {
        this.settings.horizontalAlign = this._horizontalAlignPicker.selectedItem as String;
    }
    
    private function verticalAlignPicker_changeHandler(event:Event):void
    {
        this.settings.verticalAlign = this._verticalAlignPicker.selectedItem as String;
    }
    
    private function iconToggle_changeHandler(event:Event):void
    {
        this.settings.hasIcon = this._iconToggle.isSelected;
    }
    
    private function iconPositionPicker_changeHandler(event:Event):void
    {
        this.settings.iconPosition = this._iconPositionPicker.selectedItem as String;
    }
    
    private function iconOffsetXSlider_changeHandler(event:Event):void
    {
        this.settings.iconOffsetX = this._iconOffsetXSlider.value;
    }
    
    private function iconOffsetYSlider_changeHandler(event:Event):void
    {
        this.settings.iconOffsetY = this._iconOffsetYSlider.value;
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class CalloutScreen extends Screen
{
    private static const CONTENT_TEXT:String = "Thank you for trying Feathers.\nHappy coding.";
    
    public function CalloutScreen()
    {
    }
    
    private var _rightButton:Button;
    private var _downButton:Button;
    private var _upButton:Button;
    private var _leftButton:Button;
    private var _header:Header;
    private var _backButton:Button;
    
    override protected function initialize():void
    {
        this._rightButton = new Button();
        this._rightButton.label = "Right";
        this._rightButton.addEventListener(Event.TRIGGERED, rightButton_triggeredHandler);
        this.addChild(this._rightButton);
        
        this._downButton = new Button();
        this._downButton.label = "Down";
        this._downButton.addEventListener(Event.TRIGGERED, downButton_triggeredHandler);
        this.addChild(this._downButton);
        
        this._upButton = new Button();
        this._upButton.label = "Up";
        this._upButton.addEventListener(Event.TRIGGERED, upButton_triggeredHandler);
        this.addChild(this._upButton);
        
        this._leftButton = new Button();
        this._leftButton.label = "Left";
        this._leftButton.addEventListener(Event.TRIGGERED, leftButton_triggeredHandler);
        this.addChild(this._leftButton);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Callout";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        const margin:Number = this._header.height * 0.25;
        
        this._rightButton.validate();
        this._rightButton.x = margin;
        this._rightButton.y = this._header.height + margin;
        
        this._downButton.validate();
        this._downButton.x = this.actualWidth - this._downButton.width - margin;
        this._downButton.y = this._header.height + margin;
        
        this._upButton.validate();
        this._upButton.x = margin;
        this._upButton.y = this.actualHeight - this._upButton.height - margin;
        
        this._leftButton.validate();
        this._leftButton.x = this.actualWidth - this._leftButton.width - margin;
        this._leftButton.y = this.actualHeight - this._leftButton.height - margin;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function rightButton_triggeredHandler(event:Event):void
    {
        const content:Label = new Label();
        content.text = CONTENT_TEXT;
        Callout.show(DisplayObject(content), this._rightButton, Callout.DIRECTION_RIGHT);
    }
    
    private function downButton_triggeredHandler(event:Event):void
    {
        const content:Label = new Label();
        content.text = CONTENT_TEXT;
        Callout.show(DisplayObject(content), this._downButton, Callout.DIRECTION_DOWN);
    }
    
    private function upButton_triggeredHandler(event:Event):void
    {
        const content:Label = new Label();
        content.text = CONTENT_TEXT;
        Callout.show(DisplayObject(content), this._upButton, Callout.DIRECTION_UP);
    }
    
    private function leftButton_triggeredHandler(event:Event):void
    {
        const content:Label = new Label();
        content.text = CONTENT_TEXT;
        Callout.show(DisplayObject(content), this._leftButton, Callout.DIRECTION_LEFT);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]
[Event(name="showSettings",type="starling.events.Event")]

class GroupedListScreen extends Screen
{
    public static const SHOW_SETTINGS:String = "showSettings";
    
    public function GroupedListScreen()
    {
        super();
    }
    
    public var settings:GroupedListSettings;
    
    private var _list:GroupedList;
    private var _header:Header;
    private var _backButton:Button;
    private var _settingsButton:Button;
    
    override protected function initialize():void
    {
        var groups:Array =
            [
                {
                    header: "A",
                    children:
                    [
                        { text: "Aardvark" },
                        { text: "Alligator" },
                        { text: "Alpaca" },
                        { text: "Anteater" },
                    ]
                },
                {
                    header: "B",
                    children:
                    [
                        { text: "Baboon" },
                        { text: "Bear" },
                        { text: "Beaver" },
                    ]
                },
                {
                    header: "C",
                    children:
                    [
                        { text: "Canary" },
                        { text: "Cat" },
                    ]
                },
                {
                    header: "D",
                    children:
                    [
                        { text: "Deer" },
                        { text: "Dingo" },
                        { text: "Dog" },
                        { text: "Dolphin" },
                        { text: "Donkey" },
                        { text: "Dragonfly" },
                        { text: "Duck" },
                        { text: "Dung Beetle" },
                    ]
                },
                {
                    header: "E",
                    children:
                    [
                        { text: "Eagle" },
                        { text: "Earthworm" },
                        { text: "Eel" },
                        { text: "Elk" },
                    ]
                }
            ];
        groups.fixed = true;
        
        this._list = new GroupedList();
        if(this.settings.style == GroupedListSettings.STYLE_INSET)
        {
            this._list.nameList.add(GroupedList.ALTERNATE_NAME_INSET_GROUPED_LIST);
        }
        this._list.dataProvider = new HierarchicalCollection(groups);
        this._list.typicalItem = { text: "Item 1000" };
        this._list.typicalHeader = "Group 10";
        this._list.typicalFooter = "Footer 10";
        this._list.isSelectable = this.settings.isSelectable;
        this._list.scrollerProperties.hasElasticEdges = this.settings.hasElasticEdges;
        this._list.itemRendererProperties.labelField = "text";
        this._list.addEventListener(Event.CHANGE, list_changeHandler);
        this.addChildAt(this._list, 0);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButtontriggeredHandler);
        
        this._settingsButton = new Button();
        this._settingsButton.label = "Settings";
        this._settingsButton.addEventListener(Event.TRIGGERED, settingsButtontriggeredHandler);
        
        this._header = new Header();
        this._header.title = "Grouped List";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        this._header.rightItems = new <DisplayObject>
            [
                this._settingsButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
        this._list.validate();
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButtontriggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function settingsButtontriggeredHandler(event:Event):void
    {
        this.dispatchEventWith(SHOW_SETTINGS);
    }
    
    private function list_changeHandler(event:Event):void
    {
        trace("GroupedList onChange:", this._list.selectedGroupIndex, this._list.selectedItemIndex);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class GroupedListSettingsScreen extends Screen
{
    public function GroupedListSettingsScreen()
    {
    }
    
    public var settings:GroupedListSettings;
    
    private var _header:Header;
    private var _list:feathers.controls.List;
    private var _backButton:Button;
    
    private var _stylePicker:PickerList;
    private var _isSelectableToggle:ToggleSwitch;
    private var _hasElasticEdgesToggle:ToggleSwitch;
    
    override protected function initialize():void
    {
        this._stylePicker = new PickerList();
        this._stylePicker.dataProvider = new ListCollection(new <String>
            [
                GroupedListSettings.STYLE_NORMAL,
                GroupedListSettings.STYLE_INSET
            ]);
        this._stylePicker.typicalItem = GroupedListSettings.STYLE_NORMAL;
        this._stylePicker.listProperties.typicalItem = GroupedListSettings.STYLE_NORMAL;
        this._stylePicker.selectedItem = this.settings.style;
        this._stylePicker.addEventListener(Event.CHANGE, stylePicker_changeHandler);
        
        this._isSelectableToggle = new ToggleSwitch();
        this._isSelectableToggle.isSelected = this.settings.isSelectable;
        this._isSelectableToggle.addEventListener(Event.CHANGE, isSelectableToggle_changeHandler);
        
        this._hasElasticEdgesToggle = new ToggleSwitch();
        this._hasElasticEdgesToggle.isSelected = this.settings.hasElasticEdges;
        this._hasElasticEdgesToggle.addEventListener(Event.CHANGE, hasElasticEdgesToggle_changeHandler);
        
        this._list = new feathers.controls.List();
        this._list.isSelectable = false;
        this._list.dataProvider = new ListCollection(
            [
                { label: "Group Style", accessory: this._stylePicker },
                { label: "isSelectable", accessory: this._isSelectableToggle },
                { label: "hasElasticEdges", accessory: this._hasElasticEdgesToggle },
            ]);
        this.addChild(this._list);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "List Settings";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function stylePicker_changeHandler(event:Event):void
    {
        this.settings.style = this._stylePicker.selectedItem as String;
    }
    
    private function isSelectableToggle_changeHandler(event:Event):void
    {
        this.settings.isSelectable = this._isSelectableToggle.isSelected;
    }
    
    private function hasElasticEdgesToggle_changeHandler(event:Event):void
    {
        this.settings.hasElasticEdges = this._hasElasticEdgesToggle.isSelected;
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]
[Event(name="showSettings",type="starling.events.Event")]

class ListScreen extends Screen
{
    public static const SHOW_SETTINGS:String = "showSettings";
    
    public function ListScreen()
    {
        super();
    }
    
    public var settings:ListSettings;
    
    private var _list:feathers.controls.List;
    private var _header:Header;
    private var _backButton:Button;
    private var _settingsButton:Button;
    
    override protected function initialize():void
    {
        var items:Array = [];
        for(var i:int = 0; i < 150; i++)
        {
            var item:Object = {text: "Item " + (i + 1).toString()};
            items.push(item);
        }
        items.fixed = true;
        
        this._list = new feathers.controls.List();
        this._list.dataProvider = new ListCollection(items);
        this._list.typicalItem = {text: "Item 1000"};
        this._list.isSelectable = this.settings.isSelectable;
        this._list.scrollerProperties.hasElasticEdges = this.settings.hasElasticEdges;
        this._list.itemRendererProperties.labelField = "text";
        this._list.addEventListener(Event.CHANGE, list_changeHandler);
        this.addChildAt(this._list, 0);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._settingsButton = new Button();
        this._settingsButton.label = "Settings";
        this._settingsButton.addEventListener(Event.TRIGGERED, settingsButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "List";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        this._header.rightItems = new <DisplayObject>
            [
                this._settingsButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function settingsButton_triggeredHandler(event:Event):void
    {
        this.dispatchEventWith(SHOW_SETTINGS);
    }
    
    private function list_changeHandler(event:Event):void
    {
        trace("List onChange:", this._list.selectedIndex);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ListSettingsScreen extends Screen
{
    public function ListSettingsScreen()
    {
    }
    
    public var settings:ListSettings;
    
    private var _header:Header;
    private var _list:feathers.controls.List;
    private var _backButton:Button;
    
    private var _isSelectableToggle:ToggleSwitch;
    private var _hasElasticEdgesToggle:ToggleSwitch;
    
    override protected function initialize():void
    {
        this._isSelectableToggle = new ToggleSwitch();
        this._isSelectableToggle.isSelected = this.settings.isSelectable;
        this._isSelectableToggle.addEventListener(Event.CHANGE, isSelectableToggle_changeHandler);
        
        this._hasElasticEdgesToggle = new ToggleSwitch();
        this._hasElasticEdgesToggle.isSelected = this.settings.hasElasticEdges;
        this._hasElasticEdgesToggle.addEventListener(Event.CHANGE, hasElasticEdgesToggle_changeHandler);
        
        this._list = new feathers.controls.List();
        this._list.isSelectable = false;
        this._list.dataProvider = new ListCollection(
            [
                { label: "isSelectable", accessory: this._isSelectableToggle },
                { label: "hasElasticEdges", accessory: this._hasElasticEdgesToggle },
            ]);
        this.addChild(this._list);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "List Settings";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function isSelectableToggle_changeHandler(event:Event):void
    {
        this.settings.isSelectable = this._isSelectableToggle.isSelected;
    }
    
    private function hasElasticEdgesToggle_changeHandler(event:Event):void
    {
        this.settings.hasElasticEdges = this._hasElasticEdgesToggle.isSelected;
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]
[Event(name="showButton",type="starling.events.Event")]
[Event(name="showButtonGroup",type="starling.events.Event")]
[Event(name="showCallout",type="starling.events.Event")]
[Event(name="showGroupedList",type="starling.events.Event")]
[Event(name="showList",type="starling.events.Event")]
[Event(name="showPageIndicator",type="starling.events.Event")]
[Event(name="showPickerList",type="starling.events.Event")]
[Event(name="showProgressBar",type="starling.events.Event")]
[Event(name="showScrollText",type="starling.events.Event")]
[Event(name="showSlider",type="starling.events.Event")]
[Event(name="showTabBar",type="starling.events.Event")]
[Event(name="showTextInput",type="starling.events.Event")]
[Event(name="showToggles",type="starling.events.Event")]

class MainMenuScreen extends Screen
{
    public static const SHOW_BUTTON:String = "showButton";
    public static const SHOW_BUTTON_GROUP:String = "showButtonGroup";
    public static const SHOW_CALLOUT:String = "showCallout";
    public static const SHOW_GROUPED_LIST:String = "showGroupedList";
    public static const SHOW_LIST:String = "showList";
    public static const SHOW_PAGE_INDICATOR:String = "showPageIndicator";
    public static const SHOW_PICKER_LIST:String = "showPickerList";
    public static const SHOW_PROGRESS_BAR:String = "showProgressBar";
    public static const SHOW_SCROLL_TEXT:String = "showScrollText";
    public static const SHOW_SLIDER:String = "showSlider";
    public static const SHOW_TAB_BAR:String = "showTabBar";
    public static const SHOW_TEXT_INPUT:String = "showTextInput";
    public static const SHOW_TOGGLES:String = "showToggles";
    
    public function MainMenuScreen()
    {
        super();
    }
    
    private var _header:Header;
    private var _list:feathers.controls.List;
    
    override protected function initialize():void
    {
        this._header = new Header();
        this._header.title = "Feathers";
        this.addChild(this._header);
        
        this._list = new feathers.controls.List();
        this._list.dataProvider = new ListCollection(
            [
                { label: "Button", event: SHOW_BUTTON },
                { label: "Button Group", event: SHOW_BUTTON_GROUP },
                { label: "Callout", event: SHOW_CALLOUT },
                { label: "Grouped List", event: SHOW_GROUPED_LIST },
                { label: "List", event: SHOW_LIST },
                { label: "Page Indicator", event: SHOW_PAGE_INDICATOR },
                { label: "Picker List", event: SHOW_PICKER_LIST },
                { label: "Progress Bar", event: SHOW_PROGRESS_BAR },
                { label: "Scroll Text", event: SHOW_SCROLL_TEXT },
                { label: "Slider", event: SHOW_SLIDER},
                { label: "Tab Bar", event: SHOW_TAB_BAR },
                { label: "Text Input", event: SHOW_TEXT_INPUT },
                { label: "Toggles", event: SHOW_TOGGLES },
            ]);
        this._list.itemRendererProperties.labelField = "label";
        this._list.itemRendererProperties.accessorySourceFunction = accessorySourceFunction;
        this._list.addEventListener(Event.CHANGE, list_changeHandler);
        this.addChild(this._list);
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function accessorySourceFunction(item:Object):Texture
    {
        return StandardIcons.listDrillDownAccessoryTexture;
    }
    
    private function list_changeHandler(event:Event):void
    {
        const eventType:String = this._list.selectedItem.event as String;
        this.dispatchEventWith(eventType);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class PageIndicatorScreen extends Screen
{
    public function PageIndicatorScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _pageIndicator:PageIndicator;
    
    override protected function initialize():void
    {
        this._pageIndicator = new PageIndicator();
        this._pageIndicator.pageCount = 5;
        this._pageIndicator.addEventListener(Event.CHANGE, pageIndicator_changeHandler);
        this.addChild(this._pageIndicator);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Page Indicator";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._pageIndicator.width = this.actualWidth;
        this._pageIndicator.validate();
        this._pageIndicator.y = this._header.height + (this.actualHeight - this._header.height - this._pageIndicator.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function pageIndicator_changeHandler(event:Event):void
    {
        trace("page indicator change:", this._pageIndicator.selectedIndex);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class PickerListScreen extends Screen
{
    public function PickerListScreen()
    {
        super();
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _list:PickerList;
    
    override protected function initialize():void
    {
        var items:Array = [];
        for(var i:int = 0; i < 150; i++)
        {
            var item:Object = {text: "Item " + (i + 1).toString()};
            items.push(item);
        }
        items.fixed = true;
        
        this._list = new PickerList();
        this._list.dataProvider = new ListCollection(items);
        this.addChildAt(this._list, 0);
        
        this._list.typicalItem = {text: "Item 1000"};
        this._list.labelField = "text";
        
        //notice that we're setting typicalItem on the list separately. we
        //may want to have the list measure at a different width, so it
        //might need a different typical item than the picker list's button.
        this._list.listProperties.typicalItem = {text: "Item 1000"};
        
        //notice that we're setting labelField on the item renderers
        //separately. the default item renderer has a labelField property,
        //but a custom item renderer may not even have a label, so
        //PickerList cannot simply pass its labelField down to item
        //renderers automatically
        this._list.listProperties.@itemRendererProperties.labelField = "text";
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Picker List";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.validate();
        this._list.x = (this.actualWidth - this._list.width) / 2;
        this._list.y = this._header.height + (this.actualHeight - this._header.height - this._list.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ProgressBarScreen extends Screen
{
    public function ProgressBarScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _progress:ProgressBar;
    
    private var _progressTween:Tween;
    
    override protected function initialize():void
    {
        this._progress = new ProgressBar();
        this._progress.minimum = 0;
        this._progress.maximum = 1;
        this._progress.value = 0;
        this.addChild(this._progress);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Progress Bar";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
        
        this._progressTween = new Tween(this._progress, 5);
        this._progressTween.animate("value", 1);
        this._progressTween.repeatCount = int.MAX_VALUE;
        Starling.juggler.add(this._progressTween);
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._progress.validate();
        this._progress.x = (this.actualWidth - this._progress.width) / 2;
        this._progress.y = this._header.height + (this.actualHeight - this._header.height - this._progress.height) / 2;
    }
    
    private function onBackButton():void
    {
        if(this._progressTween)
        {
            Starling.juggler.remove(this._progressTween);
            this._progressTween = null;
        }
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ScrollTextScreen extends Screen
{
    public function ScrollTextScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _scrollText:ScrollText;
    
    override protected function initialize():void
    {
        this._scrollText = new ScrollText();
        this._scrollText.text = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\nSed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.\n\nNeque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?\n\nAt vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.";
        this.addChild(this._scrollText);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Scroll Text";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._scrollText.width = this.actualWidth;
        this._scrollText.y = this._header.height;
        this._scrollText.height = this.actualHeight - this._scrollText.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]
[Event(name="showSettings",type="starling.events.Event")]

class SliderScreen extends Screen
{
    public static const SHOW_SETTINGS:String = "showSettings";
    
    public function SliderScreen()
    {
        super();
    }
    
    public var settings:SliderSettings;
    
    private var _slider:Slider;
    private var _header:Header;
    private var _backButton:Button;
    private var _settingsButton:Button;
    private var _valueLabel:Label;
    
    override protected function initialize():void
    {
        this._slider = new Slider();
        this._slider.minimum = 0;
        this._slider.maximum = 100;
        this._slider.value = 50;
        this._slider.step = this.settings.step;
        this._slider.page = this.settings.page;
        this._slider.direction = this.settings.direction;
        this._slider.liveDragging = this.settings.liveDragging;
        this._slider.addEventListener(Event.CHANGE, slider_changeHandler);
        this.addChild(this._slider);
        
        this._valueLabel = new Label();
        this._valueLabel.text = this._slider.value.toString();
        this.addChild(DisplayObject(this._valueLabel));
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._settingsButton = new Button();
        this._settingsButton.label = "Settings";
        this._settingsButton.addEventListener(Event.TRIGGERED, settingsButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Slider";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        this._header.rightItems = new <DisplayObject>
            [
                this._settingsButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        const spacingX:Number = this._header.height * 0.2;
        
        //auto-size the slider and label so that we can position them properly
        this._slider.validate();
        
        this._valueLabel.validate();
        
        const contentWidth:Number = this._slider.width + spacingX + this._valueLabel.width;
        this._slider.x = (this.actualWidth - contentWidth) / 2;
        this._slider.y = this._header.height + (this.actualHeight - this._header.height - this._slider.height) / 2;
        this._valueLabel.x = this._slider.x + this._slider.width + spacingX;
        this._valueLabel.y = this._slider.y + (this._slider.height - this._valueLabel.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function slider_changeHandler(event:Event):void
    {
        this._valueLabel.text = this._slider.value.toString();
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function settingsButton_triggeredHandler(event:Event):void
    {
        this.dispatchEventWith(SHOW_SETTINGS);
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class SliderSettingsScreen extends Screen
{
    public function SliderSettingsScreen()
    {
    }
    
    public var settings:SliderSettings;
    
    private var _header:Header;
    private var _list:feathers.controls.List;
    private var _backButton:Button;
    private var _directionPicker:PickerList;
    private var _liveDraggingToggle:ToggleSwitch;
    private var _stepSlider:Slider;
    private var _pageSlider:Slider;
    
    override protected function initialize():void
    {
        this._directionPicker = new PickerList();
        this._directionPicker.typicalItem = Slider.DIRECTION_HORIZONTAL;
        this._directionPicker.dataProvider = new ListCollection(new <String>
            [
                Slider.DIRECTION_HORIZONTAL,
                Slider.DIRECTION_VERTICAL
            ]);
        this._directionPicker.listProperties.typicalItem = Slider.DIRECTION_HORIZONTAL;
        this._directionPicker.selectedItem = this.settings.direction;
        this._directionPicker.addEventListener(Event.CHANGE, directionPicker_changeHandler);
        
        this._liveDraggingToggle = new ToggleSwitch();
        this._liveDraggingToggle.isSelected = this.settings.liveDragging;
        this._liveDraggingToggle.addEventListener(Event.CHANGE, liveDraggingToggle_changeHandler);
        
        this._stepSlider = new Slider();
        this._stepSlider.minimum = 1;
        this._stepSlider.maximum = 20;
        this._stepSlider.step = 1;
        this._stepSlider.value = this.settings.step;
        this._stepSlider.addEventListener(Event.CHANGE, stepSlider_changeHandler);
        
        this._pageSlider = new Slider();
        this._pageSlider.minimum = 1;
        this._pageSlider.maximum = 20;
        this._pageSlider.step = 1;
        this._pageSlider.value = this.settings.page;
        this._pageSlider.addEventListener(Event.CHANGE, pageSlider_changeHandler);
        
        this._list = new feathers.controls.List();
        this._list.isSelectable = false;
        this._list.dataProvider = new ListCollection(
            [
                { label: "direction", accessory: this._directionPicker },
                { label: "liveDragging", accessory: this._liveDraggingToggle },
                { label: "step", accessory: this._stepSlider },
                { label: "page", accessory: this._pageSlider },
            ]);
        this.addChild(this._list);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Slider Settings";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._list.y = this._header.height;
        this._list.width = this.actualWidth;
        this._list.height = this.actualHeight - this._list.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function directionPicker_changeHandler(event:Event):void
    {
        this.settings.direction = this._directionPicker.selectedItem as String;
    }
    
    private function liveDraggingToggle_changeHandler(event:Event):void
    {
        this.settings.liveDragging = this._liveDraggingToggle.isSelected;
    }
    
    private function stepSlider_changeHandler(event:Event):void
    {
        this.settings.step = this._stepSlider.value;
    }
    
    private function pageSlider_changeHandler(event:Event):void
    {
        this.settings.page = this._pageSlider.value;
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class TabBarScreen extends Screen
{
    public function TabBarScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _tabBar:TabBar;
    private var _label:Label;
    
    override protected function initialize():void
    {
        this._tabBar = new TabBar();
        this._tabBar.dataProvider = new ListCollection(
            [
                { label: "One" },
                { label: "Two" },
                { label: "Three" },
            ]);
        this._tabBar.addEventListener(Event.CHANGE, tabBar_changeHandler);
        this.addChild(this._tabBar);
        
        this._label = new Label();
        this._label.text = "selectedIndex: " + this._tabBar.selectedIndex.toString();
        this.addChild(DisplayObject(this._label));
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Tab Bar";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._tabBar.width = this.actualWidth;
        this._tabBar.validate();
        this._tabBar.y = this.actualHeight - this._tabBar.height;
        
        this._label.validate();
        this._label.x = (this.actualWidth - this._label.width) / 2;
        this._label.y = this._header.height + (this.actualHeight - this._header.height - this._tabBar.height - this._label.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
    
    private function tabBar_changeHandler(event:Event):void
    {
        this._label.text = "selectedIndex: " + this._tabBar.selectedIndex.toString();
        this.invalidate();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class TextInputScreen extends Screen
{
    public function TextInputScreen()
    {
    }
    
    private var _header:Header;
    private var _backButton:Button;
    private var _input:TextInput;
    
    override protected function initialize():void
    {
        this._input = new TextInput();
        this.addChild(this._input);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Text Input";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        this._input.validate();
        this._input.x = (this.actualWidth - this._input.width) / 2;
        this._input.y = this._header.height + (this.actualHeight - this._header.height - this._input.height) / 2;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


import starling.events.Event;

[Event(name="complete",type="starling.events.Event")]

class ToggleScreen extends Screen
{
    public function ToggleScreen()
    {
        super();
    }
    
    private var _header:Header;
    private var _toggleSwitch:ToggleSwitch;
    private var _check1:Check;
    private var _check2:Check;
    private var _check3:Check;
    private var _radio1:Radio;
    private var _radio2:Radio;
    private var _radio3:Radio;
    private var _radioGroup:ToggleGroup;
    private var _backButton:Button;
    
    override protected function initialize():void
    {
        this._toggleSwitch = new ToggleSwitch();
        this._toggleSwitch.isSelected = false;
        this._toggleSwitch.addEventListener(Event.CHANGE, toggleSwitch_changeHandler);
        this.addChild(this._toggleSwitch);
        
        this._check1 = new Check();
        this._check1.isSelected = false;
        this._check1.label = "Check 1";
        this.addChild(this._check1);
        
        this._check2 = new Check();
        this._check2.isSelected = false;
        this._check2.label = "Check 2";
        this.addChild(this._check2);
        
        this._check3 = new Check();
        this._check3.isSelected = false;
        this._check3.label = "Check 3";
        this.addChild(this._check3);
        
        this._radioGroup = new ToggleGroup();
        this._radioGroup.addEventListener(Event.CHANGE, radioGroup_changeHandler);
        
        this._radio1 = new Radio();
        this._radio1.label = "Radio 1";
        //this._radio1.toggleGroup = this._radioGroup;
        this._radioGroup.addItem(this._radio1);
        this.addChild(this._radio1);
        
        this._radio2 = new Radio();
        this._radio2.label = "Radio 2";
        //this._radio2.toggleGroup = this._radioGroup;
        this._radioGroup.addItem(this._radio2);
        this.addChild(this._radio2);
        
        this._radio3 = new Radio();
        this._radio3.label = "Radio 3";
        //this._radio3.toggleGroup = this._radioGroup;
        this._radioGroup.addItem(this._radio3);
        this.addChild(this._radio3);
        
        this._backButton = new Button();
        this._backButton.label = "Back";
        this._backButton.addEventListener(Event.TRIGGERED, backButton_triggeredHandler);
        
        this._header = new Header();
        this._header.title = "Toggles";
        this.addChild(this._header);
        this._header.leftItems = new <DisplayObject>
            [
                this._backButton
            ];
        
        // handles the back hardware key on android
        this.backButtonHandler = this.onBackButton;
    }
    
    override protected function draw():void
    {
        this._header.width = this.actualWidth;
        this._header.validate();
        
        const spacingX:Number = this._header.height * 0.2;
        const spacingY:Number = this._header.height * 0.4;
        
        //auto-size the toggle switch and label to position them properly
        this._toggleSwitch.validate();
        this._check1.validate();
        this._check2.validate();
        this._check3.validate();
        this._radio1.validate();
        this._radio2.validate();
        this._radio3.validate();
        
        const contentHeight:Number = this._toggleSwitch.height + this._check1.height + this._radio1.height + 2 * spacingY;
        this._toggleSwitch.x = (this.actualWidth - this._toggleSwitch.width) / 2;
        this._toggleSwitch.y = (this.actualHeight - contentHeight) / 2;
        
        const checkWidth:Number = this._check1.width + this._check2.width + this._check3.width + 2 * spacingX;
        this._check1.x = (this.actualWidth - checkWidth) / 2;
        this._check1.y = this._toggleSwitch.y + this._toggleSwitch.height + spacingY;
        this._check2.x = this._check1.x + this._check1.width + spacingX;
        this._check2.y = this._check1.y;
        this._check3.x = this._check2.x + this._check2.width + spacingX;
        this._check3.y = this._check1.y;
        
        const radioWidth:Number = this._radio1.width + this._radio2.width + this._radio3.width + 2 * spacingX;
        this._radio1.x = (this.actualWidth - radioWidth) / 2;
        this._radio1.y = this._check1.y + this._check1.height + spacingY;
        this._radio2.x = this._radio1.x + this._radio1.width + spacingX;
        this._radio2.y = this._radio1.y;
        this._radio3.x = this._radio2.x + this._radio2.width + spacingX;
        this._radio3.y = this._radio1.y;
    }
    
    private function onBackButton():void
    {
        this.dispatchEventWith(Event.COMPLETE);
    }
    
    private function toggleSwitch_changeHandler(event:Event):void
    {
        trace("toggle switch isSelected:", this._toggleSwitch.isSelected);
    }
    
    private function radioGroup_changeHandler(event:Event):void
    {
        trace("radio group change:", this._radioGroup.selectedIndex);
    }
    
    private function backButton_triggeredHandler(event:Event):void
    {
        this.onBackButton();
    }
}


class ButtonSettings
{
    public function ButtonSettings()
    {
    }
    
    public var isToggle:Boolean = false;
    public var horizontalAlign:String = Button.HORIZONTAL_ALIGN_CENTER;
    public var verticalAlign:String = Button.VERTICAL_ALIGN_MIDDLE;
    public var hasIcon:Boolean = true;
    public var iconPosition:String = Button.ICON_POSITION_LEFT;
    public var iconOffsetX:Number = 0;
    public var iconOffsetY:Number = 0;
}

class GroupedListSettings
{
    public static const STYLE_NORMAL:String = "normal";
    public static const STYLE_INSET:String = "inset";
    
    public function GroupedListSettings()
    {
    }
    
    public var isSelectable:Boolean = true;
    public var hasElasticEdges:Boolean = true;
    public var style:String = STYLE_NORMAL;
}

class ListSettings
{
    public function ListSettings()
    {
    }
    
    public var isSelectable:Boolean = true;
    public var hasElasticEdges:Boolean = true;
}


class SliderSettings
{
    public function SliderSettings()
    {
    }
    
    public var direction:String = Slider.DIRECTION_HORIZONTAL;
    public var step:Number = 1;
    public var page:Number = 10;
    public var liveDragging:Boolean = true;
}
