/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0X2Q
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    [SWF(width='465', height='465')]
    /** @author : Paul Ollivier (FLASHMAFIA) 2013 -- Simple midpoint circle implementation **/
    public class MPO extends Sprite//
    {
        private var bmd : BitmapData;
        private var buff : Vector.<uint>;
        private var mx : int;
        private var my : int;

        function MPO()
        {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false, 0x0));
            bm.x = bm.y = -((512 - 465) >> 1);
            bm.opaqueBackground = 0x0;
            addChild(bm);

            buff = new Vector.<uint>(512 * 512, true);

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            /* Ø */
            drawMPO(mx, my, 128, 0x0);
            drawMPO(mx, my, 129, 0x0);
            drawMPO(mx, my, 130, 0x0);
            drawMPO(mx, my, 131, 0x0);
            drawMPO(mx, my, 132, 0x0);

            mx = stage.mouseX >> 0;
            my = stage.mouseY >> 0;

            /* O */
            drawMPO(mx, my, 128, 0xDDDDDD);
            drawMPO(mx, my, 129, 0xDDDDDD);
            drawMPO(mx, my, 130, 0xDDDDDD);
            drawMPO(mx, my, 131, 0xDDDDDD);
            drawMPO(mx, my, 132, 0xDDDDDD);

            bmd.setVector(bmd.rect, buff);
        }

        private function drawMPO(cx : int, cy : int, r : int, c : uint) : void
        {
            buff[((cy & 511) << 9) + ((cx - r) & 511)] = c;
            buff[((cy & 511) << 9) + ((cx + r) & 511)] = c;
            buff[(((cy - r) & 511) << 9) + (cx & 511)] = c;
            buff[(((cy + r) & 511) << 9) + (cx & 511)] = c;

            var t : int;
            var d : int = 1 - r;
            var de : int = 3;
            var dse : int = 5 - (r << 1);

            /* 1/8th' O */
            while (r > t)
            {
                if (d < 0)
                {
                    d += de;
                    de++;
                    de++;
                    dse++;
                    dse++;
                }
                else
                {
                    d += dse;
                    de++;
                    de++;
                    dse++;
                    dse++;
                    dse++;
                    dse++;
                    r--;
                }
                t++;

                buff[(((cy - r) & 511) << 9) + ((cx - t) & 511)] = c;
                buff[(((cy - t) & 511) << 9) + ((cx - r) & 511)] = c;
                buff[(((cy - t) & 511) << 9) + ((cx + r) & 511)] = c;
                buff[(((cy - r) & 511) << 9) + ((cx + t) & 511)] = c;
                buff[(((cy + r) & 511) << 9) + ((cx - t) & 511)] = c;
                buff[(((cy + t) & 511) << 9) + ((cx - r) & 511)] = c;
                buff[(((cy + t) & 511) << 9) + ((cx + r) & 511)] = c;
                buff[(((cy + r) & 511) << 9) + ((cx + t) & 511)] = c;
            }
        }
    }
}