/**
 * Copyright sw_lucchini ( http://wonderfl.net/user/sw_lucchini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0Hu
 */

/*
* Progressionのエフェクトまとめ｜キョウダケダカンナー
* http://today-only.net/progression-effect/
*/

//Index
package {
	import jp.progression.casts.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.commands.*;
	import jp.progression.config.*;
	import jp.progression.data.*;
	import jp.progression.debug.*;
	import jp.progression.events.*;
	import jp.progression.scenes.*;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
	public class Index extends CastDocument {
		
		public function Index() {
			super( "index", IndexScene, new BasicAppConfig() );
		}
		
		override protected function atReady():void {
			manager.goto( manager.syncedSceneId );
		}
	}
}

//IndexScene
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.executors.*;
import jp.progression.scenes.*;
	
class IndexScene extends SceneObject {	
	private var _sp:Square;
		
	public function IndexScene() {
		title = "wonderfl";
		_sp = new Square();
	}

	override protected function atSceneInit():void {
		addCommand(
			new AddChild(container, _sp)
		);
	}
}

//Square
import fl.motion.easing.*;
import jp.progression.casts.*;
import jp.progression.casts.effects.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;

//使用したいエフェクトを拡張する。
class Square extends BlindsEffect {
		
public function Square( initObject:Object = null ) {
		super( initObject );
		var sp:Box = new Box();
		addChild(sp);
		
		//共通パラメータ
		this.direction = "in";
		this.duration = 0.5;
		this.easing = Bounce.easeInOut;
		
		//個別パラメータ
		this.dimension = 1;
		this.numStrips = 5;
	}
		
	override protected function atCastAdded():void {
	}

	override protected function atCastRemoved():void {
	}
}

//Box
import flash.display.*;
import jp.progression.casts.*;
import jp.progression.commands.display.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.commands.*;
import jp.progression.data.*;
import jp.progression.events.*;
import jp.progression.scenes.*;
	
class Box extends CastSprite {
	public function Box( initObject:Object = null ) {
		super( initObject );
		var sp:Sprite = new Sprite();
		sp.graphics.beginFill(0xFF0000);
		sp.graphics.drawRect(0,0,100,100);
		sp.graphics.endFill();
		sp.x = sp.y = 200;
		addChild(sp);
	}
}
