/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r0Bz
 */

package  
{
	import com.bit101.components.Text;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import net.user1.logger.LogEvent;
	import net.user1.logger.Logger;
	import net.user1.reactor.Reactor;
	import net.user1.reactor.ReactorEvent;
	import net.user1.reactor.Room;
	import net.user1.reactor.RoomEvent;
	/**
     * locahostへ接続してみる。localhostにUnion Serverが必要です。
     * インストール方法は、http://fla.la/archives/347
     * @author naoto koshikawa
     */
    public class TryUnion3 extends Sprite
    {
		//----------------------------------------------------------------------
		//  properties
		//----------------------------------------------------------------------
		//------------------------------
		//  private properties
		//------------------------------
		/**
		 * reactor
		 */
		private var _reactor:Reactor;
		
		/**
		 * room
		 */
		private var _room:Room;
		
		/**
		 * logger
		 */
		private var _logger:Logger;
		
		/**
		 * TextField
		 */
		private var _textField:TextField;
		
		//----------------------------------------------------------------------
		//  methods
		//----------------------------------------------------------------------
		//------------------------------
		//  public methods
		//------------------------------
		/**
		 * constructor
		 */
        public function TryUnion3() 
        {
			_textField = new TextField();
			_textField.defaultTextFormat = new TextFormat("_等幅", 10);
			_textField.width = _textField.height = 465;
			_textField.wordWrap = true;
			addChild(_textField);
			
            _reactor = new Reactor();
			_reactor.addEventListener(ReactorEvent.READY, _reactor_readyHandler);
			
			_logger = _reactor.getLog();
			_logger.addEventListener(LogEvent.UPDATE, _logger_updateHandler);
			
			
			_reactor.connect("localhost", 9100);
        }
		
		//----------------------------------------------------------------------
		//  event handler
		//----------------------------------------------------------------------
		/**
		 * ReactorEvent.Ready
		 * @param	event
		 */
		private function _reactor_readyHandler(event:ReactorEvent):void
		{
			_room = _reactor.getRoomManager().createRoom("test");
		}
		
		/**
		 * LogEvent.UPDATE
		 * @param	event
		 */
		private function _logger_updateHandler(event:LogEvent):void
		{
			_textField.appendText(
				"[" + event.getLevel() + "]"
				+ event.getMessage() + "\n");
			_textField.scrollV = _textField.maxScrollV;
			
		}
    }
}