/**
 * Copyright mmlemon_ ( http://wonderfl.net/user/mmlemon_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/r09w
 */

package {
	/**
	Tweener, Tweensy 
	*/
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.FilterShortcuts;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyGroup;
	
	import fl.motion.easing.Exponential;
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.filters.GlowFilter;
	import flash.ui.Keyboard;
	
	[SWF(backgroundColor=0x000000,frameRate=60)]
    public class FlashTest extends Sprite {
    		private var m_s1:Shape;
		private var m_s2:Shape;
		
		private var m_f1:GlowFilter;
		private var m_f2:GlowFilter;
		
        public function FlashTest() {
            addEventListener(Event.ADDED_TO_STAGE, init, false, 0, false);
		}
		
		private function init(event:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init, false);
			
			m_s1 = new Shape();
			m_s1.graphics.beginFill(0xff0000, 1);
			m_s1.graphics.drawCircle(0, 0, 30);
			m_s1.graphics.endFill();
			
			m_s2 = new Shape();
			m_s2.graphics.beginFill(0x0000ff, 1);
			m_s2.graphics.drawCircle(0, 0, 30);
			m_s2.graphics.endFill();
			
			m_s1.x = stage.stageWidth/2;
			m_s1.y = 100;
			
			m_s2.x = stage.stageWidth/2;
			m_s2.y = 300;
			
			addChild(m_s1);
			addChild(m_s2);
			
			FilterShortcuts.init();
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler, false, 0, false);
		}
		
		private function startTweenerFilter():void
		{
			m_f1 = new GlowFilter(0xffffff, 1, 0, 0, 1, 1, true, false);
			m_s1.filters = [m_f1];
			Tweener.addTween(m_s1, {_Glow_blurX: 40, _Glow_blurY: 40, time: 1});
		}
		private function startTweensyFilter():void
		{
			m_f2 = new GlowFilter(0xffffff, 1, 0, 0, 1, 1, true, false);
			m_s2.filters = [m_f2];
			
			var tg:TweensyGroup = new TweensyGroup();
			tg.to(m_f2, {blurX: 40, blurY: 40}, 1, null, 0, m_s2);
		}
		
		private function keyDownHandler(event:KeyboardEvent):void
		{
			switch(event.keyCode)
			{
				case Keyboard.UP:
					startTweenerFilter();
					break;
				case Keyboard.DOWN:
					startTweensyFilter();
					break;
				case Keyboard.LEFT:
					m_s2.filters = null;
				default:
					break;
			}
		}
    }
}