/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qzBG
 */

package {
  import com.actionscriptbible.Example;
  public class ch9ex2 extends Example {
    public function ch9ex2() {
      var rolodex:Rolodex = new Rolodex();
      rolodex.addEntry(new Person("Roger", "Braunstein", 3475551234));
      rolodex.addEntry(new Person("Simon", "Bolivar"));
      rolodex.addEntry(new Person("Shimon", "Peres"));
      trace("B entries:", rolodex.getEntriesUnderLetter("B"));
      var firstB:Person = Person(rolodex.getEntriesUnderLetter("B")[0]);
      //note that we still have to cast because this returns an IContact.
    }
  }
}

class Rolodex {
  protected var entries:Vector.<IContact>;
  public function Rolodex() {
    entries = new Vector.<IContact>();
  }
  public function addEntry(contact:IContact):void {
    entries.push(contact);
    entries = entries.sort(function(a:IContact, b:IContact):Number {
      return (a.lastName.toLowerCase() < b.lastName.toLowerCase())? -1 : 1;
    });
  }
  public function getEntriesUnderLetter(ltr:String):Vector.<IContact> {
    ltr = ltr.toLowerCase();
    return entries.filter(function(entry:IContact,...rest):Boolean {
      return (entry.lastName.charAt(0).toLowerCase() == ltr);
    });
  }
  public function getRandomEntry():IContact {
    return entries[Math.floor(Math.random() * entries.length)];
  }
  public function placeCall(contact:IContact):void {
    trace("calling", contact.phoneNumber);
  }
}

interface IContact {
  function get phoneNumber():Number;
  function get fullName():String;
  function get lastName():String;
}

class Person implements IContact {
  private var _phoneNumber:Number;
  private var _lastName:String;
  private var _firstName:String;
  public function Person(first:String, last:String = "", number:Number = 0) {
    _firstName = first;
    _lastName = last;
    _phoneNumber = number;
  }
  public function get phoneNumber():Number {return _phoneNumber;}
  public function get fullName():String {return _lastName + ", " + _firstName;}
  public function get lastName():String {return _lastName;}
  public function toString():String {return "[Person " + fullName + "]";}
}