/**
 * Copyright hacker_ciaxk5up ( http://wonderfl.net/user/hacker_ciaxk5up )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qz6n
 */

// forked from hibibi's flash on 2009-8-24
package 
{
    import flash.display.*
    import flash.events.*;
        import flash.system.*;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    
    public class Main extends Sprite 
    {
        public static const PROXY:String = "http://5ivestar.org/proxy/";
                public static const CROSSDOMAIN:String = "http://5ivestar.org/proxy/crossdomain.xml";
        
        private var _w:uint = 470;
        private var _h:uint = 470;
        
        private var _particle:Particle;
        private var _screen:Bitmap;
        private var _canvas:BitmapData;
        
        private var _goal:Point;
        private var _fillFlg:Boolean = true;
        
        private var _fil:BlurFilter = new BlurFilter(8, 8, 1);
        
        private var _col:ColorTransform = new ColorTransform(1, 1, 1, 1, -2, -2, -2 );
        
        
        public function Main():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.scaleMode = StageScaleMode.NO_SCALE;
                        Security.loadPolicyFile( CROSSDOMAIN );
            //画像の読み込み
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._loadedHandler);
            //loader.load(new URLRequest(PROXY+"http://a3.twimg.com/profile_images/62265389/hibibi.gif"));
            loader.load(new URLRequest(PROXY+"http://hibibi.org/face.png"));
            //
            
            var sp:Sprite = new Sprite();
            
            sp.graphics.beginFill(0x0);
            sp.graphics.drawRect(0, 0, this._w, this._h);
            sp.graphics.endFill();
            
            this.addChild(sp);
        }
        
        private function _render():void {
            var p:Particle = this._particle;
            this._canvas.lock();
            if (!this._fillFlg) {
                this._canvas.fillRect(this._canvas.rect, 0x000000);
            }else {
                this._canvas.colorTransform(this._canvas.rect, this._col)
                //this._canvas.applyFilter(this._canvas, this._canvas.rect, new Point(0, 0), this._fil);
            }
            while ((p = p.next) != null) {
                p.vx += ((this._goal.x+p.sx) - p.x) * p.spring;
                p.vy += ((this._goal.y+p.sy) - p.y) * p.spring;
                p.vx *= p.f;
                p.vy *= p.f;
                p.x += p.vx;
                p.y += p.vy;
                this._canvas.setPixel32(Math.round(p.x), Math.round(p.y), p.color);
            }
            this._canvas.unlock();
        }
        
        private function _screenClickHandler(e:MouseEvent):void {
            this._fillFlg = !this._fillFlg;
            if (!this.hasEventListener(Event.ENTER_FRAME)) {
                this.addEventListener(Event.ENTER_FRAME, this._update);
            }
        }
        
        private function _loadedHandler(e:Event):void {
            LoaderInfo(e.currentTarget).removeEventListener(Event.COMPLETE, _loadedHandler);
            var bm:Bitmap = Loader(e.currentTarget.loader).content as Bitmap;
            
            var bmd:BitmapData = bm.bitmapData;
            this._goal = new Point(int(this._w / 2) - int(bm.width / 2), int(this._h / 2) - int(bm.height / 2));
            var col:uint;
            var p:Particle;
            //var skip:uint;
            //画像からパーティクルデータを作成
            for (var i:int = 0; i < bm.width; ++i) {
                for (var j:int = 0; j < bm.height; ++j) {
                    //if (bmd.getPixel32(i, j) == 0x00FFFFFF) continue;
                    p = new Particle();
                    p.color = bmd.getPixel32(i, j);
                    p.x = i + this._goal.x;
                    p.y = j + this._goal.y;
                    p.sx = i;
                    p.sy = j;
                    p.next = this._particle;
                    this._particle = p;
                }
            }
            
            //描画用のBitmapDataを作成
            this._canvas = new BitmapData(this._w, this._h, false, 0x0);
            this._screen = new Bitmap(this._canvas);
            
            
            this.addChild(this._screen);
            this.addEventListener(MouseEvent.CLICK, this._screenClickHandler);
            //this.buttonMode = true;
            this._render();
        }
        
        private function _update(e:Event):void {
            this._goal = new Point(mouseX-64, mouseY-64);
            this._render();
        }
    }
    
}

internal class Particle 
{
    
    public var sx:Number = 0;
    public var sy:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var spring:Number = Math.random() * 0.9 + 0.1;
    public var f:Number = 1-(Math.random()*0.1+0.05)
    public var next:Particle;
    public var color:uint;
    
    public function Particle() {}
    
}

