/**
 * Copyright mizt ( http://wonderfl.net/user/mizt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qz0P
 */

// forked from kjkmr's ローディングの文字の100%のときの1と0の字間が気になるやつ
package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;

    public class Main extends Sprite {
       
        private var cnt:int = 0;
        private var tf:TextFormat = new TextFormat("Helvetica",40);
        private var _text1:TextField = new TextField();
        private var _text2:KerningTxt = new KerningTxt("Helvetica",40,0);
          
        public function Main() {
            
            stage.scaleMode = "noScale";
            stage.align = "TL";
        
            _text1.defaultTextFormat = tf;
            _text1.text = "11";
            _text1.x = 50;
            _text1.y = 50;
            addChild( _text1 );
            _text1.autoSize = TextFieldAutoSize.RIGHT; 
            _text1.selectable = false;
            
            _text2.x = 300;
            _text2.y = 50;
            _text2.text = "11";
            _text2.autoSize = TextFieldAutoSize.RIGHT; 
            _text2.selectable   = false;
            _text2.mouseEnabled = false;
            addChild( _text2 );
            (KerningPair.getInstance()).setPairs("Helvetica",16,{
                "00":-1,
                "10":-4,
                "11":-4,
                "12":-4,
                "13":-4,
                "14":-4,
                "15":-4,
                "16":-4,
                "17":-4,
                "18":-4,
                "19":-4,
                "80":-1,
                "81":-1,
                "82":-1,
                "83":-1,
                "84":-1,
                "85":-1,
                "86":-1,
                "87":-1,
                "88":-1,
                "89":-1,
                "90":-1,
                "91":-1,
                "92":-1,
                "93":-1,
                "94":-1,
                "95":-1,
                "96":-1,
                "97":-1,
                "98":-1,
                "99":-1
            });
            stage.addEventListener(Event.ENTER_FRAME,update);
        
        }
        
        private function update(e:Event):void {
            cnt+=2;
            _text1.text = ""+int(((cnt>=1000)?1000:cnt)/10);
            _text2.text = ""+int(((cnt>=1000)?1000:cnt)/10);
            if(cnt>=100*10+50) {
                cnt = 0;
            }
        
        }
        
    }
};

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

class KerningPair extends Object {

    private var _pair:Object = {};

    public static var _instance:KerningPair;
    public static function getInstance():KerningPair {
        if(_instance==null) _instance = new KerningPair();
        return　_instance;
    }


    public function setPair($font:String,$size:int,$str:String,$kern:int):void {
        if(!_pair[$font]) initialize($font,$size); 
        setupPair($font,$size,$str,$kern);
    }
    
    public function setPairs($font:String,$size:int,$obj:Object):void {
        if(!_pair[$font]) initialize($font,$size); 
        for(var key:String in $obj) setupPair($font,$size,key,$obj[key]);
    }
    
    private function setupPair($font:String,$size:int,$pair:String,$offset:int):void {
        if(!_pair[$font][$pair]) {
            _pair[$font][$pair] = new TextFormat($font,$size);
            _pair[$font][$pair].kerning = true;
            _pair[$font][$pair].letterSpacing = $offset;
        }
    }
    
    public function getPair($font:String,$f1:String,$f2:String):TextFormat {
        var pair:String = ""+$f1+$f2
        return (_pair[$font]&&_pair[$font][pair])?_pair[$font][pair]:null;
    }
    
    public function initialize($font:String,$size:int):void {
        if(!_pair[$font]) _pair[$font] = {};
    }
}

class KerningTxt extends TextField {
    private var _defaultFormat:TextFormat;
    private var _font:String = "";
    private var _size:int = 8;
    private var _color:uint = 0; 

    public function KerningTxt($font:String,$size:int,$color:uint):void {
        _font  = $font;
        _size  = $size;
        _color = $color;
        _defaultFormat = new TextFormat(_font,_size,_color); 
    }
    
    public override function set text($str:String):void {
        super.text = $str;
        this.defaultTextFormat = _defaultFormat;
        var len:int = $str.length;
        if(len>=1) {
            var crt:String = "";
            var pre:String = $str.substr(0,1);
            for(var k:int=1; k<len; k++) {
                crt = $str.substr(k,1);
                var fmt:TextFormat = (KerningPair.getInstance()).getPair(_font,pre,crt);
                if(fmt) {
                    fmt.size  = _size;
                    fmt.color = _color;
                    this.setTextFormat(fmt,k-1,k);
                }
                pre = crt;
            }
        }
        this.width  = this.textWidth +4;
        this.height = this.textHeight+4;
    }
};