/**
 * Copyright tomop ( http://wonderfl.net/user/tomop )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qyIx
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.StyleSheet;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    
    /*某有名ブランドのロゴ見たいのが
    現れる。ラメルジーほんとにしんじゃったのかなぁ
    バグったときによくみるようなやつ。
    */
    public class  FloodText extends Sprite
    {
            
        private var o:TextField;
        private var copy:BitmapData;
        private var canvas:BitmapData;
        private var pixel_size:uint = 1;
        private var row:uint = 0;
        private var h:Number;
        private var w:Number;
        private var rect:Rectangle = new Rectangle();
        private var canvas_bmp:Bitmap;
        
        private var column:int = stage.stageWidth;
    
        private var timer:Timer = new Timer(1000 / 100);
        public function FloodText():void {
            var fmt:TextFormat = new TextFormat();
            fmt.size = 64;
            fmt.color = 0xffffff;
            
            var style:StyleSheet = new StyleSheet();
            var flood:Object = new Object();
            flood.fontFamily = "sans-serif";
            flood.fontStyle = "italic";
            flood.color = "#000000";
            flood.fontSize = "72";
            flood.fontWeight = "bold"; 
            flood.letterSpacing = "-3";
            
            style.setStyle(".flood", flood);
            
            o = new TextField();
            o.styleSheet = style;
            o.htmlText = "<span class='flood'>Supreme　</span>";
            //o.embedFonts = false;
            o.autoSize = TextFieldAutoSize.LEFT;
            o.width = 550;
            
            copy = new BitmapData(550, 400, true, 0x00ffffff);
            canvas = new BitmapData(550, 400, true, 0x00ffffff);
            var mt:Matrix = new     Matrix();
            mt.translate((stage.stageWidth / 2) - o.width / 2 + 20, (stage.stageHeight / 3));
            copy.draw(o, mt);
            
            canvas_bmp = addChild(new Bitmap(canvas)) as Bitmap;
            
            timer.addEventListener(TimerEvent.TIMER, step);
            timer.start();
            
            h = copy.height
            w = copy.width;
            
            /*for (var i:int = 0; i < 100; i++ ) {
                step();
            }*/
            
        }
        
        private var w_tmp:int = 0;
        private var dif:Number = 0;
        private function step(e:Event = null):void {
            column -= pixel_size;
        
            if (column > 0) {
                
                dif = w - column;
                rect.width = w; 
                rect.height = pixel_size;
                
                for (var c:int = 0; c < h; c++) {
                    rect.y = c;
                    rect.x = dif;
                    canvas.fillRect(rect, copy.getPixel32(dif,c));
                }
                
            }else {
                timer.removeEventListener(TimerEvent.TIMER, step);
            }
            //addChild(o);
        }
    }
    
}
