/**
 * Copyright entermeister ( http://wonderfl.net/user/entermeister )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qy4P
 */

package
{
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.PhongMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	/**
	 * Papervision3Dの習作です。
	 */
	public class CubeTest extends BasicView
	{
		public function CubeTest()
		{
			// super class
			super(0, 0, true, true, "Target");
			
			// ライトの設定
			var light:PointLight3D = new PointLight3D(true);
			light.x = 300;
			light.y = 300;
			light.z = -300;
			
			// マテリアルの設定
			var material:PhongMaterial = new PhongMaterial(light, 0xffaa00, 0x996600, 0);
			var materialList:MaterialsList = new MaterialsList( { all:material } );
			
			// cubeを生成する。
			var cube:Cube = new Cube(materialList, 100, 100, 100);
			
			// シーンに追加する。
			scene.addChild(cube);
			
			// カメラの位置
			camera.x = 300;
			camera.y = 300;
			camera.z = 300;

			// レンダラーに任せる。
			startRendering();
		}
	}
}