/**
 * Copyright code ( http://wonderfl.net/user/code )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qxou
 */

package
{
	/*
	*ASの勉強はじめましたが、覚えることが沢山あって苦戦しております。
	*SWFProfilerを使って、メモリを調べていると、
	*山を作りながら、徐々に使用メモリが増えていってしまいます。
	*なんでー？！
	*記述も適当なため、効率的な記述がありましたら、ご教授ください。
	*
	*/
	import flash.display.*;
	import flash.events.*;

	import com.flashdynamix.utils.SWFProfiler;

	public class setSpherePosition extends Sprite
	{
		//プロパティ
		private var plane:Array;
		private var base:Sprite;
		private const RADIUS:uint = 150;
		private var myAngle:Number = Math.PI/50;	
		private var itemNumber:uint;
		private var planeWidth:uint = 5;
		private var planeHeight:uint = 5;
		private const imgMargin:uint = 50;
		private var imgWidth:uint = planeWidth + imgMargin;
		private var imgHeight:uint = planeHeight + imgMargin;
		
		private var isMouseOut:Boolean = true;
		private var axisAngle:Number=Math.PI*2/3;
		
		//コンストラクタ
		public function setSpherePosition()
		{
			//プロファイラ
			//SWFProfiler.init(stage, this);
			
			//ステージに関する情報設定
			setStage();
	
			//画像の初期配置
			setPosition();
	
			//イベントリスナー登録
			addEventListener(Event.ENTER_FRAME, loopHandler);
			stage.addEventListener(Event.RESIZE, stageResizeHandler);
			stage.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
			stage.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			
		//	stage.addEventListener(MouseEvent.CLICK, loopHandler);
		}
		
		private function setStage():void 
		{
			//基準点をステージの中心へ
			base = new Sprite();
			base.x = stage.stageWidth / 2;
			base.y = stage.stageHeight / 2;
			base.z = 0;
			base.graphics.clear();
			base.graphics.beginFill(0xffffff, 0);
			base.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
			base.graphics.endFill();
			addChild(base);			
			
			//ステージのクオリティ
			stage.quality = StageQuality.MEDIUM;
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
		}
		
		private function setPosition():void 
		{
			var unitY:int = (RADIUS * 2 * Math.PI) / 2 / imgHeight;
			var angleAlpha:Number;
			var angleBeta:Number=Math.PI/2;
			
			plane = [];
			
			itemNumber = 0;
			
			for (var i:uint = 0; i < unitY; i++)
			{
				
				angleAlpha = 0;
				
				//円周上に配置できる画像数を計算
				var alphaSets:int=Math.floor((2 * RADIUS * Math.cos(angleBeta) * Math.PI) / imgWidth);
				
				for (var j:uint = 0; j < alphaSets; j++) 
				{
					plane.push(new Sprite());
					plane[itemNumber].graphics.clear();
					plane[itemNumber].graphics.beginFill(0xffffff * Math.random(), 1);
					plane[itemNumber].graphics.drawRect( -imgWidth / 2+imgMargin/2, -imgHeight / 2+imgMargin/2, planeWidth,planeHeight);
					plane[itemNumber].graphics.endFill();
					
					plane[itemNumber].x = RADIUS * Math.cos(angleBeta) * Math.sin(angleAlpha);
					plane[itemNumber].y=RADIUS * Math.sin(angleBeta);
					plane[itemNumber].z=RADIUS * Math.cos(angleBeta) * Math.cos(angleAlpha);
					
					angleAlpha += Math.PI * 2 / alphaSets;

					base.addChild(plane[itemNumber]);
					itemNumber++;
				}
				
				angleBeta -= Math.PI / unitY;
				
			}
		}
		

		
		//イベントリスナー定義==================================================
		private function loopHandler(e:Event):void 
		{
			//回転量
			if (isMouseOut) {
				myAngle *= 0.97;
			}else {
				myAngle = -Math.min(RADIUS, Math.max(Math.abs(mouseY - stage.stageHeight / 2), Math.abs(mouseX - stage.stageWidth / 2))) / 3000;	
			}
			
			//回転軸
			axisAngle= Math.PI/2+Math.atan2((mouseY - stage.stageHeight/2), (mouseX - stage.stageWidth/2));
	
			//任意の軸の単位ベクトル
			var vx :Number= Math.cos(axisAngle);
			var vy :Number= Math.sin(axisAngle);
			
			//回転量
			var myCos:Number = Math.cos(myAngle);
			var mySin:Number = Math.sin(myAngle);
			
			//深度ソート１
			plane.sortOn("z",Array.NUMERIC | Array.DESCENDING);
			
			for (var i:uint = 0; i < itemNumber; i++)
			{
				//再配置
				base.setChildIndex(plane[i], i);

				//任意の軸での回転を計算
				var posX:Number = plane[i].x*((1 - myCos) *Math.pow(vx,2) + myCos) + plane[i].y*(vx * vy*(1 - myCos)) - plane[i].z*vy * mySin;
				var posY:Number= plane[i].x*(vx * vy*(1 - myCos)) +plane[i].y*((1 - myCos) * Math.pow(vy,2) + myCos) +plane[i].z*vx* mySin;
				var posZ:Number= plane[i].x*vy * mySin - plane[i].y*vx * mySin +plane[i].z*myCos;
				
				//移動後の座標を登録
				plane[i].x = posX;
				plane[i].y = posY;
				plane[i].z = posZ;
				
				//深度のα値
				plane[i].alpha = 1.1 - (plane[i].z / RADIUS );
				
				//ローテーション
				//全く上手くいかない、、、。
				//どなたかタスケテください。
				var ana:Number = Math.atan2(plane[i].x, plane[i].z);
				plane[i].rotationY = ana / Math.PI / 2 * 360;
				
				var anb:Number = Math.atan2(plane[i].y, plane[i].x);
				plane[i].rotationZ = anb / Math.PI / 2 * 360;
				
		
			}		
			
		}
	
		private function stageResizeHandler(e:Event):void 
		{
			base.x = stage.stageWidth / 2;
			base.y = stage.stageHeight / 2;
			base.graphics.clear();
			base.graphics.beginFill(0xffffff, 0);
			base.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
			base.graphics.endFill();
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			isMouseOut = true;
		}
				
		private function mouseOverHandler(e:MouseEvent):void 
		{
			isMouseOut = false;
		}
		
	
	}
}