/**
 * Copyright jules ( http://wonderfl.net/user/jules )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qx68
 */

// forked from tomo_mk's Map/Set - forked from: Create Polygonal Geometry 
// forked from designquest's Create Polygonal Geometry 
// Original code from : http://docs.alternativaplatform.com/display/TDEN/Building+geometry

package {
    import alternativ5.engine3d.controllers.CameraController;
    import alternativ5.engine3d.core.Camera3D;
    import alternativ5.engine3d.core.Object3D;
    import alternativ5.engine3d.core.Scene3D;
    import alternativ5.engine3d.display.View;
    import alternativ5.types.Map;
    import alternativ5.types.Point3D;
    import alternativ5.types.Set;
    import alternativ5.utils.FPS;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    [SWF(backgroundColor="#000000", frameRate="100")]

    public class GeometryTutorial extends Sprite {
        
        /*
         * Map/Setに関するすごく簡単な説明
         *
         * Bunkerを参考にしました
         * コメントはかなり適当なことを言っています
         *
         */

        private var scene:Scene3D;
        private var view:View;
        private var camera:Camera3D;
        private var cameraController:CameraController;
        
        //House extends Mesh 
        private var house:House = new House();
        private var house2:House = new House();
        
        //Map
        private var map:Map;
        
        //Sectorを識別する為の整数値
        private static const SECTOR_NONE:int = 0;
        private static const HOUSE_1:int = 1;
        private static const HOUSE_2:int = 2;
        
        //Set作成 Meshを複数投げる
        private    var houses1:Set = Set.createFromArray([house, house2]);

        public function GeometryTutorial() {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        public function init(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //Meshの値はSetに投げてからでも書き換えることが出来る
            house2.x = 100;
            
            //マップを作成する
            map = new Map();
            
            //マップにSetを投げる
            map.add(HOUSE_1, houses1);
            //map.add(HOUSE_2, houses2);
            //map.add(HOUSE_3, houses3);
            
            // Create scene
            scene = new Scene3D();
            scene.root = new Object3D();
            
            //Bunkerのデモでは、プレイヤーの現在地から どのSector（Set)のオブジェクトを表示するか判断しているようです
            //この時、Set.difference を利用すると便利です
            
            //addObjects
            addObjects(map[1]);
            
            // Add camera and view
            camera = new Camera3D();
            camera.x = 130;
            camera.y = -90;
            camera.z = 130;
            scene.root.addChild(camera);
            
            view = new View();
            addChild(view);
            view.camera = camera;

            // Add camera controller
            cameraController = new CameraController(stage);
            cameraController.camera = camera;
            cameraController.lookAt(house.coords);
            cameraController.setDefaultBindings();
            cameraController.checkCollisions = true;
            cameraController.collisionRadius = 20;
            cameraController.speed = 200;
            cameraController.controlsEnabled = true;
            
            // FPS counter init
            FPS.init(stage);

            stage.addEventListener(Event.RESIZE, onResize);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            onResize(null);
        }

        private function onResize(e:Event):void {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
        
        private function onEnterFrame(e:Event):void {
            // User input processing
            cameraController.processInput();
            // Scene calculation
            scene.calculate();
        }
        
        private function addObjects(objects:Set):void {
            for (var o:* in objects) {
                scene.root.addChild(o);
            }
        }
    }
}


// House Class

import alternativ5.engine3d.core.Mesh;
import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.engine3d.materials.WireMaterial;

class House extends Mesh {
    // Dimensions of the house
    protected var houseWidth:Number = 60;
    protected var houseLength:Number = 100;
    protected var wallsHeight:int = 60;
    protected var roofBottomWidth:int = 80;
    protected var roofBottomLength:int = 120;
    protected var roofTopWidth:int = 10;
    protected var roofTopLength:int = 60;
    protected var roofHeight:int = 30;
    
    public function House(name:String=null)    {
        super(name);

        addRectangleVertices(houseWidth, houseLength, 0, "box_bottom");
        // Create upper rectangle of the house box
        addRectangleVertices(houseWidth, houseLength, wallsHeight, "box_top");
        // Create lower rectangle of the house roof
        addRectangleVertices(roofBottomWidth, roofBottomLength, wallsHeight, "roof_bottom");
        // Create upper rectangle of the house roof
        addRectangleVertices(roofTopWidth, roofTopLength, wallsHeight + roofHeight, "roof_top");
        
        // Create faces
        var wallsFaces:Array = [];
        var roofFaces:Array = [];
        var roofBottomFaces:Array = [];
        for (var i:int = 0; i < 4; i++) {
            var j:int = (i + 1) & 3;
            wallsFaces.push(createFace(["box_bottom_" + i, "box_bottom_" + j, "box_top_" + j, "box_top_" + i], "wall_" + i));
            roofFaces.push(createFace(["roof_bottom_" + i, "roof_bottom_" + j, "roof_top_" + j, "roof_top_" + i], "roof_slope_" + i));
            roofBottomFaces.push(createFace(["roof_bottom_" + j, "roof_bottom_" + i, "box_top_" + i, "box_top_" + j], "roof_bottom_" + i));
        }
        createFace(["box_bottom_3", "box_bottom_2", "box_bottom_1", "box_bottom_0"], "box_bottom");
        roofFaces.push(createFace(["roof_top_3", "roof_top_0", "roof_top_1", "roof_top_2"], "roof_top"));
        
        // Create surfaces
        createSurface(wallsFaces, "walls");
        createSurface(roofFaces, "roof");
        createSurface(roofBottomFaces, "roof_bottom");
        createSurface(["box_bottom"], "box_bottom");
        
        setMaterials();
    }

    /**
     * Create vertices of a rectangle in the mesh
     */
    private function addRectangleVertices(rectWidth:Number, rectLength:Number, rectZ:Number, idPrefix:String):void {
        var hw:Number = rectWidth / 2;
        var hl:Number = rectLength / 2;
        createVertex(hw, hl, rectZ, idPrefix + "_0");
        createVertex(-hw, hl, rectZ, idPrefix + "_1");
        createVertex(-hw, -hl, rectZ, idPrefix + "_2");
        createVertex(hw, -hl, rectZ, idPrefix + "_3");
    }
    
    /**
     * Assign materials to surfaces
     */
    protected function setMaterials():void {
        setMaterialToSurface(new FillMaterial(0xFFFFFF * Math.random()), "walls");
        setMaterialToSurface(new WireMaterial(1, 0xFFFF00), "roof");
        setMaterialToSurface(new WireMaterial(1, 0xFF0000), "roof_bottom");
        setMaterialToSurface(new WireMaterial(1, 0x00FF00), "box_bottom");
    }
}