/**
 * Copyright ahchang ( http://wonderfl.net/user/ahchang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qwey
 */

// forked from nacookan's 3Dぐりぐり (1)
// forked from nacookan's 3D世界で横スクロール
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.geom.Point;
    
    [SWF(backgroundColor="0xffffff", frameRate="60")]
    
    public class Guriguri3D extends Sprite
    {
        private const CORNER:int = 5;
        private const RADIUS1:Number = 20;
        private const RADIUS2:Number = 10;
            
        public function Guriguri3D():void
        {
            var canvas:Sprite = new Sprite();
            
            for(var i:Number = 0; i < 500; i++)
            {                 
                var color:Number = rnd(255 * 255 * 255);
                var alpha:Number = (rnd(40) + 20) / 100;
                
                var star:Sprite = new Sprite();
                star.graphics.beginFill(color, alpha);
                var angle:Number = 2 * Math.PI / CORNER;
                var p1:Point, p2:Point;
                star.graphics.moveTo(RADIUS1, 0);
                
                for (var j:int=0; j<CORNER; j++)
                {
                    p1 = Point.polar(RADIUS2, angle * (j + 0.5));
                    p2 = Point.polar(RADIUS1, angle * (j + 1));
                    star.graphics.lineTo(p1.x, p1.y);
                    star.graphics.lineTo(p2.x, p2.y);
                }
                
                star.rotation = Math.random() * 90;
                star.x = rnd(1500);
                star.y = rnd(1500);
                star.z = rnd(100) * 20;
                canvas.addChild(star);
            }
            canvas.x = (500 - canvas.width) / 2;
            canvas.y = (500 - canvas.height) / 2;
            addChild(canvas);
            this.addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                canvas.x = (0 - canvas.width + 500) / 500 * mouseX;
                canvas.y = (0 - canvas.height + 500) / 500 * mouseY;
            });
        }
        
        private function rnd(max:Number):Number
        {
            return Math.floor(Math.random() * max);
        }
    }
}