/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qvY1
 */

// forked from FlashBum's Connect Four Layout
package {
	import flash.display.GradientType;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.display.Sprite;
 
	/**
	 * @author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
	 * 
	 * The connect four layout will take a collection of DisplayObjects and put them
	 * into columns, randomize how many items go in each column, the randomly
	 * rotate them. This is going to be used on the new FlashBum.com for random
	 * layouts.
	 *
	 * This still needs to be optimized but not bad for a quick sketch...
	 * 
	 */
	[SWF(width = '465', height = '465', frameRate = '30', backgroundColor = '#1a1a1a') ]
	public class LayoutSandbox extends Sprite {
 
		private var columnWidths : Array;
		private var columnHeights : Array;
		private var maxHeight : int;
		private var columns : Array;
		private var containerInstances : Array = new Array();
		private var space : Number = 15;
		
		private var loadedData	:XML;
		private var urlLoader:URLLoader;
 
		public function LayoutSandbox() {
 
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
 
			urlLoader = new URLLoader();
			urlLoader.addEventListener(Event.COMPLETE, onLoad);
			urlLoader.load(new URLRequest("http://flashbum.com/v4/xml/locations/eastvillage.xml"));
			
			stage.addEventListener(MouseEvent.CLICK, reset);
		}
		
		/**
		 * Clear memory and repeat
		 * @param	e
		 */
		private function reset(e:MouseEvent):void 
		{
			while (numChildren)
				removeChildAt(0);
				
			containerInstances = columnWidths = columnHeights = columns = new Array();
			graphics.clear();
			
			onLoad(null);
		}
 
		private function onLoad(event : Event) : void
		{
			loadedData = event == null ? loadedData : XML(event.target.data);
			
			graphics.lineStyle(1, 0x00ffff);
			createContainers(XML(loadedData).*);
		}
 
		private function createContainers(list : XMLList) : void {
			for each (var container : XML in list) {
				containerInstances.push(createContainer(container));
			}
 
			indexContainers();
			layoutContainers();	
		}
 
		private function layoutContainers() : void {
 
			var total : int = columns.length;
			var nextX:Number = 0;
			
			for (var i : int = 0; i < total; i++)
			{
				var totalItems : int = columns[i].length;
				var columnWidth:Number = columnWidths[i];
				var nextY:Number = Math.floor((maxHeight - columnHeights[i]) * .5);
 
				for (var j : int = 0; j < totalItems; j++)
				{
					var tempItem:DisplayObject = columns[i][j];
					center(tempItem, columnWidth);
					tempItem.x += nextX;
					tempItem.y = nextY;
					nextY += tempItem.height + space;
					addChild(tempItem);
					
					if (i || j)
					{
						var c1:DisplayObject = getChildAt(numChildren - 1);
						var c2:DisplayObject = getChildAt(numChildren - 2);
						var controlY:Number = (c1.x + c2.x) * 0.5;
						var controlX:Number = (c1.y + c2.y) * 0.5 + Math.random() * 50 - 25;
						
						graphics.curveTo(controlX, controlY, c1.x, c1.y);
					}
					else
					{
						graphics.moveTo (getChildAt(numChildren - 1).x + getChildAt(numChildren - 1).width * 0.5, getChildAt(numChildren - 1).y + getChildAt(numChildren - 1).height * 0.5);
					}
				}
 
				nextX += columnWidth + space;
			}
		}
 
		private function indexContainers() : void {
			columns = new Array();
			maxHeight = 0;
			columnWidths = new Array();
			columnHeights = new Array();
 
			var total : int = containerInstances.length;
			var counter : Number = 0;
			var column : Number = 0;
 
			for (var i : int = 0;i < total; i++) {
				var maxSelections : Number = 4;
				var selections : Number = randRange(1, maxSelections);
				var selected : Array = containerInstances.splice(0, selections);
 
				indexColumn(selected);
 
				i = 0;
				total = containerInstances.length;
				counter += selections;
				column++;
			}
 
			if(containerInstances.length > 0)
				indexColumn(containerInstances);
 
		}
 
		public function indexColumn(items : Array ) : void {
			var columnHeight : Number = 0;
			var columnWidth : Number = 0;
 
			var total : int = items.length;
 
			var currentContainer : Sprite;
			for (var i : int = 0;i < total; i++) {
				currentContainer = items[i];
				columnHeight += currentContainer.height;
				columnWidth = compareValues(currentContainer.width, columnWidth);
			}
 
			maxHeight = compareValues(columnHeight, maxHeight);
			columns.push(items);
			columnWidths.push(columnWidth);
			columnHeights.push(columnHeight);
 
		}
 
		protected function compareValues(valueA : Number, valueB : Number) : Number {
			return (valueA > valueB) ? valueA : valueB;
		}
 
		private function randRange(minNum : Number, maxNum : Number) : Number {
			return (Math.floor(Math.random() * (maxNum - minNum + 1)) + minNum);
		}
 
		private function createContainer(container : XML) : Sprite {
			var sprite : Sprite = new Sprite();
			sprite.graphics.beginFill(0xff0000, 0.9);
			sprite.graphics.drawRect(0, 0, Number(container.@w) * .3, Number(container.@h) * .3);
			sprite.graphics.endFill();
			sprite.rotation = randRange(-20, 20);
			return sprite;
		}
 
		private function center(target : DisplayObject, boundryW : Number) : void {
			target.x = (boundryW * .5) - (target.width * .5);
		}
	}
}