/**
 * Copyright seikai ( http://wonderfl.net/user/seikai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qvJM
 */

package
{
	import com.bit101.components.PushButton;
	import com.bit101.components.Text;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.net.FileReference;
	import flash.utils.ByteArray;
	
        /**
         * バイナリを16進数で表示するだけ
         * 等幅じゃないのでちょっと見辛い
         */
	[SWF(width = 465, height = 465, frameRate = 30, backgroundColor=0xFFFFFF)]
	public class BinaryReader extends Sprite
	{
		private var _file:FileReference;
		
		private var _binary:ByteArray;
		
		private var _line:uint = 0;
		
		private var _len:uint;
		
		private var _btn_sw:PushButton;
		private var _btn_up:PushButton;
		private var _btn_dw:PushButton;
		private var _tf:Text;
		
		private const LINE_NUM:uint = 30;
		
		public function BinaryReader()
		{
			if(stage) _init();
			else addEventListener(Event.ADDED_TO_STAGE, _init);
		}
		
		private function _init(e:Event=null):void
		{
			_btn_sw = new PushButton(this, 10 , 10, "load", _clickHandler);
			_btn_up = new PushButton(this, 120, 10, "up"  , _readPrev);
			_btn_dw = new PushButton(this, 230, 10, "down", _readNext);
			
			_tf = new Text(this, 10, 40);
			_tf.width = 320;
			_tf.height = 400;
                        _tf.editable = false;
			_tf.transform.colorTransform = new ColorTransform(0.97, 0.97, 0.97);
			_file = new FileReference();
		}
		
		private function _clickHandler(e:MouseEvent):void
		{
			_file.addEventListener(Event.COMPLETE, _completeHandler);
			_file.addEventListener(Event.SELECT, _selectHandler);
			_file.browse();
		}
		
		private function _selectHandler(e:Event):void
		{
			_btn_sw.removeEventListener(MouseEvent.CLICK, _clickHandler);
			_file.load();
		}
		
		private function _completeHandler(e:Event):void
		{
			_btn_sw.addEventListener(MouseEvent.CLICK, _clickHandler);
			_binary = _file.data;
			_len = _binary.length;
			_tf.text = _readBinary(0, (0 + LINE_NUM) * 16);
		}
		
		private function _readNext(e:MouseEvent):void{
			if(_line >= _len/16 - LINE_NUM) return;
			_tf.text = _readBinary((_line + LINE_NUM) * 16, (_line + 2 * LINE_NUM) *16);
			_line += LINE_NUM;
		}
		
		private function _readPrev(e:MouseEvent):void {
			if(_line <= 0) return;
			_tf.text = _readBinary((_line - LINE_NUM) * 16, _line * 16);
			_line -= LINE_NUM;
		}
		
		private function _readBinary(start:uint, end:uint):String
		{
			var a:uint;
			var s:String = "";
			end = (end > _len)? _len: end;
			for(var i:int = start;i<end;i++){
				if((i)%16 == 0) s += "#"+TextUtil.adjustNumLength((i/16 + 1).toString(16), 10) + " ";
				_binary.position = i;
				a = _binary.readUnsignedByte();
				s += TextUtil.adjustNumLength(a.toString(16), 2) +" ";
				if((i+1)%16 == 0)s += "\n";
			}
			return s;
		}
	}
}
class TextUtil{
	public static function adjustNumLength(n:String, len:uint):String {
		while(n.length < len) {
			n = "0" + n;
		}
		return n;
	}
}